/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.event.improved.entity.snapshot;

import com.graphaware.tx.event.improved.data.TransactionDataContainer;
import com.graphaware.tx.event.improved.entity.snapshot.RelationshipSnapshot;
import java.util.Iterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;

public class RelationshipSnapshotIterator
extends PrefetchingIterator<Relationship>
implements Iterator<Relationship>,
Iterable<Relationship> {
    private final Iterator<Relationship> wrappedIterator;
    private final TransactionDataContainer transactionDataContainer;
    private final Iterator<Relationship> deletedRelationshipIterator;

    public RelationshipSnapshotIterator(Node node, Iterable<Relationship> wrappedIterable, TransactionDataContainer transactionDataContainer, Direction direction, RelationshipType ... relationshipTypes) {
        this.transactionDataContainer = transactionDataContainer;
        this.deletedRelationshipIterator = transactionDataContainer.getRelationshipTransactionData().getDeleted(node, direction, relationshipTypes).iterator();
        this.wrappedIterator = transactionDataContainer.getNodeTransactionData().hasBeenDeleted(node) ? Iterators.emptyResourceIterator() : wrappedIterable.iterator();
    }

    @Override
    public Iterator<Relationship> iterator() {
        return this;
    }

    protected Relationship fetchNextOrNull() {
        while (this.wrappedIterator.hasNext()) {
            Relationship next = this.wrappedIterator.next();
            if (this.transactionDataContainer.getRelationshipTransactionData().hasBeenCreated(next)) continue;
            if (this.transactionDataContainer.getRelationshipTransactionData().hasBeenChanged(next)) {
                return (Relationship)this.transactionDataContainer.getRelationshipTransactionData().getChanged(next).getPrevious();
            }
            return new RelationshipSnapshot(next, this.transactionDataContainer);
        }
        if (this.deletedRelationshipIterator.hasNext()) {
            return this.deletedRelationshipIterator.next();
        }
        return null;
    }
}

