/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.executor.single;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.tx.executor.single.ExceptionHandlingStrategy;
import com.graphaware.tx.executor.single.RethrowException;
import com.graphaware.tx.executor.single.TransactionCallback;
import com.graphaware.tx.executor.single.TransactionExecutor;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class SimpleTransactionExecutor
implements TransactionExecutor {
    private static final Log LOG = LoggerFactory.getLogger(SimpleTransactionExecutor.class);
    private final GraphDatabaseService database;

    public SimpleTransactionExecutor(GraphDatabaseService database) {
        this.database = database;
    }

    @Override
    public <T> T executeInTransaction(TransactionCallback<T> callback) {
        return this.executeInTransaction(callback, RethrowException.getInstance());
    }

    @Override
    public <T> T executeInTransaction(TransactionCallback<T> callback, ExceptionHandlingStrategy exceptionHandlingStrategy) {
        T result = null;
        try {
            result = this.doExecuteInTransaction(callback);
        }
        catch (RuntimeException e) {
            exceptionHandlingStrategy.handleException(e);
        }
        return result;
    }

    private <T> T doExecuteInTransaction(TransactionCallback<T> callback) {
        T result = null;
        try (Transaction tx = this.database.beginTx();){
            result = callback.doInTransaction(this.database);
            tx.success();
        }
        return result;
    }
}

