/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.executor.batch;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.tx.executor.batch.DisposableBatchTransactionExecutor;
import com.graphaware.tx.executor.batch.IterableInputBatchTransactionExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.neo4j.logging.Log;

public class MultiThreadedBatchTransactionExecutor
extends DisposableBatchTransactionExecutor {
    private static final Log LOG = LoggerFactory.getLogger(MultiThreadedBatchTransactionExecutor.class);
    private final IterableInputBatchTransactionExecutor<?> wrappedExecutor;
    private final int numberOfThreads;

    public MultiThreadedBatchTransactionExecutor(IterableInputBatchTransactionExecutor<?> wrappedExecutor) {
        this(wrappedExecutor, Runtime.getRuntime().availableProcessors());
    }

    public MultiThreadedBatchTransactionExecutor(IterableInputBatchTransactionExecutor<?> wrappedExecutor, int numberOfThreads) {
        this.wrappedExecutor = wrappedExecutor;
        this.numberOfThreads = numberOfThreads;
    }

    @Override
    public void doExecute() {
        ExecutorService executorService = Executors.newFixedThreadPool(this.numberOfThreads);
        this.wrappedExecutor.populateQueue();
        for (int i = 0; i < this.numberOfThreads; ++i) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    MultiThreadedBatchTransactionExecutor.this.wrappedExecutor.processQueue();
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(1L, TimeUnit.DAYS);
            LOG.debug("Successfully executed batches using " + this.numberOfThreads + " threads.");
        }
        catch (InterruptedException e) {
            LOG.warn("Did not manage to complete batch execution within 24 hours.");
        }
    }
}

