/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.executor.input;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class GeneratedInput<T>
implements Iterable<T>,
Iterator<T> {
    private final int numberOfItems;
    private AtomicInteger generated = new AtomicInteger(0);

    protected GeneratedInput(int numberOfItems) {
        this.numberOfItems = numberOfItems;
    }

    protected abstract T generate();

    @Override
    public boolean hasNext() {
        return this.generated.get() < this.numberOfItems;
    }

    @Override
    public T next() {
        if (this.generated.incrementAndGet() > this.numberOfItems) {
            throw new NoSuchElementException("More items requested than the generator was set up to generate.");
        }
        return this.generate();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("GeneratedInput does not support removal. It has nothing to remove!");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

