/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.tx.executor.input;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.tx.executor.single.TransactionCallback;
import java.util.Iterator;
import java.util.Objects;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.logging.Log;

public class TransactionalInput<T>
extends PrefetchingIterator<T>
implements Iterable<T>,
Iterator<T> {
    private static final Log LOG = LoggerFactory.getLogger(TransactionalInput.class);
    private final GraphDatabaseService database;
    private final TransactionCallback<Iterable<T>> callback;
    private Iterator<T> iterator;
    private volatile int count = 0;
    private volatile Transaction tx;
    private final int batchSize;

    public TransactionalInput(GraphDatabaseService database, int batchSize, TransactionCallback<Iterable<T>> callback) {
        Objects.requireNonNull(database);
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize argument must be greater than zero");
        }
        Objects.requireNonNull(callback);
        this.database = database;
        this.callback = callback;
        this.batchSize = batchSize;
    }

    protected synchronized T fetchNextOrNull() {
        int i;
        this.beginTxIfNeeded();
        this.createIteratorIfNeeded();
        T next = null;
        if (this.iterator.hasNext()) {
            next = this.iterator.next();
        }
        if (next == null) {
            this.closeTx();
            return null;
        }
        if ((i = ++this.count % this.batchSize) == 0) {
            // empty if block
        }
        return next;
    }

    private void createIteratorIfNeeded() {
        if (this.iterator == null) {
            try {
                this.iterator = this.callback.doInTransaction(this.database).iterator();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void beginTxIfNeeded() {
        if (this.tx == null) {
            this.tx = this.database.beginTx();
        }
    }

    private void closeTx() {
        if (this.tx == null) {
            return;
        }
        try {
            this.tx.success();
        }
        finally {
            this.tx.close();
            this.tx = null;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

