/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.writer.neo4j;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.tx.executor.batch.IterableInputBatchTransactionExecutor;
import com.graphaware.tx.executor.batch.UnitOfWork;
import com.graphaware.writer.neo4j.Neo4jWriter;
import com.graphaware.writer.neo4j.SingleThreadedWriter;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;

public class BatchWriter
extends SingleThreadedWriter
implements Neo4jWriter {
    private static final Log LOG = LoggerFactory.getLogger(BatchWriter.class);
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private final int batchSize;

    public BatchWriter(GraphDatabaseService database) {
        super(database);
        this.batchSize = 1000;
    }

    public BatchWriter(GraphDatabaseService database, int queueCapacity, int batchSize) {
        super(database, queueCapacity);
        this.batchSize = batchSize;
    }

    @Override
    protected <T> RunnableFuture<T> createTask(Callable<T> task) {
        return new FutureTask<T>(task);
    }

    protected final void runOneIteration() throws Exception {
        if (this.queue.isEmpty()) {
            return;
        }
        LinkedList tasks = new LinkedList();
        this.queue.drainTo(tasks);
        new IterableInputBatchTransactionExecutor(this.database, this.batchSize, tasks, new UnitOfWork<RunnableFuture<?>>(){

            public void execute(GraphDatabaseService database, RunnableFuture<?> input, int batchNumber, int stepNumber) {
                BatchWriter.this.processInput(input);
            }
        }).execute();
    }

    protected void processInput(RunnableFuture<?> input) {
        try {
            input.run();
            input.get();
        }
        catch (Exception e) {
            LOG.warn("Execution threw an exception.", (Throwable)e);
        }
    }
}

