/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.writer.thirdparty;

import com.google.common.util.concurrent.Service;
import com.graphaware.common.log.LoggerFactory;
import com.graphaware.writer.service.QueueBackedScheduledService;
import com.graphaware.writer.thirdparty.ThirdPartyWriter;
import com.graphaware.writer.thirdparty.WriteOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.logging.Log;

public abstract class BaseThirdPartyWriter
extends QueueBackedScheduledService<Collection<WriteOperation<?>>>
implements ThirdPartyWriter {
    private static final Log LOG = LoggerFactory.getLogger(BaseThirdPartyWriter.class);

    protected BaseThirdPartyWriter() {
    }

    protected BaseThirdPartyWriter(int queueCapacity) {
        super(queueCapacity);
    }

    protected void runOneIteration() throws Exception {
        if (this.queue.isEmpty()) {
            return;
        }
        LinkedList tasks = new LinkedList();
        this.queue.drainTo(tasks);
        this.processOperations(tasks);
    }

    public void write(WriteOperation<?> operation, String id) {
        this.write(Collections.singleton(operation), id);
    }

    public void write(Collection<WriteOperation<?>> operations, String id) {
        this.offer(operations, id);
    }

    protected final void offer(Collection<WriteOperation<?>> operations, String id) {
        if (!(this.state().equals((Object)Service.State.NEW) || this.state().equals((Object)Service.State.STARTING) || this.state().equals((Object)Service.State.RUNNING))) {
            throw new IllegalStateException("Service is not running!");
        }
        if (!this.offer(operations)) {
            LOG.warn("Could not write task " + id + " to queue as it is too full. We're losing tasks now.");
        }
    }

    protected abstract void processOperations(List<Collection<WriteOperation<?>>> var1);

    protected final void retry(List<Collection<WriteOperation<?>>> operations) {
        Collections.reverse(operations);
        for (Collection<WriteOperation<?>> collection : operations) {
            if (this.queue.offerFirst(collection)) continue;
            LOG.warn("Could not retry failed tasks as the queue is too full. We're losing tasks now.");
        }
    }
}

