/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.writer.neo4j;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.writer.neo4j.BaseNeo4jWriter;
import java.util.concurrent.Callable;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class DefaultWriter
extends BaseNeo4jWriter {
    private static final Log LOG = LoggerFactory.getLogger(DefaultWriter.class);

    public DefaultWriter(GraphDatabaseService database) {
        super(database);
    }

    public <T> T write(Callable<T> task, String id, int waitMillis) {
        T result;
        try (Transaction tx = this.database.beginTx();){
            result = task.call();
            tx.success();
        }
        catch (Exception e) {
            LOG.warn("Execution threw and exception.", (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return result;
    }
}

