/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.writer.neo4j;

import com.google.common.util.concurrent.Service;
import com.graphaware.common.log.LoggerFactory;
import com.graphaware.writer.neo4j.Neo4jWriter;
import com.graphaware.writer.service.QueueBackedScheduledService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;

public abstract class SingleThreadedWriter
extends QueueBackedScheduledService<RunnableFuture<?>>
implements Neo4jWriter {
    private static final Log LOG = LoggerFactory.getLogger(SingleThreadedWriter.class);
    protected final GraphDatabaseService database;

    protected SingleThreadedWriter(GraphDatabaseService database) {
        this(database, 10000);
    }

    protected SingleThreadedWriter(GraphDatabaseService database, int queueCapacity) {
        super(queueCapacity);
        this.database = database;
    }

    @Override
    @PostConstruct
    public void start() {
        super.start();
    }

    @Override
    @PreDestroy
    public void stop() {
        super.stop();
    }

    public void write(Runnable task) {
        this.write(task, "UNKNOWN");
    }

    public void write(Runnable task, String id) {
        this.write(Executors.callable(task), id, 0);
    }

    public <T> T write(Callable<T> task, String id, int waitMillis) {
        return this.offer(task, id, waitMillis);
    }

    protected final <T> T offer(Callable<T> task, String id, int waitMillis) {
        if (!(this.state().equals((Object)Service.State.NEW) || this.state().equals((Object)Service.State.STARTING) || this.state().equals((Object)Service.State.RUNNING))) {
            throw new IllegalStateException("Service is not running!");
        }
        RunnableFuture<T> futureTask = this.createTask(task);
        if (!this.offer(futureTask)) {
            LOG.warn("Could not write task " + id + " to queue as it is too full. We're losing taks now.");
            return null;
        }
        if (waitMillis <= 0) {
            return null;
        }
        return this.block(futureTask, id, waitMillis);
    }

    protected abstract <T> RunnableFuture<T> createTask(Callable<T> var1);

    protected final <T> T block(RunnableFuture<T> futureTask, String id, int waitMillis) {
        try {
            return (T)futureTask.get(waitMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Waiting for execution of a task was interrupted. ID: " + id, (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.warn("Execution of a task threw an exception. ID: " + id, (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (TimeoutException e) {
            LOG.warn("Task didn't get executed within " + waitMillis + "ms. ID: " + id);
        }
        return null;
    }
}

