/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.writer.neo4j;

import com.graphaware.common.log.LoggerFactory;
import com.graphaware.writer.neo4j.Neo4jWriter;
import com.graphaware.writer.neo4j.SingleThreadedWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;

public class TxPerTaskWriter
extends SingleThreadedWriter
implements Neo4jWriter {
    private static final Log LOG = LoggerFactory.getLogger(TxPerTaskWriter.class);

    public TxPerTaskWriter(GraphDatabaseService database) {
        super(database);
    }

    public TxPerTaskWriter(GraphDatabaseService database, int queueCapacity) {
        super(database, queueCapacity);
    }

    @Override
    protected <T> RunnableFuture<T> createTask(final Callable<T> task) {
        return new FutureTask(new Callable<T>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public T call() {
                try (Transaction tx = TxPerTaskWriter.this.database.beginTx();){
                    Object result = task.call();
                    tx.success();
                    Object v = result;
                    return v;
                }
                catch (Exception e) {
                    LOG.warn("Execution threw and exception.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected void runOneIteration() throws Exception {
        try {
            RunnableFuture r = (RunnableFuture)this.queue.poll();
            if (r == null) {
                return;
            }
            while (r != null) {
                r.run();
                r = (RunnableFuture)this.queue.poll();
            }
        }
        catch (Exception e) {
            LOG.error("Error running from the queue", (Throwable)e);
        }
    }
}

