/*
 * Decompiled with CFR 0.152.
 */
package com.graphaware.writer.service;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.graphaware.common.log.LoggerFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.neo4j.logging.Log;

public abstract class QueueBackedScheduledService<E>
extends AbstractScheduledService {
    private static final Log LOG = LoggerFactory.getLogger(QueueBackedScheduledService.class);
    private static final int LOGGING_INTERVAL_MS = 5000;
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    private final int queueCapacity;
    protected final LinkedBlockingDeque<E> queue;
    private final ScheduledExecutorService queueSizeLogger = Executors.newSingleThreadScheduledExecutor();

    protected QueueBackedScheduledService() {
        this(10000);
    }

    protected QueueBackedScheduledService(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        this.queue = new LinkedBlockingDeque(queueCapacity);
    }

    public void start() {
        this.startAsync();
        this.awaitRunning();
        this.queueSizeLogger.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (QueueBackedScheduledService.this.logEmptyQueue() || !QueueBackedScheduledService.this.queue.isEmpty()) {
                    LOG.info("Queue size: " + QueueBackedScheduledService.this.queue.size());
                }
            }
        }, 5L, this.loggingFrequencyMs(), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.queueSizeLogger.shutdownNow();
        this.stopAsync();
        this.awaitTerminated();
    }

    protected void shutDown() throws Exception {
        this.runOneIteration();
    }

    protected boolean offer(E futureTask) {
        return this.queue.offer(futureTask);
    }

    protected boolean logEmptyQueue() {
        return false;
    }

    protected long loggingFrequencyMs() {
        return 5000L;
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)0L, (long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        QueueBackedScheduledService that = (QueueBackedScheduledService)((Object)o);
        return this.queueCapacity == that.queueCapacity;
    }

    public int hashCode() {
        return this.queueCapacity;
    }
}

