/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ReaderElement {
    private final long id;
    private final Type type;
    private final Map<String, Object> properties;

    protected ReaderElement(long id, Type type) {
        this(id, type, new LinkedHashMap<String, Object>(4));
    }

    protected ReaderElement(long id, Type type, Map<String, Object> properties) {
        if (id < 0L) {
            throw new IllegalArgumentException("Invalid OSM " + type + " Id: " + id + "; Ids must not be negative");
        }
        this.id = id;
        this.type = type;
        this.properties = properties;
    }

    public long getId() {
        return this.id;
    }

    protected String tagsToString() {
        if (this.properties.isEmpty()) {
            return "<empty>";
        }
        StringBuilder tagTxt = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            tagTxt.append(entry.getKey());
            tagTxt.append("=");
            tagTxt.append(entry.getValue());
            tagTxt.append("\n");
        }
        return tagTxt.toString();
    }

    public Map<String, Object> getTags() {
        return this.properties;
    }

    public void setTags(Map<String, Object> newTags) {
        this.properties.clear();
        if (newTags != null) {
            for (Map.Entry<String, Object> e : newTags.entrySet()) {
                this.setTag(e.getKey(), e.getValue());
            }
        }
    }

    public boolean hasTags() {
        return !this.properties.isEmpty();
    }

    public String getTag(String name) {
        return (String)this.properties.get(name);
    }

    public <T> T getTag(String key, T defaultValue) {
        Object val = this.properties.get(key);
        if (val == null) {
            return defaultValue;
        }
        return (T)val;
    }

    public void setTag(String name, Object value) {
        this.properties.put(name, value);
    }

    public boolean hasTag(String key, Object value) {
        return value.equals(this.getTag(key, ""));
    }

    public boolean hasTag(String key, String ... values) {
        Object value = this.properties.get(key);
        if (value == null) {
            return false;
        }
        if (values.length == 0) {
            return true;
        }
        for (String val : values) {
            if (!val.equals(value)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasTag(String key, Collection<String> values) {
        return values.contains(this.getTag(key, ""));
    }

    public boolean hasTag(List<String> keyList, Collection<String> values) {
        for (String key : keyList) {
            if (!values.contains(this.getTag(key, ""))) continue;
            return true;
        }
        return false;
    }

    public boolean hasTag(List<String> keyList, Object value) {
        for (String key : keyList) {
            if (!value.equals(this.getTag(key, null))) continue;
            return true;
        }
        return false;
    }

    public String getFirstValue(List<String> searchedTags) {
        for (String str : searchedTags) {
            Object value = this.properties.get(str);
            if (value == null) continue;
            return (String)value;
        }
        return "";
    }

    public int getFirstIndex(List<String> searchedTags) {
        for (int i = 0; i < searchedTags.size(); ++i) {
            String str = searchedTags.get(i);
            Object value = this.properties.get(str);
            if (value == null) continue;
            return i;
        }
        return -1;
    }

    public void removeTag(String name) {
        this.properties.remove(name);
    }

    public void clearTags() {
        this.properties.clear();
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.properties.toString();
    }

    public static enum Type {
        NODE,
        WAY,
        RELATION,
        FILEHEADER;

    }
}

