/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.AbstractTiffElevationProvider;
import com.graphhopper.util.Helper;
import java.awt.image.Raster;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.xmlgraphics.image.codec.tiff.TIFFDecodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFImageDecoder;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;

public class GMTEDProvider
extends AbstractTiffElevationProvider {
    private final String FILE_NAME_END = "_20101117_gmted_mea075";

    public GMTEDProvider() {
        this("");
    }

    public GMTEDProvider(String cacheDir) {
        super("https://edcintl.cr.usgs.gov/downloads/sciweb1/shared/topo/downloads/GMTED/Global_tiles_GMTED/075darcsec/mea/", cacheDir.isEmpty() ? "/tmp/gmted" : cacheDir, "GraphHopper GMTEDReader", 14400, 9600, 20, 30);
    }

    public static void main(String[] args) {
        GMTEDProvider provider = new GMTEDProvider();
        System.out.println(provider.getEle(46.0, -20.0));
        System.out.println(provider.getEle(49.949784, 11.57517));
        System.out.println(provider.getEle(49.968668, 11.575127));
        System.out.println(provider.getEle(49.968682, 11.574842));
        System.out.println(provider.getEle(-22.532854, -65.110474));
        System.out.println(provider.getEle(38.065392, -87.099609));
        System.out.println(provider.getEle(40.0, -105.2277023));
        System.out.println(provider.getEle(39.99999999, -105.2277023));
        System.out.println(provider.getEle(39.9999999, -105.2277023));
        System.out.println(provider.getEle(39.999999, -105.2277023));
        System.out.println(provider.getEle(47.468668, 14.575127));
        System.out.println(provider.getEle(47.467753, 14.573911));
        System.out.println(provider.getEle(46.468835, 12.578777));
        System.out.println(provider.getEle(48.469123, 9.576393));
        provider.setInterpolate(true);
        System.out.println(provider.getEle(47.467753, 14.573911));
        System.out.println(provider.getEle(29.840644, -42.890625));
    }

    @Override
    Raster readFile(File file, String tifName) {
        Raster raster;
        block5: {
            SeekableStream ss = null;
            try {
                FileInputStream is = new FileInputStream(file);
                ss = SeekableStream.wrapInputStream((InputStream)is, (boolean)true);
                TIFFImageDecoder imageDecoder = new TIFFImageDecoder(ss, new TIFFDecodeParam());
                raster = imageDecoder.decodeAsRaster();
                if (ss == null) break block5;
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Can't decode " + file.getName(), e);
                }
                catch (Throwable throwable) {
                    if (ss != null) {
                        Helper.close(ss);
                    }
                    throw throwable;
                }
            }
            Helper.close((Closeable)ss);
        }
        return raster;
    }

    @Override
    int getMinLatForTile(double lat) {
        return (int)(Math.floor((90.0 + lat) / (double)this.LAT_DEGREE) * (double)this.LAT_DEGREE) - 90;
    }

    @Override
    int getMinLonForTile(double lon) {
        return (int)(Math.floor((180.0 + lon) / (double)this.LON_DEGREE) * (double)this.LON_DEGREE) - 180;
    }

    private String getLonString(int lonInt) {
        Object lonString;
        Object object = lonString = (lonInt = Math.abs(lonInt)) < 100 ? "0" : "";
        if (lonInt < 10) {
            lonString = (String)lonString + "0";
        }
        lonString = (String)lonString + lonInt;
        return lonString;
    }

    private String getLatString(int latInt) {
        Object latString = (latInt = Math.abs(latInt)) < 10 ? "0" : "";
        latString = (String)latString + latInt;
        return latString;
    }

    @Override
    boolean isOutsideSupportedArea(double lat, double lon) {
        return lat > 84.0 || lat < -70.0;
    }

    @Override
    String getFileName(double lat, double lon) {
        int lonInt = this.getMinLonForTile(lon);
        int latInt = this.getMinLatForTile(lat);
        return Helper.toLowerCase((String)(this.getLatString(latInt) + this.getNorthString(latInt) + this.getLonString(lonInt) + this.getEastString(lonInt) + "_20101117_gmted_mea075"));
    }

    @Override
    String getDownloadURL(double lat, double lon) {
        int lonInt = this.getMinLonForTile(lon);
        int latInt = this.getMinLatForTile(lat);
        String east = this.getEastString(lonInt);
        String lonString = this.getLonString(lonInt);
        return this.baseUrl + "/" + east + lonString + "/" + this.getLatString(latInt) + this.getNorthString(latInt) + lonString + east + "_20101117_gmted_mea075.tif";
    }

    @Override
    String getFileNameOfLocalFile(double lat, double lon) {
        return this.getFileName(lat, lon) + ".tif";
    }

    private String getNorthString(int lat) {
        if (lat < 0) {
            return "S";
        }
        return "N";
    }

    private String getEastString(int lon) {
        if (lon < 0) {
            return "W";
        }
        return "E";
    }

    public String toString() {
        return "gmted";
    }
}

