/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.osm.OSMRestrictionException;
import com.graphhopper.reader.osm.RestrictionMembers;
import com.graphhopper.reader.osm.RestrictionTopology;
import com.graphhopper.reader.osm.RestrictionType;
import com.graphhopper.reader.osm.Triple;
import com.graphhopper.reader.osm.WayToEdgeConverter;
import com.graphhopper.routing.util.parsers.RestrictionSetter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSMRestrictionConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSMRestrictionConverter.class);
    private static final long[] EMPTY_LONG_ARRAY_LIST = new long[0];

    public static boolean isTurnRestriction(ReaderRelation relation) {
        return "restriction".equals(relation.getTag("type"));
    }

    public static long[] getRestrictedWayIds(ReaderRelation relation) {
        if (!OSMRestrictionConverter.isTurnRestriction(relation)) {
            return EMPTY_LONG_ARRAY_LIST;
        }
        return relation.getMembers().stream().filter(m -> m.getType() == ReaderElement.Type.WAY).filter(m -> "from".equals(m.getRole()) || "via".equals(m.getRole()) || "to".equals(m.getRole())).mapToLong(ReaderRelation.Member::getRef).toArray();
    }

    public static long getViaNodeIfViaNodeRestriction(ReaderRelation relation) {
        return relation.getMembers().stream().filter(m -> m.getType().equals((Object)ReaderElement.Type.NODE)).filter(m -> "via".equals(m.getRole())).mapToLong(ReaderRelation.Member::getRef).findFirst().orElse(-1L);
    }

    public static Triple<ReaderRelation, RestrictionTopology, RestrictionMembers> buildRestrictionTopologyForGraph(BaseGraph baseGraph, ReaderRelation relation, LongFunction<Iterator<IntCursor>> edgesByWay) throws OSMRestrictionException {
        if (!OSMRestrictionConverter.isTurnRestriction(relation)) {
            throw new IllegalArgumentException("expected a turn restriction: " + relation.getTags());
        }
        RestrictionMembers restrictionMembers = OSMRestrictionConverter.extractMembers(relation);
        if (!OSMRestrictionConverter.membersExist(restrictionMembers, edgesByWay, relation)) {
            throw OSMRestrictionException.withoutWarning();
        }
        WayToEdgeConverter wayToEdgeConverter = new WayToEdgeConverter(baseGraph, edgesByWay);
        if (restrictionMembers.isViaWay()) {
            if (OSMRestrictionConverter.containsDuplicateWays(restrictionMembers)) {
                throw new OSMRestrictionException("contains duplicate from-/via-/to-members");
            }
            WayToEdgeConverter.EdgeResult res = wayToEdgeConverter.convertForViaWays(restrictionMembers.getFromWays(), restrictionMembers.getViaWays(), restrictionMembers.getToWays());
            return new Triple<ReaderRelation, RestrictionTopology, RestrictionMembers>(relation, RestrictionTopology.way(res.getFromEdges(), res.getViaEdges(), res.getToEdges(), res.getNodes()), restrictionMembers);
        }
        int viaNode = relation.getTag("graphhopper:via_node", -1);
        if (viaNode < 0) {
            throw new IllegalStateException("For some reason we did not set graphhopper:via_node for this relation: " + relation.getId());
        }
        WayToEdgeConverter.NodeResult res = wayToEdgeConverter.convertForViaNode(restrictionMembers.getFromWays(), viaNode, restrictionMembers.getToWays());
        return new Triple<ReaderRelation, RestrictionTopology, RestrictionMembers>(relation, RestrictionTopology.node(res.getFromEdges(), viaNode, res.getToEdges()), restrictionMembers);
    }

    private static boolean containsDuplicateWays(RestrictionMembers restrictionMembers) {
        LongArrayList allWays = restrictionMembers.getAllWays();
        LongHashSet uniqueWays = new LongHashSet((LongContainer)allWays);
        return uniqueWays.size() != allWays.size();
    }

    private static boolean membersExist(RestrictionMembers members, LongFunction<Iterator<IntCursor>> edgesByWay, ReaderRelation relation) {
        for (LongCursor c : members.getAllWays()) {
            if (edgesByWay.apply(c.value).hasNext()) continue;
            LOGGER.debug("Restriction relation " + relation.getId() + " uses excluded way " + c.value + ". Relation ignored.");
            return false;
        }
        return true;
    }

    public static void checkIfTopologyIsCompatibleWithRestriction(RestrictionTopology g, String restriction) throws OSMRestrictionException {
        if (g.getFromEdges().size() > 1 && !"no_entry".equals(restriction)) {
            throw new OSMRestrictionException("has multiple members with role 'from' even though it is not a 'no_entry' restriction");
        }
        if (g.getToEdges().size() > 1 && !"no_exit".equals(restriction)) {
            throw new OSMRestrictionException("has multiple members with role 'to' even though it is not a 'no_exit' restriction");
        }
    }

    public static RestrictionMembers extractMembers(ReaderRelation relation) throws OSMRestrictionException {
        long viaOSMNode = -1L;
        LongArrayList fromWays = new LongArrayList();
        LongArrayList viaWays = new LongArrayList();
        LongArrayList toWays = new LongArrayList();
        for (ReaderRelation.Member member : relation.getMembers()) {
            if ("from".equals(member.getRole())) {
                if (member.getType() != ReaderElement.Type.WAY) {
                    throw new OSMRestrictionException("has a member with role 'from' and type '" + member.getType() + "', but it should be of type 'way'");
                }
                fromWays.add(member.getRef());
                continue;
            }
            if ("to".equals(member.getRole())) {
                if (member.getType() != ReaderElement.Type.WAY) {
                    throw new OSMRestrictionException("has a member with role 'to' and type '" + member.getType() + "', but it should be of type 'way'");
                }
                toWays.add(member.getRef());
                continue;
            }
            if ("via".equals(member.getRole())) {
                if (member.getType() == ReaderElement.Type.NODE) {
                    if (viaOSMNode >= 0L) {
                        throw new OSMRestrictionException("has multiple members with role 'via' and type 'node', but multiple via-members are only allowed when they are of type: 'way'");
                    }
                    viaOSMNode = member.getRef();
                    continue;
                }
                if (member.getType() == ReaderElement.Type.WAY) {
                    viaWays.add(member.getRef());
                    continue;
                }
                throw new OSMRestrictionException("has a member with role 'via' and type '" + member.getType() + "', but it should be of type 'node' or 'way'");
            }
            if ("location_hint".equals(member.getRole())) continue;
            if (member.getRole().trim().isEmpty()) {
                throw new OSMRestrictionException("has a member with an empty role");
            }
            throw new OSMRestrictionException("has a member with an unknown role '" + member.getRole() + "'");
        }
        if (fromWays.isEmpty() && toWays.isEmpty()) {
            throw new OSMRestrictionException("has no member with role 'from' and 'to'");
        }
        if (fromWays.isEmpty()) {
            throw new OSMRestrictionException("has no member with role 'from'");
        }
        if (toWays.isEmpty()) {
            throw new OSMRestrictionException("has no member with role 'to'");
        }
        if (fromWays.size() > 1 && toWays.size() > 1) {
            throw new OSMRestrictionException("has multiple members with role 'from' and 'to'");
        }
        OSMRestrictionConverter.checkTags(fromWays, toWays, relation.getTags());
        if (viaOSMNode >= 0L && !viaWays.isEmpty()) {
            throw new OSMRestrictionException("has members with role 'via' of type 'node' and 'way', but only one type is allowed");
        }
        if (viaOSMNode >= 0L) {
            return RestrictionMembers.viaNode(viaOSMNode, fromWays, toWays);
        }
        if (!viaWays.isEmpty()) {
            return RestrictionMembers.viaWay(fromWays, viaWays, toWays);
        }
        throw new OSMRestrictionException("has no member with role 'via'");
    }

    private static void checkTags(LongArrayList fromWays, LongArrayList toWays, Map<String, Object> tags) throws OSMRestrictionException {
        boolean hasNoEntry = false;
        boolean hasNoExit = false;
        for (Map.Entry<String, Object> e : tags.entrySet()) {
            if (!e.getKey().startsWith("restriction")) continue;
            if (e.getValue() != null && ((String)e.getValue()).startsWith("no_entry")) {
                hasNoEntry = true;
            }
            if (e.getValue() == null || !((String)e.getValue()).startsWith("no_exit")) continue;
            hasNoExit = true;
        }
        if (fromWays.size() > 1 && !hasNoEntry) {
            throw new OSMRestrictionException("has multiple members with role 'from' even though it is not a 'no_entry' restriction");
        }
        if (toWays.size() > 1 && !hasNoExit) {
            throw new OSMRestrictionException("has multiple members with role 'to' even though it is not a 'no_exit' restriction");
        }
    }

    public static List<RestrictionSetter.Restriction> buildRestrictionsForOSMRestriction(BaseGraph baseGraph, RestrictionTopology topology, RestrictionType type) {
        ArrayList<RestrictionSetter.Restriction> result = new ArrayList<RestrictionSetter.Restriction>();
        if (type == RestrictionType.NO) {
            if (topology.isViaWayRestriction()) {
                for (IntCursor fromEdge : topology.getFromEdges()) {
                    for (IntCursor toEdge : topology.getToEdges()) {
                        IntArrayList edges = new IntArrayList(topology.getViaEdges().size() + 2);
                        edges.add(fromEdge.value);
                        edges.addAll((IntContainer)topology.getViaEdges());
                        edges.add(toEdge.value);
                        result.add(RestrictionSetter.createViaEdgeRestriction(edges));
                    }
                }
            } else {
                for (IntCursor fromEdge : topology.getFromEdges()) {
                    for (IntCursor toEdge : topology.getToEdges()) {
                        result.add(RestrictionSetter.createViaNodeRestriction(fromEdge.value, topology.getViaNodes().get(0), toEdge.value));
                    }
                }
            }
        } else if (type == RestrictionType.ONLY) {
            if (topology.getFromEdges().size() > 1 || topology.getToEdges().size() > 1) {
                throw new IllegalArgumentException("'Only' restrictions with multiple from- or to- edges are not supported");
            }
            if (topology.isViaWayRestriction()) {
                result.addAll(OSMRestrictionConverter.createRestrictionsForViaEdgeOnlyRestriction(baseGraph, topology));
            } else {
                result.addAll(OSMRestrictionConverter.createRestrictionsForViaNodeOnlyRestriction(baseGraph.createEdgeExplorer(), topology.getFromEdges().get(0), topology.getViaNodes().get(0), topology.getToEdges().get(0)));
            }
        } else {
            throw new IllegalArgumentException("Unexpected restriction type: " + type);
        }
        return result;
    }

    private static IntArrayList collectEdges(RestrictionTopology r) {
        IntArrayList result = new IntArrayList(r.getViaEdges().size() + 2);
        result.add(r.getFromEdges().get(0));
        result.addAll((IntContainer)r.getViaEdges());
        result.add(r.getToEdges().get(0));
        return result;
    }

    private static List<RestrictionSetter.Restriction> createRestrictionsForViaNodeOnlyRestriction(EdgeExplorer edgeExplorer, int fromEdge, int viaNode, int toEdge) {
        ArrayList<RestrictionSetter.Restriction> result = new ArrayList<RestrictionSetter.Restriction>();
        EdgeIterator iter = edgeExplorer.setBaseNode(viaNode);
        while (iter.next()) {
            if (iter.getEdge() == toEdge || iter.getEdge() == fromEdge) continue;
            result.add(RestrictionSetter.createViaNodeRestriction(fromEdge, viaNode, iter.getEdge()));
        }
        return result;
    }

    private static List<RestrictionSetter.Restriction> createRestrictionsForViaEdgeOnlyRestriction(BaseGraph graph, RestrictionTopology topology) {
        if (topology.getViaEdges().isEmpty()) {
            throw new IllegalArgumentException("Via-edge restrictions must have at least one via-edge");
        }
        EdgeExplorer explorer = graph.createEdgeExplorer();
        IntArrayList edges = OSMRestrictionConverter.collectEdges(topology);
        List<RestrictionSetter.Restriction> result = OSMRestrictionConverter.createRestrictionsForViaNodeOnlyRestriction(explorer, edges.get(0), topology.getViaNodes().get(0), edges.get(1));
        for (int i = 2; i < edges.size(); ++i) {
            EdgeIterator iter = explorer.setBaseNode(topology.getViaNodes().get(i - 1));
            while (iter.next()) {
                if (iter.getEdge() == edges.get(i) || iter.getEdge() == edges.get(i - 1)) continue;
                IntArrayList restriction = new IntArrayList(i + 1);
                for (int j = 0; j < i; ++j) {
                    restriction.add(edges.get(j));
                }
                restriction.add(iter.getEdge());
                if (restriction.size() == 3 && restriction.get(0) == restriction.get(restriction.size() - 1)) continue;
                result.add(RestrictionSetter.createViaEdgeRestriction(restriction));
            }
        }
        return result;
    }
}

