/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.IntArrayList;

public class RestrictionTopology {
    private final boolean isViaWayRestriction;
    private final IntArrayList viaNodes;
    private final IntArrayList fromEdges;
    private final IntArrayList viaEdges;
    private final IntArrayList toEdges;

    public static RestrictionTopology node(int fromEdge, int viaNode, int toEdge) {
        return RestrictionTopology.node(IntArrayList.from((int[])new int[]{fromEdge}), viaNode, IntArrayList.from((int[])new int[]{toEdge}));
    }

    public static RestrictionTopology node(IntArrayList fromEdges, int viaNode, IntArrayList toEdges) {
        return new RestrictionTopology(false, IntArrayList.from((int[])new int[]{viaNode}), fromEdges, null, toEdges);
    }

    public static RestrictionTopology way(int fromEdge, int viaEdge, int toEdge, IntArrayList viaNodes) {
        return RestrictionTopology.way(fromEdge, IntArrayList.from((int[])new int[]{viaEdge}), toEdge, viaNodes);
    }

    public static RestrictionTopology way(int fromEdge, IntArrayList viaEdges, int toEdge, IntArrayList viaNodes) {
        return RestrictionTopology.way(IntArrayList.from((int[])new int[]{fromEdge}), viaEdges, IntArrayList.from((int[])new int[]{toEdge}), viaNodes);
    }

    public static RestrictionTopology way(IntArrayList fromEdges, IntArrayList viaEdges, IntArrayList toEdges, IntArrayList viaNodes) {
        return new RestrictionTopology(true, viaNodes, fromEdges, viaEdges, toEdges);
    }

    private RestrictionTopology(boolean isViaWayRestriction, IntArrayList viaNodes, IntArrayList fromEdges, IntArrayList viaEdges, IntArrayList toEdges) {
        if (fromEdges.size() > 1 && toEdges.size() > 1) {
            throw new IllegalArgumentException("fromEdges and toEdges cannot be size > 1 at the same time");
        }
        if (fromEdges.isEmpty() || toEdges.isEmpty()) {
            throw new IllegalArgumentException("fromEdges and toEdges must not be empty");
        }
        if (!isViaWayRestriction && viaNodes.size() != 1) {
            throw new IllegalArgumentException("for node restrictions there must be exactly one via node");
        }
        if (!isViaWayRestriction && viaEdges != null) {
            throw new IllegalArgumentException("for node restrictions the viaEdges must be null");
        }
        if (isViaWayRestriction && viaEdges.isEmpty()) {
            throw new IllegalArgumentException("for way restrictions there must at least one via edge");
        }
        if (isViaWayRestriction && viaNodes.size() != viaEdges.size() + 1) {
            throw new IllegalArgumentException("for way restrictions there must be one via node more than there are via edges");
        }
        this.isViaWayRestriction = isViaWayRestriction;
        this.viaNodes = viaNodes;
        this.fromEdges = fromEdges;
        this.viaEdges = viaEdges;
        this.toEdges = toEdges;
    }

    public boolean isViaWayRestriction() {
        return this.isViaWayRestriction;
    }

    public IntArrayList getViaNodes() {
        return this.viaNodes;
    }

    public IntArrayList getFromEdges() {
        return this.fromEdges;
    }

    public IntArrayList getViaEdges() {
        return this.viaEdges;
    }

    public IntArrayList getToEdges() {
        return this.toEdges;
    }
}

