/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.osm.conditional.ConditionalValueParser;
import com.graphhopper.reader.osm.conditional.DateRange;
import com.graphhopper.reader.osm.conditional.ParsedCalendar;
import com.graphhopper.util.Helper;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class DateRangeParser
implements ConditionalValueParser {
    private static final DateFormat YEAR_MONTH_DAY_DF = DateRangeParser.create3CharMonthFormatter("yyyy MMM dd");
    private static final DateFormat MONTH_DAY_DF = DateRangeParser.create3CharMonthFormatter("MMM dd");
    private static final DateFormat MONTH_DAY2_DF = Helper.createFormatter((String)"dd.MM");
    private static final DateFormat YEAR_MONTH_DF = DateRangeParser.create3CharMonthFormatter("yyyy MMM");
    private static final DateFormat MONTH_DF = DateRangeParser.create3CharMonthFormatter("MMM");
    private static final List<String> DAY_NAMES = Arrays.asList("Su", "Mo", "Tu", "We", "Th", "Fr", "Sa");
    private Calendar date;

    DateRangeParser() {
        this(DateRangeParser.createCalendar());
    }

    public DateRangeParser(Calendar date) {
        this.date = date;
    }

    public static Calendar createCalendar() {
        return Calendar.getInstance(Helper.UTC, Locale.US);
    }

    static ParsedCalendar parseDateString(String dateString) throws ParseException {
        ParsedCalendar parsedCalendar;
        dateString = dateString.replaceAll("(,( )*)?(PH|SH)", "");
        dateString = dateString.trim();
        Calendar calendar = DateRangeParser.createCalendar();
        try {
            calendar.setTime(YEAR_MONTH_DAY_DF.parse(dateString));
            parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.YEAR_MONTH_DAY, calendar);
        }
        catch (ParseException e1) {
            try {
                calendar.setTime(MONTH_DAY_DF.parse(dateString));
                parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.MONTH_DAY, calendar);
            }
            catch (ParseException e2) {
                try {
                    calendar.setTime(MONTH_DAY2_DF.parse(dateString));
                    parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.MONTH_DAY, calendar);
                }
                catch (ParseException e3) {
                    try {
                        calendar.setTime(YEAR_MONTH_DF.parse(dateString));
                        parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.YEAR_MONTH, calendar);
                    }
                    catch (ParseException e4) {
                        try {
                            calendar.setTime(MONTH_DF.parse(dateString));
                            parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.MONTH, calendar);
                        }
                        catch (ParseException e5) {
                            int index = DAY_NAMES.indexOf(dateString);
                            if (index < 0) {
                                throw new ParseException("Unparsable date: \"" + dateString + "\"", 0);
                            }
                            calendar.set(7, index + 1);
                            parsedCalendar = new ParsedCalendar(ParsedCalendar.ParseType.DAY, calendar);
                        }
                    }
                }
            }
        }
        return parsedCalendar;
    }

    DateRange getRange(String dateRangeString) throws ParseException {
        if (dateRangeString == null || dateRangeString.isEmpty()) {
            return null;
        }
        String[] dateArr = dateRangeString.split("-");
        if (dateArr.length > 2 || dateArr.length < 1) {
            return null;
        }
        ParsedCalendar from = DateRangeParser.parseDateString(dateArr[0]);
        ParsedCalendar to = dateArr.length == 2 ? DateRangeParser.parseDateString(dateArr[1]) : DateRangeParser.parseDateString(dateArr[0]);
        try {
            return new DateRange(from, to);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public ConditionalValueParser.ConditionState checkCondition(String dateRangeString) throws ParseException {
        DateRange dr = this.getRange(dateRangeString);
        if (dr == null) {
            return ConditionalValueParser.ConditionState.INVALID;
        }
        if (dr.isInRange(this.date)) {
            return ConditionalValueParser.ConditionState.TRUE;
        }
        return ConditionalValueParser.ConditionState.FALSE;
    }

    public static DateRangeParser createInstance(String day) {
        Calendar calendar = DateRangeParser.createCalendar();
        try {
            if (!day.isEmpty()) {
                calendar.setTime(Helper.createFormatter((String)"yyyy-MM-dd").parse(day));
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
        return new DateRangeParser(calendar);
    }

    private static SimpleDateFormat create3CharMonthFormatter(String pattern) {
        DateFormatSymbols formatSymbols = new DateFormatSymbols(Locale.ENGLISH);
        formatSymbols.setShortMonths(new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"});
        SimpleDateFormat df = new SimpleDateFormat(pattern, formatSymbols);
        df.setTimeZone(Helper.UTC);
        return df;
    }
}

