/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.config.Profile;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.TurnRestriction;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.DefaultTurnCostProvider;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.TurnCostsConfig;

public class DefaultWeightingFactory
implements WeightingFactory {
    private final BaseGraph graph;
    private final EncodingManager encodingManager;

    public DefaultWeightingFactory(BaseGraph graph, EncodingManager encodingManager) {
        this.graph = graph;
        this.encodingManager = encodingManager;
    }

    @Override
    public Weighting createWeighting(Profile profile, PMap requestHints, boolean disableTurnCosts) {
        TurnCostProvider turnCostProvider;
        PMap hints = new PMap();
        hints.putAll(profile.getHints());
        hints.putAll(requestHints);
        if (profile.hasTurnCosts() && !disableTurnCosts) {
            DecimalEncodedValue oEnc;
            BooleanEncodedValue turnRestrictionEnc = this.encodingManager.getTurnBooleanEncodedValue(TurnRestriction.key(profile.getName()));
            if (turnRestrictionEnc == null) {
                throw new IllegalArgumentException("Cannot find turn restriction encoded value for " + profile.getName());
            }
            DecimalEncodedValue decimalEncodedValue = oEnc = this.encodingManager.hasEncodedValue("orientation") ? this.encodingManager.getDecimalEncodedValue("orientation") : null;
            if (profile.getTurnCostsConfig().hasLeftRightStraightCosts() && oEnc == null) {
                throw new IllegalArgumentException("Using left_turn_costs,sharp_left_turn_costs,right_turn_costs,sharp_right_turn_costs or straight_costs for turn_costs requires 'orientation' in graph.encoded_values");
            }
            int uTurnCosts = hints.getInt("u_turn_costs", profile.getTurnCostsConfig().getUTurnCosts());
            TurnCostsConfig tcConfig = new TurnCostsConfig(profile.getTurnCostsConfig()).setUTurnCosts(uTurnCosts);
            turnCostProvider = new DefaultTurnCostProvider(turnRestrictionEnc, oEnc, this.graph, tcConfig);
        } else {
            turnCostProvider = TurnCostProvider.NO_TURN_COST_PROVIDER;
        }
        String weightingStr = Helper.toLowerCase((String)profile.getWeighting());
        if (weightingStr.isEmpty()) {
            throw new IllegalArgumentException("You have to specify a weighting");
        }
        Weighting weighting = null;
        if ("custom".equalsIgnoreCase(weightingStr)) {
            CustomModel queryCustomModel = (CustomModel)requestHints.getObject("custom_model", null);
            CustomModel mergedCustomModel = CustomModel.merge((CustomModel)profile.getCustomModel(), (CustomModel)queryCustomModel);
            if (requestHints.has("heading_penalty")) {
                mergedCustomModel.setHeadingPenalty(requestHints.getDouble("heading_penalty", 300.0));
            }
            if (hints.has("cm_version")) {
                if (!hints.getString("cm_version", "").equals("2")) {
                    throw new IllegalArgumentException("cm_version: \"2\" is required");
                }
                weighting = CustomModelParser.createWeighting2(this.encodingManager, turnCostProvider, mergedCustomModel);
            } else {
                weighting = CustomModelParser.createWeighting(this.encodingManager, turnCostProvider, mergedCustomModel);
            }
        } else {
            if ("shortest".equalsIgnoreCase(weightingStr)) {
                throw new IllegalArgumentException("Instead of weighting=shortest use weighting=custom with a high distance_influence");
            }
            if ("fastest".equalsIgnoreCase(weightingStr)) {
                throw new IllegalArgumentException("Instead of weighting=fastest use weighting=custom with a custom model that avoids road_access == DESTINATION");
            }
            if ("curvature".equalsIgnoreCase(weightingStr)) {
                throw new IllegalArgumentException("The curvature weighting is no longer supported since 7.0. Use a custom model with the EncodedValue 'curvature' instead");
            }
            if ("short_fastest".equalsIgnoreCase(weightingStr)) {
                throw new IllegalArgumentException("Instead of weighting=short_fastest use weighting=custom with a distance_influence");
            }
        }
        if (weighting == null) {
            throw new IllegalArgumentException("Weighting '" + weightingStr + "' not supported");
        }
        return weighting;
    }
}

