/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.InstructionsHelper;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.List;

class InstructionsOutgoingEdges {
    private final EdgeIteratorState prevEdge;
    private final EdgeIteratorState currentEdge;
    private final List<EdgeIteratorState> allowedAlternativeTurns;
    private final List<EdgeIteratorState> visibleAlternativeTurns;
    private final DecimalEncodedValue maxSpeedEnc;
    private final EnumEncodedValue<RoadClass> roadClassEnc;
    private final BooleanEncodedValue roadClassLinkEnc;
    private final IntEncodedValue lanesEnc;
    private final NodeAccess nodeAccess;
    private final Weighting weighting;
    private final int baseNode;
    private final EdgeExplorer allExplorer;

    public InstructionsOutgoingEdges(EdgeIteratorState prevEdge, EdgeIteratorState currentEdge, Weighting weighting, DecimalEncodedValue maxSpeedEnc, EnumEncodedValue<RoadClass> roadClassEnc, BooleanEncodedValue roadClassLinkEnc, IntEncodedValue lanesEnc, EdgeExplorer allExplorer, NodeAccess nodeAccess, int prevNode, int baseNode, int adjNode) {
        this.prevEdge = prevEdge;
        this.currentEdge = currentEdge;
        this.weighting = weighting;
        this.maxSpeedEnc = maxSpeedEnc;
        this.roadClassEnc = roadClassEnc;
        this.roadClassLinkEnc = roadClassLinkEnc;
        this.lanesEnc = lanesEnc;
        this.nodeAccess = nodeAccess;
        this.baseNode = baseNode;
        this.allExplorer = allExplorer;
        this.visibleAlternativeTurns = new ArrayList<EdgeIteratorState>();
        this.allowedAlternativeTurns = new ArrayList<EdgeIteratorState>();
        EdgeIterator edgeIter = allExplorer.setBaseNode(baseNode);
        while (edgeIter.next()) {
            if (edgeIter.getAdjNode() == prevNode || edgeIter.getAdjNode() == adjNode) continue;
            if (Double.isFinite(weighting.calcEdgeWeight(edgeIter, false))) {
                EdgeIteratorState tmpEdge = edgeIter.detach(false);
                this.allowedAlternativeTurns.add(tmpEdge);
                this.visibleAlternativeTurns.add(tmpEdge);
                continue;
            }
            if (!Double.isFinite(weighting.calcEdgeWeight(edgeIter, true))) continue;
            this.visibleAlternativeTurns.add(edgeIter.detach(false));
        }
    }

    public int getAllowedTurns() {
        return 1 + this.allowedAlternativeTurns.size();
    }

    public int getVisibleTurns() {
        return 1 + this.visibleAlternativeTurns.size();
    }

    public boolean outgoingEdgesAreSlowerByFactor(double factor) {
        double tmpSpeed = this.getSpeed(this.currentEdge);
        double pathSpeed = this.getSpeed(this.prevEdge);
        if (Math.abs(pathSpeed - tmpSpeed) >= 1.0) {
            return false;
        }
        double maxSurroundingSpeed = -1.0;
        for (EdgeIteratorState edge : this.allowedAlternativeTurns) {
            tmpSpeed = this.getSpeed(edge);
            if (!(tmpSpeed > maxSurroundingSpeed)) continue;
            maxSurroundingSpeed = tmpSpeed;
        }
        return Math.round(maxSurroundingSpeed * factor) < Math.round(pathSpeed);
    }

    private double getSpeed(EdgeIteratorState edge) {
        double maxSpeed = edge.get(this.maxSpeedEnc);
        if (Double.isInfinite(maxSpeed)) {
            return edge.getDistance() / (double)this.weighting.calcEdgeMillis(edge, false) * 3600.0;
        }
        return maxSpeed;
    }

    public EdgeIteratorState getOtherContinue(double prevLat, double prevLon, double prevOrientation) {
        for (EdgeIteratorState edge : this.allowedAlternativeTurns) {
            GHPoint point = InstructionsHelper.getPointForOrientationCalculation(edge, this.nodeAccess);
            int tmpSign = InstructionsHelper.calculateSign(prevLat, prevLon, point.getLat(), point.getLon(), prevOrientation);
            if (Math.abs(tmpSign) > 1) continue;
            return edge;
        }
        return null;
    }

    public boolean isLeavingCurrentStreet(String prevName, String name) {
        if (InstructionsHelper.isSameName(name, prevName)) {
            return false;
        }
        boolean roadClassOrLinkChange = !this.isTheSameRoadClassAndLink(this.prevEdge, this.currentEdge);
        for (EdgeIteratorState edge : this.allowedAlternativeTurns) {
            String edgeName = edge.getName();
            if (InstructionsHelper.isSameName(prevName, edgeName) || roadClassOrLinkChange && this.isTheSameRoadClassAndLink(this.prevEdge, edge)) {
                return true;
            }
            if (!InstructionsHelper.isSameName(name, edgeName) && (!roadClassOrLinkChange || !this.isTheSameRoadClassAndLink(this.currentEdge, edge))) continue;
            return true;
        }
        return false;
    }

    private boolean isTheSameRoadClassAndLink(EdgeIteratorState edge1, EdgeIteratorState edge2) {
        return edge1.get(this.roadClassEnc) == edge2.get(this.roadClassEnc) && edge1.get(this.roadClassLinkEnc) == edge2.get(this.roadClassLinkEnc);
    }

    public boolean mergedOrSplitWay() {
        if (this.lanesEnc == null) {
            return false;
        }
        String name = this.currentEdge.getName();
        RoadClass roadClass = this.currentEdge.get(this.roadClassEnc);
        if (!InstructionsHelper.isSameName(name, this.prevEdge.getName()) || roadClass != this.prevEdge.get(this.roadClassEnc)) {
            return false;
        }
        EdgeIterator edgeIter = this.allExplorer.setBaseNode(this.baseNode);
        EdgeIteratorState otherEdge = null;
        while (edgeIter.next()) {
            if (this.currentEdge.getEdge() == edgeIter.getEdge() || this.prevEdge.getEdge() == edgeIter.getEdge() || roadClass != edgeIter.get(this.roadClassEnc) || !InstructionsHelper.isSameName(name, edgeIter.getName()) || !Double.isFinite(this.weighting.calcEdgeWeight(edgeIter, false)) && !Double.isFinite(this.weighting.calcEdgeWeight(edgeIter, true))) continue;
            if (otherEdge != null) {
                return false;
            }
            otherEdge = edgeIter.detach(false);
        }
        if (otherEdge == null) {
            return false;
        }
        if (Double.isFinite(this.weighting.calcEdgeWeight(this.currentEdge, true))) {
            if (Double.isFinite(this.weighting.calcEdgeWeight(this.prevEdge, true))) {
                return false;
            }
            if (!Double.isFinite(this.weighting.calcEdgeWeight(otherEdge, false))) {
                return false;
            }
            if (Double.isFinite(this.weighting.calcEdgeWeight(otherEdge, true))) {
                return false;
            }
            int delta = Math.abs(this.prevEdge.get(this.lanesEnc) + otherEdge.get(this.lanesEnc) - this.currentEdge.get(this.lanesEnc));
            return delta <= 1;
        }
        if (!Double.isFinite(this.weighting.calcEdgeWeight(this.prevEdge, true))) {
            return false;
        }
        if (Double.isFinite(this.weighting.calcEdgeWeight(otherEdge, false))) {
            return false;
        }
        if (!Double.isFinite(this.weighting.calcEdgeWeight(otherEdge, true))) {
            return false;
        }
        int delta = this.prevEdge.get(this.lanesEnc) - (this.currentEdge.get(this.lanesEnc) + otherEdge.get(this.lanesEnc));
        return delta <= 1;
    }
}

