/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHPreparationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CHPreparationHandler.class);
    private final List<CHProfile> chProfiles = new ArrayList<CHProfile>();
    private int preparationThreads;
    private PMap pMap = new PMap();

    public CHPreparationHandler() {
        this.setPreparationThreads(1);
    }

    public void init(GraphHopperConfig ghConfig) {
        if (ghConfig.has("prepare.threads")) {
            throw new IllegalStateException("Use prepare.ch.threads instead of prepare.threads");
        }
        if (ghConfig.has("prepare.chWeighting") || ghConfig.has("prepare.chWeightings") || ghConfig.has("prepare.ch.weightings")) {
            throw new IllegalStateException("Use profiles_ch instead of prepare.chWeighting, prepare.chWeightings or prepare.ch.weightings, see #1922 and docs/core/profiles.md");
        }
        if (ghConfig.has("prepare.ch.edge_based")) {
            throw new IllegalStateException("Use profiles_ch instead of prepare.ch.edge_based, see #1922 and docs/core/profiles.md");
        }
        this.setPreparationThreads(ghConfig.getInt("prepare.ch.threads", this.getPreparationThreads()));
        this.setCHProfiles(ghConfig.getCHProfiles());
        this.pMap = ghConfig.asPMap();
    }

    public final boolean isEnabled() {
        return !this.chProfiles.isEmpty();
    }

    public CHPreparationHandler setCHProfiles(CHProfile ... chProfiles) {
        this.setCHProfiles(Arrays.asList(chProfiles));
        return this;
    }

    public CHPreparationHandler setCHProfiles(Collection<CHProfile> chProfiles) {
        this.chProfiles.clear();
        this.chProfiles.addAll(chProfiles);
        return this;
    }

    public List<CHProfile> getCHProfiles() {
        return this.chProfiles;
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public void setPreparationThreads(int preparationThreads) {
        this.preparationThreads = preparationThreads;
    }

    public Map<String, RoutingCHGraph> load(BaseGraph graph, List<CHConfig> chConfigs) {
        Map<String, RoutingCHGraph> loaded = Collections.synchronizedMap(new LinkedHashMap());
        Stream<Runnable> runnables = chConfigs.stream().map(c -> () -> {
            CHStorage chStorage = new CHStorage(graph.getDirectory(), c.getName(), graph.getSegmentSize(), c.isEdgeBased());
            if (chStorage.loadExisting()) {
                loaded.put(c.getName(), RoutingCHGraphImpl.fromGraph(graph, chStorage, c));
            } else {
                graph.getDirectory().remove("nodes_ch_" + c.getName());
                graph.getDirectory().remove("shortcuts_" + c.getName());
            }
        });
        GHUtility.runConcurrently(runnables, this.preparationThreads);
        return loaded;
    }

    public Map<String, PrepareContractionHierarchies.Result> prepare(BaseGraph baseGraph, StorableProperties properties, List<CHConfig> chConfigs, boolean closeEarly) {
        if (chConfigs.isEmpty()) {
            LOGGER.info("There are no CHs to prepare");
            return Collections.emptyMap();
        }
        LOGGER.info("Creating CH preparations, {}", (Object)Helper.getMemInfo());
        Map<String, PrepareContractionHierarchies.Result> results = Collections.synchronizedMap(new LinkedHashMap());
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(chConfigs.size());
        for (int i = 0; i < chConfigs.size(); ++i) {
            CHConfig chConfig = chConfigs.get(i);
            LOGGER.info(i + 1 + "/" + chConfigs.size() + " Setting up CH preparation for profile '" + chConfig.getName() + "' " + chConfig.getTraversalMode() + " ... (" + Helper.getMemInfo() + ")");
            runnables.add(() -> {
                String name = chConfig.getName();
                Thread.currentThread().setName(name);
                PrepareContractionHierarchies prepare = PrepareContractionHierarchies.fromGraph(baseGraph, chConfig);
                prepare.setParams(this.pMap);
                PrepareContractionHierarchies.Result result = prepare.doWork();
                results.put(name, result);
                prepare.flush();
                if (closeEarly) {
                    prepare.close();
                }
                properties.put("prepare.ch.date." + name, Helper.createFormatter().format(new Date()));
            });
        }
        GHUtility.runConcurrently(runnables.stream(), this.preparationThreads);
        LOGGER.info("Finished CH preparation, {}", (Object)Helper.getMemInfo());
        return results;
    }

    private PrepareContractionHierarchies createCHPreparation(BaseGraph graph, CHConfig chConfig) {
        PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraph(graph, chConfig);
        pch.setParams(this.pMap);
        return pch;
    }
}

