/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.carrotsearch.hppc.BitSet;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;

public class ExternalBooleanEncodedValue
implements BooleanEncodedValue {
    private final String name;
    private final boolean storeTwoDirections;
    private final BitSet bits;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ExternalBooleanEncodedValue(@JsonProperty(value="name") String name, @JsonProperty(value="store_two_directions") boolean storeTwoDirections) {
        this.name = name;
        this.storeTwoDirections = storeTwoDirections;
        this.bits = new BitSet();
    }

    @Override
    public void setBool(boolean reverse, int edgeId, EdgeIntAccess edgeIntAccess, boolean value) {
        if (value) {
            this.bits.set(this.getIndex(edgeId, reverse));
        } else {
            this.bits.clear(this.getIndex(edgeId, reverse));
        }
    }

    @Override
    public boolean getBool(boolean reverse, int edgeId, EdgeIntAccess edgeIntAccess) {
        return this.bits.get(this.getIndex(edgeId, reverse));
    }

    private long getIndex(int edgeId, boolean reverse) {
        return this.storeTwoDirections ? 2L * (long)edgeId + (long)(reverse ? 1 : 0) : (long)edgeId;
    }

    @Override
    public int init(EncodedValue.InitializerConfig init) {
        return 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStoreTwoDirections() {
        return this.storeTwoDirections;
    }
}

