/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.util.Helper;

public enum RoadClass {
    OTHER,
    MOTORWAY,
    TRUNK,
    PRIMARY,
    SECONDARY,
    TERTIARY,
    RESIDENTIAL,
    UNCLASSIFIED,
    SERVICE,
    ROAD,
    TRACK,
    BRIDLEWAY,
    STEPS,
    CYCLEWAY,
    PATH,
    LIVING_STREET,
    FOOTWAY,
    PEDESTRIAN,
    PLATFORM,
    CORRIDOR,
    CONSTRUCTION;

    public static final String KEY = "road_class";

    public static EnumEncodedValue<RoadClass> create() {
        return new EnumEncodedValue<RoadClass>(KEY, RoadClass.class);
    }

    public String toString() {
        return Helper.toLowerCase((String)super.toString());
    }

    public static RoadClass find(String name) {
        if (name == null || name.isEmpty()) {
            return OTHER;
        }
        try {
            return RoadClass.valueOf(Helper.toUpperCase((String)name));
        }
        catch (IllegalArgumentException ex) {
            return OTHER;
        }
    }
}

