/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.querygraph.QueryOverlay;
import com.graphhopper.routing.querygraph.QueryOverlayBuilder;
import com.graphhopper.routing.querygraph.VirtualEdgeIterator;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.QueryGraphWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.ExtendedNodeAccess;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.shapes.BBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class QueryGraph
implements Graph {
    static final int BASE_SNAP = 0;
    static final int SNAP_BASE = 1;
    static final int SNAP_ADJ = 2;
    static final int ADJ_SNAP = 3;
    private final BaseGraph baseGraph;
    private final int baseNodes;
    private final int baseEdges;
    private final TurnCostStorage turnCostStorage;
    private final NodeAccess nodeAccess;
    private final QueryOverlay queryOverlay;
    private final Set<VirtualEdgeIteratorState> unfavoredEdges = new LinkedHashSet<VirtualEdgeIteratorState>(5);
    private final IntObjectMap<List<EdgeIteratorState>> virtualEdgesAtRealNodes;
    private final List<List<EdgeIteratorState>> virtualEdgesAtVirtualNodes;

    public static QueryGraph create(BaseGraph graph, Snap snap) {
        return QueryGraph.create(graph, Collections.singletonList(snap));
    }

    public static QueryGraph create(BaseGraph graph, Snap fromSnap, Snap toSnap) {
        return QueryGraph.create(graph.getBaseGraph(), Arrays.asList(fromSnap, toSnap));
    }

    public static QueryGraph create(BaseGraph graph, List<Snap> snaps) {
        return new QueryGraph(graph, snaps);
    }

    private QueryGraph(BaseGraph graph, List<Snap> snaps) {
        this.baseGraph = graph;
        this.baseNodes = graph.getNodes();
        this.baseEdges = graph.getEdges();
        this.queryOverlay = QueryOverlayBuilder.build(graph, snaps);
        this.nodeAccess = new ExtendedNodeAccess(graph.getNodeAccess(), this.queryOverlay.getVirtualNodes(), this.baseNodes);
        this.turnCostStorage = this.baseGraph.getTurnCostStorage();
        EdgeExplorer mainExplorer = this.baseGraph.createEdgeExplorer();
        this.virtualEdgesAtRealNodes = this.buildVirtualEdgesAtRealNodes(mainExplorer);
        this.virtualEdgesAtVirtualNodes = this.buildVirtualEdgesAtVirtualNodes();
    }

    public QueryOverlay getQueryOverlay() {
        return this.queryOverlay;
    }

    @Override
    public BaseGraph getBaseGraph() {
        return this.baseGraph;
    }

    public boolean isVirtualEdge(int edgeId) {
        return edgeId >= this.baseEdges;
    }

    public boolean isVirtualNode(int nodeId) {
        return nodeId >= this.baseNodes;
    }

    public void unfavorVirtualEdges(IntArrayList edgeIds) {
        for (IntCursor c : edgeIds) {
            this.unfavorVirtualEdge(c.value);
        }
    }

    public void unfavorVirtualEdge(int virtualEdgeId) {
        if (!this.isVirtualEdge(virtualEdgeId)) {
            return;
        }
        VirtualEdgeIteratorState edge = this.getVirtualEdge(this.getInternalVirtualEdgeId(virtualEdgeId));
        edge.setUnfavored(true);
        this.unfavoredEdges.add(edge);
        VirtualEdgeIteratorState reverseEdge = this.getVirtualEdge(QueryGraph.getPosOfReverseEdge(this.getInternalVirtualEdgeId(virtualEdgeId)));
        reverseEdge.setUnfavored(true);
        this.unfavoredEdges.add(reverseEdge);
    }

    public Set<EdgeIteratorState> getUnfavoredVirtualEdges() {
        return new LinkedHashSet<EdgeIteratorState>(this.unfavoredEdges);
    }

    public void clearUnfavoredStatus() {
        for (VirtualEdgeIteratorState edge : this.unfavoredEdges) {
            edge.setUnfavored(false);
        }
        this.unfavoredEdges.clear();
    }

    @Override
    public int getNodes() {
        return this.queryOverlay.getVirtualNodes().size() + this.baseNodes;
    }

    @Override
    public int getEdges() {
        return this.queryOverlay.getNumVirtualEdges() / 2 + this.baseEdges;
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.nodeAccess;
    }

    @Override
    public BBox getBounds() {
        return this.baseGraph.getBounds();
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int origEdgeId, int adjNode) {
        if (!this.isVirtualEdge(origEdgeId)) {
            return this.baseGraph.getEdgeIteratorState(origEdgeId, adjNode);
        }
        int edgeId = this.getInternalVirtualEdgeId(origEdgeId);
        VirtualEdgeIteratorState eis = this.getVirtualEdge(edgeId);
        if (eis.getAdjNode() == adjNode || adjNode == Integer.MIN_VALUE) {
            return eis;
        }
        VirtualEdgeIteratorState eis2 = this.getVirtualEdge(edgeId = QueryGraph.getPosOfReverseEdge(edgeId));
        if (eis2.getAdjNode() == adjNode) {
            return eis2;
        }
        throw new IllegalStateException("Edge " + origEdgeId + " not found with adjNode:" + adjNode + ". found edges were:" + eis + ", " + eis2);
    }

    @Override
    public EdgeIteratorState getEdgeIteratorStateForKey(int edgeKey) {
        int edge = GHUtility.getEdgeFromEdgeKey(edgeKey);
        if (!this.isVirtualEdge(edge)) {
            return this.baseGraph.getEdgeIteratorStateForKey(edgeKey);
        }
        return this.getVirtualEdge(edgeKey - 2 * this.baseEdges);
    }

    private VirtualEdgeIteratorState getVirtualEdge(int edgeId) {
        return this.queryOverlay.getVirtualEdge(edgeId);
    }

    static int getPosOfReverseEdge(int edgeId) {
        return edgeId % 2 == 0 ? edgeId + 1 : edgeId - 1;
    }

    private int getInternalVirtualEdgeId(int origEdgeId) {
        return 2 * (origEdgeId - this.baseEdges);
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter edgeFilter) {
        final EdgeExplorer mainExplorer = this.baseGraph.createEdgeExplorer(edgeFilter);
        final VirtualEdgeIterator virtualEdgeIterator = new VirtualEdgeIterator(edgeFilter, null);
        return new EdgeExplorer(){

            @Override
            public EdgeIterator setBaseNode(int baseNode) {
                if (QueryGraph.this.isVirtualNode(baseNode)) {
                    List<EdgeIteratorState> virtualEdges = QueryGraph.this.virtualEdgesAtVirtualNodes.get(baseNode - QueryGraph.this.baseNodes);
                    return virtualEdgeIterator.reset(virtualEdges);
                }
                List virtualEdges = (List)QueryGraph.this.virtualEdgesAtRealNodes.get(baseNode);
                if (virtualEdges == null) {
                    return mainExplorer.setBaseNode(baseNode);
                }
                return virtualEdgeIterator.reset(virtualEdges);
            }
        };
    }

    private IntObjectMap<List<EdgeIteratorState>> buildVirtualEdgesAtRealNodes(final EdgeExplorer mainExplorer) {
        final GHIntObjectHashMap virtualEdgesAtRealNodes = new GHIntObjectHashMap(this.queryOverlay.getEdgeChangesAtRealNodes().size());
        this.queryOverlay.getEdgeChangesAtRealNodes().forEach((IntObjectProcedure)new IntObjectProcedure<QueryOverlay.EdgeChanges>(){

            public void apply(int node, QueryOverlay.EdgeChanges edgeChanges) {
                ArrayList<EdgeIteratorState> virtualEdges = new ArrayList<EdgeIteratorState>(edgeChanges.getAdditionalEdges());
                EdgeIterator mainIter = mainExplorer.setBaseNode(node);
                while (mainIter.next()) {
                    if (edgeChanges.getRemovedEdges().contains(mainIter.getEdge())) continue;
                    virtualEdges.add(mainIter.detach(false));
                }
                virtualEdgesAtRealNodes.put(node, virtualEdges);
            }
        });
        return virtualEdgesAtRealNodes;
    }

    private List<List<EdgeIteratorState>> buildVirtualEdgesAtVirtualNodes() {
        ArrayList<List<EdgeIteratorState>> virtualEdgesAtVirtualNodes = new ArrayList<List<EdgeIteratorState>>();
        for (int i = 0; i < this.queryOverlay.getVirtualNodes().size(); ++i) {
            List<EdgeIteratorState> virtualEdges = Arrays.asList(this.queryOverlay.getVirtualEdge(i * 4 + 1), this.queryOverlay.getVirtualEdge(i * 4 + 2));
            virtualEdgesAtVirtualNodes.add(virtualEdges);
        }
        return virtualEdgesAtVirtualNodes;
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public EdgeIteratorState edge(int a, int b) {
        throw this.exc();
    }

    @Override
    public TurnCostStorage getTurnCostStorage() {
        return this.turnCostStorage;
    }

    @Override
    public Weighting wrapWeighting(Weighting weighting) {
        return new QueryGraphWeighting(this.baseGraph, weighting, this.queryOverlay.getClosestEdges());
    }

    @Override
    public int getOtherNode(int edge, int node) {
        if (this.isVirtualEdge(edge)) {
            return this.getEdgeIteratorState(edge, node).getBaseNode();
        }
        return this.baseGraph.getOtherNode(edge, node);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        if (this.isVirtualEdge(edge)) {
            EdgeIteratorState virtualEdge = this.getEdgeIteratorState(edge, node);
            return virtualEdge.getBaseNode() == node || virtualEdge.getAdjNode() == node;
        }
        return this.baseGraph.isAdjacentToNode(edge, node);
    }

    List<VirtualEdgeIteratorState> getVirtualEdges() {
        return this.queryOverlay.getVirtualEdges();
    }

    private UnsupportedOperationException exc() {
        return new UnsupportedOperationException("QueryGraph cannot be modified.");
    }
}

