/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.querygraph.EdgeChangeBuilder;
import com.graphhopper.routing.querygraph.QueryOverlay;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

class QueryOverlayBuilder {
    private final int firstVirtualNodeId;
    private final int firstVirtualEdgeId;
    private final boolean is3D;
    private QueryOverlay queryOverlay;

    public static QueryOverlay build(Graph graph, List<Snap> snaps) {
        return QueryOverlayBuilder.build(graph.getNodes(), graph.getEdges(), graph.getNodeAccess().is3D(), snaps);
    }

    public static QueryOverlay build(int firstVirtualNodeId, int firstVirtualEdgeId, boolean is3D, List<Snap> snaps) {
        return new QueryOverlayBuilder(firstVirtualNodeId, firstVirtualEdgeId, is3D).build(snaps);
    }

    private QueryOverlayBuilder(int firstVirtualNodeId, int firstVirtualEdgeId, boolean is3D) {
        this.firstVirtualNodeId = firstVirtualNodeId;
        this.firstVirtualEdgeId = firstVirtualEdgeId;
        this.is3D = is3D;
    }

    private QueryOverlay build(List<Snap> resList) {
        this.queryOverlay = new QueryOverlay(resList.size(), this.is3D);
        this.buildVirtualEdges(resList);
        this.buildEdgeChangesAtRealNodes();
        return this.queryOverlay;
    }

    private void buildVirtualEdges(List<Snap> snaps) {
        GHIntObjectHashMap edge2res = new GHIntObjectHashMap(snaps.size());
        for (Snap snap : snaps) {
            int edgeId;
            ArrayList<Snap> list;
            PointList pl;
            boolean doReverse;
            if (snap.getSnappedPosition() == Snap.Position.TOWER) continue;
            EdgeIteratorState closestEdge = snap.getClosestEdge();
            if (closestEdge == null) {
                throw new IllegalStateException("Do not call QueryGraph.create with invalid Snap " + snap);
            }
            int base = closestEdge.getBaseNode();
            boolean bl = doReverse = base > closestEdge.getAdjNode();
            if (base == closestEdge.getAdjNode() && (pl = closestEdge.fetchWayGeometry(FetchMode.PILLAR_ONLY)).size() > 1) {
                boolean bl2 = doReverse = pl.getLat(0) > pl.getLat(pl.size() - 1);
            }
            if (doReverse) {
                closestEdge = closestEdge.detach(true);
                PointList fullPL = closestEdge.fetchWayGeometry(FetchMode.ALL);
                snap.setClosestEdge(closestEdge);
                if (snap.getSnappedPosition() == Snap.Position.PILLAR) {
                    snap.setWayIndex(fullPL.size() - snap.getWayIndex() - 1);
                } else {
                    snap.setWayIndex(fullPL.size() - snap.getWayIndex() - 2);
                }
                if (snap.getWayIndex() < 0) {
                    throw new IllegalStateException("Problem with wayIndex while reversing closest edge:" + closestEdge + ", " + snap);
                }
            }
            if ((list = (ArrayList<Snap>)edge2res.get(edgeId = closestEdge.getEdge())) == null) {
                list = new ArrayList<Snap>(5);
                edge2res.put(edgeId, list);
            }
            list.add(snap);
        }
        edge2res.forEach((IntObjectPredicate)new IntObjectPredicate<List<Snap>>(){

            public boolean apply(int edgeId, List<Snap> results) {
                EdgeIteratorState closestEdge = results.get(0).getClosestEdge();
                final PointList fullPL = closestEdge.fetchWayGeometry(FetchMode.ALL);
                int baseNode = closestEdge.getBaseNode();
                Collections.sort(results, new Comparator<Snap>(){

                    @Override
                    public int compare(Snap o1, Snap o2) {
                        int diff = Integer.compare(o1.getWayIndex(), o2.getWayIndex());
                        if (diff == 0) {
                            return Double.compare(this.distanceOfSnappedPointToPillarNode(o1), this.distanceOfSnappedPointToPillarNode(o2));
                        }
                        return diff;
                    }

                    private double distanceOfSnappedPointToPillarNode(Snap o) {
                        GHPoint3D snappedPoint = o.getSnappedPoint();
                        double fromLat = fullPL.getLat(o.getWayIndex());
                        double fromLon = fullPL.getLon(o.getWayIndex());
                        return DistancePlaneProjection.DIST_PLANE.calcNormalizedDist(fromLat, fromLon, snappedPoint.lat, snappedPoint.lon);
                    }
                });
                GHPoint3D prevPoint = fullPL.get(0);
                int adjNode = closestEdge.getAdjNode();
                int origEdgeKey = closestEdge.getEdgeKey();
                int origRevEdgeKey = closestEdge.getReverseEdgeKey();
                int prevWayIndex = 1;
                int prevNodeId = baseNode;
                int virtNodeId = QueryOverlayBuilder.this.queryOverlay.getVirtualNodes().size() + QueryOverlayBuilder.this.firstVirtualNodeId;
                boolean addedEdges = false;
                for (int i = 0; i < results.size(); ++i) {
                    Snap res = results.get(i);
                    if (res.getClosestEdge().getBaseNode() != baseNode) {
                        throw new IllegalStateException("Base nodes have to be identical but were not: " + closestEdge + " vs " + res.getClosestEdge());
                    }
                    GHPoint3D currSnapped = res.getSnappedPoint();
                    if (Snap.considerEqual(prevPoint.lat, prevPoint.lon, currSnapped.lat, currSnapped.lon)) {
                        res.setClosestNode(prevNodeId);
                        res.setSnappedPoint(prevPoint);
                        res.setWayIndex(i == 0 ? 0 : results.get(i - 1).getWayIndex());
                        res.setSnappedPosition(i == 0 ? Snap.Position.TOWER : results.get(i - 1).getSnappedPosition());
                        res.setQueryDistance(DistancePlaneProjection.DIST_PLANE.calcDist(prevPoint.lat, prevPoint.lon, res.getQueryPoint().lat, res.getQueryPoint().lon));
                        continue;
                    }
                    QueryOverlayBuilder.this.queryOverlay.getClosestEdges().add(res.getClosestEdge().getEdge());
                    boolean isPillar = res.getSnappedPosition() == Snap.Position.PILLAR;
                    QueryOverlayBuilder.this.createEdges(origEdgeKey, origRevEdgeKey, prevPoint, prevWayIndex, isPillar, res.getSnappedPoint(), res.getWayIndex(), fullPL, closestEdge, prevNodeId, virtNodeId);
                    QueryOverlayBuilder.this.queryOverlay.getVirtualNodes().add(currSnapped.lat, currSnapped.lon, currSnapped.ele);
                    if (addedEdges) {
                        QueryOverlayBuilder.this.queryOverlay.addVirtualEdge(QueryOverlayBuilder.this.queryOverlay.getVirtualEdge(QueryOverlayBuilder.this.queryOverlay.getNumVirtualEdges() - 2));
                        QueryOverlayBuilder.this.queryOverlay.addVirtualEdge(QueryOverlayBuilder.this.queryOverlay.getVirtualEdge(QueryOverlayBuilder.this.queryOverlay.getNumVirtualEdges() - 2));
                    }
                    addedEdges = true;
                    res.setClosestNode(virtNodeId);
                    prevNodeId = virtNodeId++;
                    prevWayIndex = res.getWayIndex() + 1;
                    prevPoint = currSnapped;
                }
                if (addedEdges) {
                    QueryOverlayBuilder.this.createEdges(origEdgeKey, origRevEdgeKey, prevPoint, prevWayIndex, false, fullPL.get(fullPL.size() - 1), fullPL.size() - 2, fullPL, closestEdge, virtNodeId - 1, adjNode);
                }
                return true;
            }
        });
    }

    private void createEdges(int origEdgeKey, int origRevEdgeKey, GHPoint3D prevSnapped, int prevWayIndex, boolean isPillar, GHPoint3D currSnapped, int wayIndex, PointList fullPL, EdgeIteratorState closestEdge, int prevNodeId, int nodeId) {
        int max = wayIndex + 1;
        PointList basePoints = new PointList(max - prevWayIndex + 1, this.is3D);
        basePoints.add(prevSnapped.lat, prevSnapped.lon, prevSnapped.ele);
        for (int i = prevWayIndex; i < max; ++i) {
            basePoints.add((PointAccess)fullPL, i);
        }
        if (!isPillar) {
            basePoints.add(currSnapped.lat, currSnapped.lon, currSnapped.ele);
        }
        assert (basePoints.size() >= 2) : "basePoints must have at least two points";
        PointList baseReversePoints = basePoints.clone(true);
        double baseDistance = DistancePlaneProjection.DIST_PLANE.calcDistance(basePoints);
        int virtEdgeId = this.firstVirtualEdgeId + this.queryOverlay.getNumVirtualEdges() / 2;
        boolean reverse = closestEdge.get(EdgeIteratorState.REVERSE_STATE);
        Map<String, KVStorage.KValue> keyValues = closestEdge.getKeyValues();
        VirtualEdgeIteratorState baseEdge = new VirtualEdgeIteratorState(origEdgeKey, GHUtility.createEdgeKey(virtEdgeId, false), prevNodeId, nodeId, baseDistance, closestEdge.getFlags(), keyValues, basePoints, reverse);
        VirtualEdgeIteratorState baseReverseEdge = new VirtualEdgeIteratorState(origRevEdgeKey, GHUtility.createEdgeKey(virtEdgeId, true), nodeId, prevNodeId, baseDistance, IntsRef.deepCopyOf(closestEdge.getFlags()), keyValues, baseReversePoints, !reverse);
        baseEdge.setReverseEdge(baseReverseEdge);
        baseReverseEdge.setReverseEdge(baseEdge);
        this.queryOverlay.addVirtualEdge(baseEdge);
        this.queryOverlay.addVirtualEdge(baseReverseEdge);
    }

    private void buildEdgeChangesAtRealNodes() {
        EdgeChangeBuilder.build(this.queryOverlay.getClosestEdges(), this.queryOverlay.getVirtualEdges(), this.firstVirtualNodeId, this.queryOverlay.getEdgeChangesAtRealNodes());
    }
}

