/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryOverlay;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.RoutingCHEdgeExplorer;
import com.graphhopper.storage.RoutingCHEdgeIterator;
import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QueryRoutingCHGraph
implements RoutingCHGraph {
    private final RoutingCHGraph routingCHGraph;
    private final Weighting weighting;
    private final QueryOverlay queryOverlay;
    private final QueryGraph queryGraph;
    private final Weighting queryGraphWeighting;
    private final int nodes;
    private final IntObjectMap<List<RoutingCHEdgeIteratorState>> virtualOutEdgesAtRealNodes;
    private final IntObjectMap<List<RoutingCHEdgeIteratorState>> virtualInEdgesAtRealNodes;
    private final List<List<RoutingCHEdgeIteratorState>> virtualEdgesAtVirtualNodes;

    public QueryRoutingCHGraph(RoutingCHGraph routingCHGraph, QueryGraph queryGraph) {
        this.routingCHGraph = routingCHGraph;
        this.weighting = routingCHGraph.getWeighting();
        this.queryOverlay = queryGraph.getQueryOverlay();
        this.queryGraph = queryGraph;
        this.queryGraphWeighting = queryGraph.wrapWeighting(this.weighting);
        this.virtualOutEdgesAtRealNodes = this.buildVirtualEdgesAtRealNodes(routingCHGraph.createOutEdgeExplorer());
        this.virtualInEdgesAtRealNodes = this.buildVirtualEdgesAtRealNodes(routingCHGraph.createInEdgeExplorer());
        this.virtualEdgesAtVirtualNodes = this.buildVirtualEdgesAtVirtualNodes();
        this.nodes = queryGraph.getNodes();
    }

    @Override
    public int getNodes() {
        return this.nodes;
    }

    @Override
    public int getEdges() {
        return this.routingCHGraph.getEdges() + this.queryOverlay.getNumVirtualEdges();
    }

    @Override
    public int getShortcuts() {
        return this.routingCHGraph.getShortcuts();
    }

    @Override
    public RoutingCHEdgeExplorer createInEdgeExplorer() {
        return this.createEdgeExplorer(this.routingCHGraph.createInEdgeExplorer(), this.virtualInEdgesAtRealNodes);
    }

    @Override
    public RoutingCHEdgeExplorer createOutEdgeExplorer() {
        return this.createEdgeExplorer(this.routingCHGraph.createOutEdgeExplorer(), this.virtualOutEdgesAtRealNodes);
    }

    private RoutingCHEdgeExplorer createEdgeExplorer(final RoutingCHEdgeExplorer explorer, final IntObjectMap<List<RoutingCHEdgeIteratorState>> virtualEdgesAtRealNodes) {
        final VirtualCHEdgeIterator iterator = new VirtualCHEdgeIterator();
        return new RoutingCHEdgeExplorer(){

            @Override
            public RoutingCHEdgeIterator setBaseNode(int baseNode) {
                if (QueryRoutingCHGraph.this.isVirtualNode(baseNode)) {
                    List<RoutingCHEdgeIteratorState> virtualEdges = QueryRoutingCHGraph.this.virtualEdgesAtVirtualNodes.get(baseNode - QueryRoutingCHGraph.this.routingCHGraph.getNodes());
                    iterator.reset(virtualEdges);
                    return iterator;
                }
                List virtualEdges = (List)virtualEdgesAtRealNodes.get(baseNode);
                if (virtualEdges == null) {
                    return explorer.setBaseNode(baseNode);
                }
                iterator.reset(virtualEdges);
                return iterator;
            }
        };
    }

    @Override
    public RoutingCHEdgeIteratorState getEdgeIteratorState(int chEdge, int adjNode) {
        if (!this.isVirtualEdge(chEdge)) {
            return this.routingCHGraph.getEdgeIteratorState(chEdge, adjNode);
        }
        return this.buildVirtualCHEdgeState(this.getVirtualEdgeState(chEdge, adjNode));
    }

    @Override
    public int getLevel(int node) {
        if (this.isVirtualNode(node)) {
            return Integer.MAX_VALUE;
        }
        return this.routingCHGraph.getLevel(node);
    }

    @Override
    public double getTurnWeight(int inEdge, int viaNode, int outEdge) {
        if (!this.routingCHGraph.hasTurnCosts()) {
            return 0.0;
        }
        return this.queryGraphWeighting.calcTurnWeight(inEdge, viaNode, outEdge);
    }

    @Override
    public Graph getBaseGraph() {
        return this.queryGraph;
    }

    @Override
    public boolean hasTurnCosts() {
        return this.routingCHGraph.hasTurnCosts();
    }

    @Override
    public boolean isEdgeBased() {
        return this.routingCHGraph.isEdgeBased();
    }

    @Override
    public Weighting getWeighting() {
        return this.weighting;
    }

    @Override
    public void close() {
        this.routingCHGraph.close();
        this.virtualEdgesAtVirtualNodes.clear();
        this.virtualInEdgesAtRealNodes.clear();
        this.virtualOutEdgesAtRealNodes.clear();
    }

    private VirtualEdgeIteratorState getVirtualEdgeState(int virtualEdgeId, int adjNode) {
        assert (this.isVirtualEdge(virtualEdgeId));
        int internalVirtualEdgeId = this.getInternalVirtualEdgeId(virtualEdgeId);
        VirtualEdgeIteratorState virtualEdge = this.queryOverlay.getVirtualEdge(internalVirtualEdgeId);
        if (virtualEdge.getAdjNode() == adjNode || adjNode == Integer.MIN_VALUE) {
            return virtualEdge;
        }
        virtualEdge = this.queryOverlay.getVirtualEdge(internalVirtualEdgeId = QueryGraph.getPosOfReverseEdge(internalVirtualEdgeId));
        if (virtualEdge.getAdjNode() != adjNode) {
            throw new IllegalArgumentException("The virtual edge with ID " + virtualEdgeId + " does not touch node " + adjNode);
        }
        return virtualEdge;
    }

    private IntObjectMap<List<RoutingCHEdgeIteratorState>> buildVirtualEdgesAtRealNodes(final RoutingCHEdgeExplorer explorer) {
        IntObjectHashMap virtualEdgesAtRealNodes = new IntObjectHashMap(this.queryOverlay.getEdgeChangesAtRealNodes().size());
        this.queryOverlay.getEdgeChangesAtRealNodes().forEach((IntObjectProcedure)new IntObjectProcedure<QueryOverlay.EdgeChanges>(){
            final /* synthetic */ IntObjectMap val$virtualEdgesAtRealNodes;
            {
                this.val$virtualEdgesAtRealNodes = intObjectMap;
            }

            public void apply(int node, QueryOverlay.EdgeChanges edgeChanges) {
                ArrayList<VirtualCHEdgeIteratorState> virtualEdges = new ArrayList<VirtualCHEdgeIteratorState>();
                for (EdgeIteratorState v : edgeChanges.getAdditionalEdges()) {
                    assert (v.getBaseNode() == node);
                    int edge = v.getEdge();
                    if (QueryRoutingCHGraph.this.queryGraph.isVirtualEdge(edge)) {
                        edge = QueryRoutingCHGraph.this.shiftVirtualEdgeIDForCH(edge);
                    }
                    virtualEdges.add(QueryRoutingCHGraph.this.buildVirtualCHEdgeState(v, edge));
                }
                RoutingCHEdgeIterator iter = explorer.setBaseNode(node);
                while (iter.next()) {
                    if (iter.isShortcut()) {
                        virtualEdges.add(new VirtualCHEdgeIteratorState(iter.getEdge(), -1, iter.getBaseNode(), iter.getAdjNode(), iter.getOrigEdgeKeyFirst(), iter.getOrigEdgeKeyLast(), iter.getSkippedEdge1(), iter.getSkippedEdge2(), iter.getWeight(false), iter.getWeight(true)));
                        continue;
                    }
                    if (edgeChanges.getRemovedEdges().contains(iter.getOrigEdge())) continue;
                    virtualEdges.add(new VirtualCHEdgeIteratorState(iter.getEdge(), iter.getOrigEdge(), iter.getBaseNode(), iter.getAdjNode(), iter.getOrigEdgeKeyFirst(), iter.getOrigEdgeKeyLast(), -1, -1, iter.getWeight(false), iter.getWeight(true)));
                }
                this.val$virtualEdgesAtRealNodes.put(node, virtualEdges);
            }
        });
        return virtualEdgesAtRealNodes;
    }

    private List<List<RoutingCHEdgeIteratorState>> buildVirtualEdgesAtVirtualNodes() {
        int virtualNodes = this.queryOverlay.getVirtualNodes().size();
        ArrayList<List<RoutingCHEdgeIteratorState>> virtualEdgesAtVirtualNodes = new ArrayList<List<RoutingCHEdgeIteratorState>>(virtualNodes);
        for (int i = 0; i < virtualNodes; ++i) {
            List<RoutingCHEdgeIteratorState> virtualEdges = Arrays.asList(this.buildVirtualCHEdgeState(this.queryOverlay.getVirtualEdges().get(i * 4 + 1)), this.buildVirtualCHEdgeState(this.queryOverlay.getVirtualEdges().get(i * 4 + 2)));
            virtualEdgesAtVirtualNodes.add(virtualEdges);
        }
        return virtualEdgesAtVirtualNodes;
    }

    private VirtualCHEdgeIteratorState buildVirtualCHEdgeState(VirtualEdgeIteratorState virtualEdgeState) {
        int virtualCHEdge = this.shiftVirtualEdgeIDForCH(virtualEdgeState.getEdge());
        return this.buildVirtualCHEdgeState(virtualEdgeState, virtualCHEdge);
    }

    private VirtualCHEdgeIteratorState buildVirtualCHEdgeState(EdgeIteratorState edgeState, int edgeID) {
        double fwdWeight = this.weighting.calcEdgeWeight(edgeState, false);
        double bwdWeight = this.weighting.calcEdgeWeight(edgeState, true);
        return new VirtualCHEdgeIteratorState(edgeID, edgeState.getEdge(), edgeState.getBaseNode(), edgeState.getAdjNode(), edgeState.getEdgeKey(), edgeState.getEdgeKey(), -1, -1, fwdWeight, bwdWeight);
    }

    private int shiftVirtualEdgeIDForCH(int edge) {
        return edge + this.routingCHGraph.getEdges() - this.routingCHGraph.getBaseGraph().getEdges();
    }

    private int getInternalVirtualEdgeId(int edge) {
        return 2 * (edge - this.routingCHGraph.getEdges());
    }

    private boolean isVirtualNode(int node) {
        return node >= this.routingCHGraph.getNodes();
    }

    private boolean isVirtualEdge(int edge) {
        return edge >= this.routingCHGraph.getEdges();
    }

    private static class VirtualCHEdgeIterator
    implements RoutingCHEdgeIterator {
        private List<RoutingCHEdgeIteratorState> edges;
        private int current = -1;

        private VirtualCHEdgeIterator() {
        }

        @Override
        public boolean next() {
            ++this.current;
            return this.current < this.edges.size();
        }

        void reset(List<RoutingCHEdgeIteratorState> edges) {
            this.edges = edges;
            this.current = -1;
        }

        @Override
        public int getEdge() {
            return this.getCurrent().getEdge();
        }

        @Override
        public int getOrigEdge() {
            return this.getCurrent().getOrigEdge();
        }

        @Override
        public int getOrigEdgeKeyFirst() {
            return this.getCurrent().getOrigEdgeKeyFirst();
        }

        @Override
        public int getOrigEdgeKeyLast() {
            return this.getCurrent().getOrigEdgeKeyLast();
        }

        @Override
        public int getBaseNode() {
            return this.getCurrent().getBaseNode();
        }

        @Override
        public int getAdjNode() {
            return this.getCurrent().getAdjNode();
        }

        @Override
        public boolean isShortcut() {
            return this.getCurrent().isShortcut();
        }

        @Override
        public int getSkippedEdge1() {
            if (!this.isShortcut()) {
                throw new IllegalStateException("Skipped edges are only available for shortcuts");
            }
            return this.getCurrent().getSkippedEdge1();
        }

        @Override
        public int getSkippedEdge2() {
            if (!this.isShortcut()) {
                throw new IllegalStateException("Skipped edges are only available for shortcuts");
            }
            return this.getCurrent().getSkippedEdge2();
        }

        @Override
        public double getWeight(boolean reverse) {
            return this.getCurrent().getWeight(reverse);
        }

        public String toString() {
            if (this.current < 0) {
                return "not started";
            }
            return this.edges.get(this.current).toString() + ", current: " + (this.current + 1) + "/" + this.edges.size();
        }

        private RoutingCHEdgeIteratorState getCurrent() {
            return this.edges.get(this.current);
        }
    }

    private static class VirtualCHEdgeIteratorState
    implements RoutingCHEdgeIteratorState {
        private final int edge;
        private final int origEdge;
        private final int baseNode;
        private final int adjNode;
        private final int origEdgeKeyFirst;
        private final int origEdgeKeyLast;
        private final int skippedEdge1;
        private final int skippedEdge2;
        private final double weightFwd;
        private final double weightBwd;

        public VirtualCHEdgeIteratorState(int edge, int origEdge, int baseNode, int adjNode, int origEdgeKeyFirst, int origEdgeKeyLast, int skippedEdge1, int skippedEdge2, double weightFwd, double weightBwd) {
            this.edge = edge;
            this.origEdge = origEdge;
            this.baseNode = baseNode;
            this.adjNode = adjNode;
            this.origEdgeKeyFirst = origEdgeKeyFirst;
            this.origEdgeKeyLast = origEdgeKeyLast;
            this.skippedEdge1 = skippedEdge1;
            this.skippedEdge2 = skippedEdge2;
            this.weightFwd = weightFwd;
            this.weightBwd = weightBwd;
        }

        @Override
        public int getEdge() {
            return this.edge;
        }

        @Override
        public int getOrigEdge() {
            return this.origEdge;
        }

        @Override
        public int getOrigEdgeKeyFirst() {
            return this.origEdgeKeyFirst;
        }

        @Override
        public int getOrigEdgeKeyLast() {
            return this.origEdgeKeyLast;
        }

        @Override
        public int getBaseNode() {
            return this.baseNode;
        }

        @Override
        public int getAdjNode() {
            return this.adjNode;
        }

        @Override
        public boolean isShortcut() {
            return this.origEdge == -1;
        }

        @Override
        public int getSkippedEdge1() {
            return this.skippedEdge1;
        }

        @Override
        public int getSkippedEdge2() {
            return this.skippedEdge2;
        }

        @Override
        public double getWeight(boolean reverse) {
            return reverse ? this.weightBwd : this.weightFwd;
        }

        public String toString() {
            return "virtual: " + this.edge + ": " + this.baseNode + "->" + this.adjNode + ", orig: " + this.origEdge + ", weightFwd: " + Helper.round2((double)this.weightFwd) + ", weightBwd: " + Helper.round2((double)this.weightBwd);
        }
    }
}

