/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.IntsRefEdgeIntAccess;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import java.util.Map;

public class VirtualEdgeIteratorState
implements EdgeIteratorState {
    private final PointList pointList;
    private final int edgeKey;
    private final int baseNode;
    private final int adjNode;
    private final int originalEdgeKey;
    private double distance;
    private IntsRef edgeFlags;
    private EdgeIntAccess edgeIntAccess;
    private Map<String, KVStorage.KValue> keyValues;
    private boolean unfavored;
    private EdgeIteratorState reverseEdge;
    private final boolean reverse;

    public VirtualEdgeIteratorState(int originalEdgeKey, int edgeKey, int baseNode, int adjNode, double distance, IntsRef edgeFlags, Map<String, KVStorage.KValue> keyValues, PointList pointList, boolean reverse) {
        this.originalEdgeKey = originalEdgeKey;
        this.edgeKey = edgeKey;
        this.baseNode = baseNode;
        this.adjNode = adjNode;
        this.distance = distance;
        this.edgeFlags = edgeFlags;
        this.edgeIntAccess = new IntsRefEdgeIntAccess(edgeFlags);
        this.keyValues = keyValues;
        this.pointList = pointList;
        this.reverse = reverse;
    }

    public int getOriginalEdgeKey() {
        return this.originalEdgeKey;
    }

    @Override
    public int getEdge() {
        return GHUtility.getEdgeFromEdgeKey(this.edgeKey);
    }

    @Override
    public int getEdgeKey() {
        return this.edgeKey;
    }

    @Override
    public int getReverseEdgeKey() {
        return GHUtility.reverseEdgeKey(this.edgeKey);
    }

    @Override
    public int getBaseNode() {
        return this.baseNode;
    }

    @Override
    public int getAdjNode() {
        return this.adjNode;
    }

    @Override
    public PointList fetchWayGeometry(FetchMode mode) {
        if (this.pointList.isEmpty()) {
            return PointList.EMPTY;
        }
        if (mode == FetchMode.TOWER_ONLY) {
            if (this.pointList.size() < 3) {
                return this.pointList.clone(false);
            }
            PointList towerNodes = new PointList(2, this.pointList.is3D());
            towerNodes.add((PointAccess)this.pointList, 0);
            towerNodes.add((PointAccess)this.pointList, this.pointList.size() - 1);
            return towerNodes;
        }
        if (mode == FetchMode.ALL) {
            return this.pointList.clone(false);
        }
        if (mode == FetchMode.BASE_AND_PILLAR) {
            return this.pointList.copy(0, this.pointList.size() - 1);
        }
        if (mode == FetchMode.PILLAR_AND_ADJ) {
            return this.pointList.copy(1, this.pointList.size());
        }
        if (mode == FetchMode.PILLAR_ONLY) {
            if (this.pointList.size() == 1) {
                return PointList.EMPTY;
            }
            return this.pointList.copy(1, this.pointList.size() - 1);
        }
        throw new UnsupportedOperationException("Illegal mode:" + mode);
    }

    @Override
    public EdgeIteratorState setWayGeometry(PointList list) {
        throw new UnsupportedOperationException("Not supported for virtual edge. Set when creating it.");
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public EdgeIteratorState setDistance(double dist) {
        this.distance = dist;
        return this;
    }

    @Override
    public IntsRef getFlags() {
        return this.edgeFlags;
    }

    @Override
    public EdgeIteratorState setFlags(IntsRef flags) {
        this.edgeFlags = flags;
        this.edgeIntAccess = new IntsRefEdgeIntAccess(flags);
        return this;
    }

    @Override
    public boolean get(BooleanEncodedValue property) {
        if (property == EdgeIteratorState.UNFAVORED_EDGE) {
            return this.unfavored;
        }
        return property.getBool(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
        property.setBool(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public boolean getReverse(BooleanEncodedValue property) {
        if (property == EdgeIteratorState.UNFAVORED_EDGE) {
            return this.unfavored;
        }
        return property.getBool(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
        property.setBool(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public EdgeIteratorState set(BooleanEncodedValue property, boolean fwd, boolean bwd) {
        if (!property.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
        }
        property.setBool(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, fwd);
        property.setBool(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, bwd);
        return this;
    }

    @Override
    public int get(IntEncodedValue property) {
        return property.getInt(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public EdgeIteratorState set(IntEncodedValue property, int value) {
        property.setInt(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public int getReverse(IntEncodedValue property) {
        return property.getInt(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
        property.setInt(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public EdgeIteratorState set(IntEncodedValue property, int fwd, int bwd) {
        if (!property.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
        }
        property.setInt(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, fwd);
        property.setInt(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, bwd);
        return this;
    }

    @Override
    public double get(DecimalEncodedValue property) {
        return property.getDecimal(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public EdgeIteratorState set(DecimalEncodedValue property, double value) {
        property.setDecimal(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public double getReverse(DecimalEncodedValue property) {
        return property.getDecimal(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
        property.setDecimal(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public EdgeIteratorState set(DecimalEncodedValue property, double fwd, double bwd) {
        if (!property.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
        }
        property.setDecimal(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, fwd);
        property.setDecimal(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, bwd);
        return this;
    }

    @Override
    public <T extends Enum<?>> T get(EnumEncodedValue<T> property) {
        return property.getEnum(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
        property.setEnum(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public <T extends Enum<?>> T getReverse(EnumEncodedValue<T> property) {
        return property.getEnum(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public <T extends Enum<?>> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
        property.setEnum(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T fwd, T bwd) {
        if (!property.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
        }
        property.setEnum(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, fwd);
        property.setEnum(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, bwd);
        return this;
    }

    @Override
    public String get(StringEncodedValue property) {
        return property.getString(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public EdgeIteratorState set(StringEncodedValue property, String value) {
        property.setString(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public String getReverse(StringEncodedValue property) {
        return property.getString(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess);
    }

    @Override
    public EdgeIteratorState setReverse(StringEncodedValue property, String value) {
        property.setString(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, value);
        return this;
    }

    @Override
    public EdgeIteratorState set(StringEncodedValue property, String fwd, String bwd) {
        if (!property.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
        }
        property.setString(this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, fwd);
        property.setString(!this.reverse, GHUtility.getEdgeFromEdgeKey(this.originalEdgeKey), this.edgeIntAccess, bwd);
        return this;
    }

    @Override
    public String getName() {
        String name = (String)this.getValue("street_name");
        return name == null ? "" : name;
    }

    @Override
    public EdgeIteratorState setKeyValues(Map<String, KVStorage.KValue> list) {
        this.keyValues = list;
        return this;
    }

    @Override
    public Map<String, KVStorage.KValue> getKeyValues() {
        return this.keyValues;
    }

    @Override
    public Object getValue(String key) {
        KVStorage.KValue value = this.keyValues.get(key);
        if (value != null) {
            if (!this.reverse && value.getFwd() != null) {
                return value.getFwd();
            }
            if (this.reverse && value.getBwd() != null) {
                return value.getBwd();
            }
        }
        return null;
    }

    public void setUnfavored(boolean unfavored) {
        this.unfavored = unfavored;
    }

    public String toString() {
        return this.baseNode + "->" + this.adjNode;
    }

    @Override
    public EdgeIteratorState detach(boolean reverse) {
        if (reverse) {
            this.reverseEdge.setFlags(this.getFlags());
            this.reverseEdge.setKeyValues(this.getKeyValues());
            this.reverseEdge.setDistance(this.getDistance());
            return this.reverseEdge;
        }
        return this;
    }

    @Override
    public EdgeIteratorState copyPropertiesFrom(EdgeIteratorState fromEdge) {
        throw new RuntimeException("Not supported.");
    }

    public void setReverseEdge(EdgeIteratorState reverseEdge) {
        this.reverseEdge = reverseEdge;
    }
}

