/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntIntScatterMap;
import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.LongArrayDeque;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EdgeBasedTarjanSCC {
    private final Graph graph;
    private final EdgeTransitionFilter edgeTransitionFilter;
    private final EdgeExplorer explorer;
    private final BitUtil bitUtil = BitUtil.LITTLE;
    private final IntArrayDeque tarjanStack;
    private final LongArrayDeque dfsStackPQ;
    private final IntArrayDeque dfsStackAdj;
    private final ConnectedComponents components;
    private final boolean excludeSingleEdgeComponents;
    private TarjanIntIntMap edgeKeyIndex;
    private TarjanIntIntMap edgeKeyLowLink;
    private TarjanIntSet edgeKeyOnStack;
    private int currIndex = 0;
    private int p;
    private int q;
    private int adj;
    private State dfsState;

    public static ConnectedComponents findComponents(Graph graph, EdgeTransitionFilter edgeTransitionFilter, boolean excludeSingleEdgeComponents) {
        return new EdgeBasedTarjanSCC(graph, edgeTransitionFilter, excludeSingleEdgeComponents).findComponents();
    }

    public static ConnectedComponents findComponentsForStartEdges(Graph graph, EdgeTransitionFilter edgeTransitionFilter, IntContainer edges) {
        return new EdgeBasedTarjanSCC(graph, edgeTransitionFilter, true).findComponentsForStartEdges(edges);
    }

    public static ConnectedComponents findComponentsRecursive(Graph graph, EdgeTransitionFilter edgeTransitionFilter, boolean excludeSingleEdgeComponents) {
        return new EdgeBasedTarjanSCC(graph, edgeTransitionFilter, excludeSingleEdgeComponents).findComponentsRecursive();
    }

    private EdgeBasedTarjanSCC(Graph graph, EdgeTransitionFilter edgeTransitionFilter, boolean excludeSingleEdgeComponents) {
        this.graph = graph;
        this.edgeTransitionFilter = edgeTransitionFilter;
        this.explorer = graph.createEdgeExplorer();
        this.tarjanStack = new IntArrayDeque();
        this.dfsStackPQ = new LongArrayDeque();
        this.dfsStackAdj = new IntArrayDeque();
        this.components = new ConnectedComponents(excludeSingleEdgeComponents ? -1 : 2 * graph.getEdges());
        this.excludeSingleEdgeComponents = excludeSingleEdgeComponents;
    }

    private void initForEntireGraph() {
        int edges = this.graph.getEdges();
        this.edgeKeyIndex = new TarjanArrayIntIntMap(2 * edges);
        this.edgeKeyLowLink = new TarjanArrayIntIntMap(2 * edges);
        this.edgeKeyOnStack = new TarjanArrayIntSet(2 * edges);
    }

    private void initForStartEdges(int edges) {
        this.edgeKeyIndex = new TarjanHashIntIntMap(2 * edges);
        this.edgeKeyLowLink = new TarjanHashIntIntMap(2 * edges);
        this.edgeKeyOnStack = new TarjanHashIntSet(2 * edges);
    }

    private ConnectedComponents findComponentsRecursive() {
        this.initForEntireGraph();
        AllEdgesIterator iter = this.graph.getAllEdges();
        while (iter.next()) {
            int edgeKeyBwd;
            int edgeKeyFwd = EdgeBasedTarjanSCC.createEdgeKey(iter, false);
            if (!this.edgeKeyIndex.has(edgeKeyFwd)) {
                this.findComponentForEdgeKey(edgeKeyFwd, iter.getAdjNode());
            }
            if (this.edgeKeyIndex.has(edgeKeyBwd = EdgeBasedTarjanSCC.createEdgeKey(iter, true))) continue;
            this.findComponentForEdgeKey(edgeKeyBwd, iter.getAdjNode());
        }
        return this.components;
    }

    private void findComponentForEdgeKey(int p, int adjNode) {
        this.setupNextEdgeKey(p);
        int edge = GHUtility.getEdgeFromEdgeKey(p);
        EdgeExplorer explorer = this.graph.createEdgeExplorer();
        EdgeIterator iter = explorer.setBaseNode(adjNode);
        while (iter.next()) {
            if (!this.edgeTransitionFilter.accept(edge, iter)) continue;
            int q = EdgeBasedTarjanSCC.createEdgeKey(iter, false);
            this.handleNeighbor(p, q, iter.getAdjNode());
        }
        this.buildComponent(p);
    }

    private void setupNextEdgeKey(int p) {
        this.edgeKeyIndex.set(p, this.currIndex);
        this.edgeKeyLowLink.set(p, this.currIndex);
        ++this.currIndex;
        this.tarjanStack.addLast(p);
        this.edgeKeyOnStack.add(p);
    }

    private void handleNeighbor(int p, int q, int adj) {
        if (!this.edgeKeyIndex.has(q)) {
            this.findComponentForEdgeKey(q, adj);
            this.edgeKeyLowLink.minTo(p, this.edgeKeyLowLink.get(q));
        } else if (this.edgeKeyOnStack.contains(q)) {
            this.edgeKeyLowLink.minTo(p, this.edgeKeyIndex.get(q));
        }
    }

    private void buildComponent(int p) {
        if (this.edgeKeyLowLink.get(p) == this.edgeKeyIndex.get(p)) {
            if (this.tarjanStack.getLast() == p) {
                this.tarjanStack.removeLast();
                this.edgeKeyOnStack.remove(p);
                ++this.components.numComponents;
                ++this.components.numEdgeKeys;
                if (!this.excludeSingleEdgeComponents) {
                    this.components.singleEdgeComponents.set((long)p);
                }
            } else {
                int q;
                IntArrayList component = new IntArrayList();
                do {
                    q = this.tarjanStack.removeLast();
                    component.add(q);
                    this.edgeKeyOnStack.remove(q);
                } while (q != p);
                component.trimToSize();
                assert (component.size() > 1);
                ++this.components.numComponents;
                this.components.numEdgeKeys += component.size();
                this.components.components.add(component);
                if (component.size() > this.components.biggestComponent.size()) {
                    this.components.biggestComponent = component;
                }
            }
        }
    }

    private ConnectedComponents findComponents() {
        this.initForEntireGraph();
        AllEdgesIterator iter = this.graph.getAllEdges();
        while (iter.next()) {
            this.findComponentsForEdgeState(iter);
        }
        return this.components;
    }

    private ConnectedComponents findComponentsForStartEdges(IntContainer startEdges) {
        this.initForStartEdges(startEdges.size());
        for (IntCursor edge : startEdges) {
            EdgeIteratorState edgeState = this.graph.getEdgeIteratorState(edge.value, Integer.MIN_VALUE);
            if (!this.edgeTransitionFilter.accept(-1, edgeState)) continue;
            this.findComponentsForEdgeState(edgeState);
        }
        return this.components;
    }

    private void findComponentsForEdgeState(EdgeIteratorState edge) {
        int edgeKeyFwd = EdgeBasedTarjanSCC.createEdgeKey(edge, false);
        if (!this.edgeKeyIndex.has(edgeKeyFwd)) {
            this.pushFindComponentForEdgeKey(edgeKeyFwd, edge.getAdjNode());
        }
        this.startSearch();
        int edgeKeyBwd = EdgeBasedTarjanSCC.createEdgeKey(edge, true);
        if (!this.edgeKeyIndex.has(edgeKeyBwd)) {
            this.pushFindComponentForEdgeKey(edgeKeyBwd, edge.getAdjNode());
        }
        this.startSearch();
    }

    private void startSearch() {
        block6: while (this.hasNext()) {
            this.pop();
            switch (this.dfsState) {
                case BUILD_COMPONENT: {
                    this.buildComponent(this.p);
                    continue block6;
                }
                case UPDATE: {
                    this.edgeKeyLowLink.minTo(this.p, this.edgeKeyLowLink.get(this.q));
                    continue block6;
                }
                case HANDLE_NEIGHBOR: {
                    if (this.edgeKeyIndex.has(this.q) && this.edgeKeyOnStack.contains(this.q)) {
                        this.edgeKeyLowLink.minTo(this.p, this.edgeKeyIndex.get(this.q));
                    }
                    if (this.edgeKeyIndex.has(this.q)) continue block6;
                    this.pushUpdateLowLinks(this.p, this.q);
                    this.pushFindComponentForEdgeKey(this.q, this.adj);
                    continue block6;
                }
                case FIND_COMPONENT: {
                    this.setupNextEdgeKey(this.p);
                    this.pushBuildComponent(this.p);
                    int edge = GHUtility.getEdgeFromEdgeKey(this.p);
                    EdgeIterator it = this.explorer.setBaseNode(this.adj);
                    while (it.next()) {
                        if (!this.edgeTransitionFilter.accept(edge, it)) continue;
                        int q = EdgeBasedTarjanSCC.createEdgeKey(it, false);
                        this.pushHandleNeighbor(this.p, q, it.getAdjNode());
                    }
                    continue block6;
                }
            }
            throw new IllegalStateException("Unknown state: " + this.dfsState);
        }
    }

    private boolean hasNext() {
        return !this.dfsStackPQ.isEmpty();
    }

    private void pop() {
        long l = this.dfsStackPQ.removeLast();
        int a = this.dfsStackAdj.removeLast();
        int low = this.bitUtil.getIntLow(l);
        int high = this.bitUtil.getIntHigh(l);
        if (a == -1) {
            this.dfsState = State.UPDATE;
            this.p = low;
            this.q = high;
            this.adj = -1;
        } else if (a == -2 && high == -2) {
            this.dfsState = State.BUILD_COMPONENT;
            this.p = low;
            this.q = -1;
            this.adj = -1;
        } else if (high == -1) {
            this.dfsState = State.FIND_COMPONENT;
            this.p = low;
            this.q = -1;
            this.adj = a;
        } else {
            assert (low >= 0 && high >= 0 && a >= 0);
            this.dfsState = State.HANDLE_NEIGHBOR;
            this.p = low;
            this.q = high;
            this.adj = a;
        }
    }

    private void pushUpdateLowLinks(int p, int q) {
        assert (p >= 0 && q >= 0);
        this.dfsStackPQ.addLast(this.bitUtil.toLong(p, q));
        this.dfsStackAdj.addLast(-1);
    }

    private void pushBuildComponent(int p) {
        assert (p >= 0);
        this.dfsStackPQ.addLast(this.bitUtil.toLong(p, -2));
        this.dfsStackAdj.addLast(-2);
    }

    private void pushFindComponentForEdgeKey(int p, int adj) {
        assert (p >= 0 && adj >= 0);
        this.dfsStackPQ.addLast(this.bitUtil.toLong(p, -1));
        this.dfsStackAdj.addLast(adj);
    }

    private void pushHandleNeighbor(int p, int q, int adj) {
        assert (p >= 0 && q >= 0 && adj >= 0);
        this.dfsStackPQ.addLast(this.bitUtil.toLong(p, q));
        this.dfsStackAdj.addLast(adj);
    }

    public static int createEdgeKey(EdgeIteratorState edgeState, boolean reverse) {
        return TraversalMode.EDGE_BASED.createTraversalId(edgeState, reverse);
    }

    public static interface EdgeTransitionFilter {
        public boolean accept(int var1, EdgeIteratorState var2);
    }

    public static class ConnectedComponents {
        private final List<IntArrayList> components = new ArrayList<IntArrayList>();
        private final BitSet singleEdgeComponents;
        private IntArrayList biggestComponent;
        private int numComponents;
        private int numEdgeKeys;

        ConnectedComponents(int edgeKeys) {
            this.singleEdgeComponents = new BitSet((long)Math.max(edgeKeys, 0));
            if (!this.singleEdgeComponents.getClass().getName().contains("hppc")) {
                throw new IllegalStateException("Was meant to be hppc BitSet");
            }
            this.biggestComponent = new IntArrayList();
        }

        public List<IntArrayList> getComponents() {
            return this.components;
        }

        public BitSet getSingleEdgeComponents() {
            return this.singleEdgeComponents;
        }

        public int getTotalComponents() {
            return this.numComponents;
        }

        public IntArrayList getBiggestComponent() {
            return this.biggestComponent;
        }

        public int getEdgeKeys() {
            return this.numEdgeKeys;
        }
    }

    private static class TarjanArrayIntIntMap
    implements TarjanIntIntMap {
        private final int[] arr;

        TarjanArrayIntIntMap(int elements) {
            this.arr = new int[elements];
            Arrays.fill(this.arr, -1);
        }

        @Override
        public void set(int key, int value) {
            this.arr[key] = value;
        }

        @Override
        public void minTo(int key, int value) {
            this.arr[key] = Math.min(this.arr[key], value);
        }

        @Override
        public boolean has(int key) {
            return this.arr[key] != -1;
        }

        @Override
        public int get(int key) {
            return this.arr[key];
        }
    }

    private static interface TarjanIntIntMap {
        public void set(int var1, int var2);

        public void minTo(int var1, int var2);

        public boolean has(int var1);

        public int get(int var1);
    }

    private static class TarjanArrayIntSet
    implements TarjanIntSet {
        private final BitSet set;

        TarjanArrayIntSet(int keys) {
            this.set = new BitSet((long)keys);
            if (!this.set.getClass().getName().contains("hppc")) {
                throw new IllegalStateException("Was meant to be hppc BitSet");
            }
        }

        @Override
        public void add(int key) {
            this.set.set((long)key);
        }

        @Override
        public boolean contains(int key) {
            return this.set.get(key);
        }

        @Override
        public void remove(int key) {
            this.set.clear((long)key);
        }
    }

    private static interface TarjanIntSet {
        public void add(int var1);

        public boolean contains(int var1);

        public void remove(int var1);
    }

    private static class TarjanHashIntIntMap
    implements TarjanIntIntMap {
        private final IntIntScatterMap map;

        TarjanHashIntIntMap(int keys) {
            this.map = new IntIntScatterMap(keys);
        }

        @Override
        public void set(int key, int value) {
            this.map.put(key, value);
        }

        @Override
        public void minTo(int key, int value) {
            this.map.put(key, Math.min(this.map.getOrDefault(key, -1), value));
        }

        @Override
        public boolean has(int key) {
            return this.map.containsKey(key);
        }

        @Override
        public int get(int key) {
            return this.map.getOrDefault(key, -1);
        }
    }

    private static class TarjanHashIntSet
    implements TarjanIntSet {
        private final IntScatterSet set;

        TarjanHashIntSet(int keys) {
            this.set = new IntScatterSet(keys);
        }

        @Override
        public void add(int key) {
            this.set.add(key);
        }

        @Override
        public boolean contains(int key) {
            return this.set.contains(key);
        }

        @Override
        public void remove(int key) {
            this.set.remove(key);
        }
    }

    private static enum State {
        UPDATE,
        HANDLE_NEIGHBOR,
        FIND_COMPONENT,
        BUILD_COMPONENT;

    }
}

