/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BikeCommonAverageSpeedParser
extends AbstractAverageSpeedParser
implements TagParser {
    private static final Set<String> CYCLEWAY_KEYS = Set.of("cycleway", "cycleway:left", "cycleway:both", "cycleway:right");
    protected static final int PUSHING_SECTION_SPEED = 4;
    protected static final int MIN_SPEED = 2;
    protected final HashSet<String> pushingSectionsHighways = new HashSet();
    private final Map<String, Integer> trackTypeSpeeds = new HashMap<String, Integer>();
    private final Map<String, Integer> surfaceSpeeds = new HashMap<String, Integer>();
    private final Map<Smoothness, Double> smoothnessFactor = new HashMap<Smoothness, Double>();
    private final Map<String, Integer> highwaySpeeds = new HashMap<String, Integer>();
    private final EnumEncodedValue<Smoothness> smoothnessEnc;
    private final Set<String> restrictedValues = Set.of("no", "agricultural", "forestry", "restricted", "military", "emergency", "private", "permit");

    protected BikeCommonAverageSpeedParser(DecimalEncodedValue speedEnc, EnumEncodedValue<Smoothness> smoothnessEnc, DecimalEncodedValue ferrySpeedEnc) {
        super(speedEnc, ferrySpeedEnc);
        this.smoothnessEnc = smoothnessEnc;
        this.addPushingSection("footway");
        this.addPushingSection("pedestrian");
        this.addPushingSection("steps");
        this.addPushingSection("platform");
        this.setTrackTypeSpeed("grade1", 18);
        this.setTrackTypeSpeed("grade2", 12);
        this.setTrackTypeSpeed("grade3", 8);
        this.setTrackTypeSpeed("grade4", 6);
        this.setTrackTypeSpeed("grade5", 4);
        this.setSurfaceSpeed("paved", 18);
        this.setSurfaceSpeed("asphalt", 18);
        this.setSurfaceSpeed("cobblestone", 8);
        this.setSurfaceSpeed("cobblestone:flattened", 10);
        this.setSurfaceSpeed("sett", 10);
        this.setSurfaceSpeed("concrete", 18);
        this.setSurfaceSpeed("concrete:lanes", 16);
        this.setSurfaceSpeed("concrete:plates", 16);
        this.setSurfaceSpeed("paving_stones", 16);
        this.setSurfaceSpeed("paving_stones:30", 16);
        this.setSurfaceSpeed("unpaved", 12);
        this.setSurfaceSpeed("compacted", 14);
        this.setSurfaceSpeed("dirt", 10);
        this.setSurfaceSpeed("earth", 12);
        this.setSurfaceSpeed("fine_gravel", 14);
        this.setSurfaceSpeed("grass", 8);
        this.setSurfaceSpeed("grass_paver", 8);
        this.setSurfaceSpeed("gravel", 12);
        this.setSurfaceSpeed("ground", 12);
        this.setSurfaceSpeed("ice", 2);
        this.setSurfaceSpeed("metal", 10);
        this.setSurfaceSpeed("mud", 10);
        this.setSurfaceSpeed("pebblestone", 14);
        this.setSurfaceSpeed("salt", 4);
        this.setSurfaceSpeed("sand", 4);
        this.setSurfaceSpeed("wood", 4);
        this.setHighwaySpeed("living_street", 4);
        this.setHighwaySpeed("steps", 2);
        this.setHighwaySpeed("cycleway", 18);
        this.setHighwaySpeed("path", 4);
        this.setHighwaySpeed("footway", 4);
        this.setHighwaySpeed("platform", 4);
        this.setHighwaySpeed("pedestrian", 4);
        this.setHighwaySpeed("track", 12);
        this.setHighwaySpeed("service", 12);
        this.setHighwaySpeed("residential", 18);
        this.setHighwaySpeed("unclassified", 16);
        this.setHighwaySpeed("road", 12);
        this.setHighwaySpeed("trunk", 18);
        this.setHighwaySpeed("trunk_link", 18);
        this.setHighwaySpeed("primary", 18);
        this.setHighwaySpeed("primary_link", 18);
        this.setHighwaySpeed("secondary", 18);
        this.setHighwaySpeed("secondary_link", 18);
        this.setHighwaySpeed("tertiary", 18);
        this.setHighwaySpeed("tertiary_link", 18);
        this.setHighwaySpeed("motorway", 18);
        this.setHighwaySpeed("motorway_link", 18);
        this.setHighwaySpeed("bridleway", 4);
        this.setSmoothnessSpeedFactor(Smoothness.MISSING, 1.0);
        this.setSmoothnessSpeedFactor(Smoothness.OTHER, 0.7);
        this.setSmoothnessSpeedFactor(Smoothness.EXCELLENT, 1.1);
        this.setSmoothnessSpeedFactor(Smoothness.GOOD, 1.0);
        this.setSmoothnessSpeedFactor(Smoothness.INTERMEDIATE, 0.9);
        this.setSmoothnessSpeedFactor(Smoothness.BAD, 0.7);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_BAD, 0.4);
        this.setSmoothnessSpeedFactor(Smoothness.HORRIBLE, 0.3);
        this.setSmoothnessSpeedFactor(Smoothness.VERY_HORRIBLE, 0.1);
        this.setSmoothnessSpeedFactor(Smoothness.IMPASSABLE, 0.0);
    }

    double applyMaxSpeed(ReaderWay way, double speed, boolean bwd) {
        double maxSpeed = BikeCommonAverageSpeedParser.getMaxSpeed(way, bwd);
        return BikeCommonAverageSpeedParser.isValidSpeed(maxSpeed) && speed > maxSpeed ? maxSpeed : speed;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            if (FerrySpeedCalculator.isFerry(way)) {
                double ferrySpeed = FerrySpeedCalculator.minmax(this.ferrySpeedEnc.getDecimal(false, edgeId, edgeIntAccess), this.avgSpeedEnc);
                this.setSpeed(false, edgeId, edgeIntAccess, ferrySpeed);
                if (this.avgSpeedEnc.isStoreTwoDirections()) {
                    this.setSpeed(true, edgeId, edgeIntAccess, ferrySpeed);
                }
            }
            if (!way.hasTag("railway", (Object)"platform") && !way.hasTag("man_made", (Object)"pier")) {
                return;
            }
        }
        double speed = this.highwaySpeeds.getOrDefault(highwayValue, 4).intValue();
        String surfaceValue = way.getTag("surface");
        String trackTypeValue = way.getTag("tracktype");
        boolean pushingRestriction = Arrays.stream(way.getTag("vehicle", "").split(";")).anyMatch(this.restrictedValues::contains);
        if (!"steps".equals(highwayValue)) {
            if (way.hasTag("bicycle", (Object)"dismount") || way.hasTag("railway", (Object)"platform") || pushingRestriction && !way.hasTag("bicycle", AbstractAccessParser.INTENDED)) {
                speed = 4.0;
            } else if (this.pushingSectionsHighways.contains(highwayValue)) {
                if (way.hasTag("bicycle", (Object)"designated") || way.hasTag("bicycle", (Object)"official") || way.hasTag("segregated", (Object)"yes") || CYCLEWAY_KEYS.stream().anyMatch(k -> way.getTag((String)k, "").equals("track"))) {
                    speed = this.trackTypeSpeeds.getOrDefault(trackTypeValue, this.highwaySpeeds.get("cycleway")).intValue();
                } else if (way.hasTag("bicycle", (Object)"yes")) {
                    speed = 12.0;
                }
            }
        }
        Integer surfaceSpeed = this.surfaceSpeeds.get(surfaceValue);
        if (way.hasTag("surface", new String[0]) && surfaceSpeed == null) {
            speed = 4.0;
        } else if (way.hasTag("service", new String[0])) {
            speed = this.highwaySpeeds.get("living_street").intValue();
        } else if ("track".equals(highwayValue) || "bridleway".equals(highwayValue)) {
            if (surfaceSpeed != null) {
                speed = surfaceSpeed.intValue();
            } else if (this.trackTypeSpeeds.containsKey(trackTypeValue)) {
                speed = this.trackTypeSpeeds.get(trackTypeValue).intValue();
            }
        } else if (surfaceSpeed != null) {
            speed = Math.min((double)surfaceSpeed.intValue(), speed);
        }
        Smoothness smoothness = this.smoothnessEnc.getEnum(false, edgeId, edgeIntAccess);
        speed = Math.max(2.0, this.smoothnessFactor.get((Object)smoothness) * speed);
        this.setSpeed(false, edgeId, edgeIntAccess, this.applyMaxSpeed(way, speed, false));
        if (this.avgSpeedEnc.isStoreTwoDirections()) {
            this.setSpeed(true, edgeId, edgeIntAccess, this.applyMaxSpeed(way, speed, true));
        }
    }

    void setHighwaySpeed(String highway, int speed) {
        this.highwaySpeeds.put(highway, speed);
    }

    void addPushingSection(String highway) {
        this.pushingSectionsHighways.add(highway);
    }

    void setTrackTypeSpeed(String tracktype, int speed) {
        this.trackTypeSpeeds.put(tracktype, speed);
    }

    void setSurfaceSpeed(String surface, int speed) {
        this.surfaceSpeeds.put(surface, speed);
    }

    void setSmoothnessSpeedFactor(Smoothness smoothness, double speedfactor) {
        this.smoothnessFactor.put(smoothness, speedfactor);
    }
}

