/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class BikeCommonPriorityParser
implements TagParser {
    private static final List<String> CYCLEWAY_BICYCLE_KEYS = List.of("cycleway:bicycle", "cycleway:both:bicycle", "cycleway:left:bicycle", "cycleway:right:bicycle");
    protected final HashSet<String> pushingSectionsHighways = new HashSet();
    protected final Set<String> preferHighwayTags = new HashSet<String>();
    protected final Map<String, PriorityCode> avoidHighwayTags = new HashMap<String, PriorityCode>();
    protected final Set<String> unpavedSurfaceTags = new HashSet<String>();
    protected final DecimalEncodedValue avgSpeedEnc;
    protected final DecimalEncodedValue priorityEnc;
    int avoidSpeedLimit;
    EnumEncodedValue<RouteNetwork> bikeRouteEnc;
    Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();
    protected final Set<String> goodSurface = Set.of("paved", "asphalt", "concrete");
    private String classBicycleKey;

    protected BikeCommonPriorityParser(DecimalEncodedValue priorityEnc, DecimalEncodedValue avgSpeedEnc, EnumEncodedValue<RouteNetwork> bikeRouteEnc) {
        this.bikeRouteEnc = bikeRouteEnc;
        this.priorityEnc = priorityEnc;
        this.avgSpeedEnc = avgSpeedEnc;
        this.addPushingSection("footway");
        this.addPushingSection("pedestrian");
        this.addPushingSection("steps");
        this.addPushingSection("platform");
        this.unpavedSurfaceTags.add("unpaved");
        this.unpavedSurfaceTags.add("gravel");
        this.unpavedSurfaceTags.add("ground");
        this.unpavedSurfaceTags.add("dirt");
        this.unpavedSurfaceTags.add("grass");
        this.unpavedSurfaceTags.add("compacted");
        this.unpavedSurfaceTags.add("earth");
        this.unpavedSurfaceTags.add("fine_gravel");
        this.unpavedSurfaceTags.add("grass_paver");
        this.unpavedSurfaceTags.add("ice");
        this.unpavedSurfaceTags.add("mud");
        this.unpavedSurfaceTags.add("salt");
        this.unpavedSurfaceTags.add("sand");
        this.unpavedSurfaceTags.add("wood");
        this.avoidHighwayTags.put("motorway", PriorityCode.REACH_DESTINATION);
        this.avoidHighwayTags.put("motorway_link", PriorityCode.REACH_DESTINATION);
        this.avoidHighwayTags.put("trunk", PriorityCode.REACH_DESTINATION);
        this.avoidHighwayTags.put("trunk_link", PriorityCode.REACH_DESTINATION);
        this.avoidHighwayTags.put("primary", PriorityCode.BAD);
        this.avoidHighwayTags.put("primary_link", PriorityCode.BAD);
        this.avoidHighwayTags.put("secondary", PriorityCode.AVOID);
        this.avoidHighwayTags.put("secondary_link", PriorityCode.AVOID);
        this.avoidHighwayTags.put("bridleway", PriorityCode.AVOID);
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.BEST.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.VERY_NICE.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.PREFER.getValue());
        this.avoidSpeedLimit = 71;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        String highwayValue = way.getTag("highway");
        Integer priorityFromRelation = this.routeMap.get((Object)this.bikeRouteEnc.getEnum(false, edgeId, edgeIntAccess));
        if (highwayValue == null) {
            if (FerrySpeedCalculator.isFerry(way)) {
                priorityFromRelation = PriorityCode.SLIGHT_AVOID.getValue();
            } else {
                return;
            }
        }
        double maxSpeed = Math.max(this.avgSpeedEnc.getDecimal(false, edgeId, edgeIntAccess), this.avgSpeedEnc.getDecimal(true, edgeId, edgeIntAccess));
        this.priorityEnc.setDecimal(false, edgeId, edgeIntAccess, PriorityCode.getValue(this.handlePriority(way, maxSpeed, priorityFromRelation)));
    }

    int handlePriority(ReaderWay way, double wayTypeSpeed, Integer priorityFromRelation) {
        TreeMap<Double, PriorityCode> weightToPrioMap = new TreeMap<Double, PriorityCode>();
        if (priorityFromRelation == null) {
            weightToPrioMap.put(0.0, PriorityCode.UNCHANGED);
        } else {
            weightToPrioMap.put(110.0, PriorityCode.valueOf(priorityFromRelation));
        }
        this.collect(way, wayTypeSpeed, weightToPrioMap);
        return weightToPrioMap.lastEntry().getValue().getValue();
    }

    private PriorityCode convertClassValueToPriority(String tagvalue) {
        int classvalue;
        try {
            classvalue = Integer.parseInt(tagvalue);
        }
        catch (NumberFormatException e) {
            return PriorityCode.UNCHANGED;
        }
        switch (classvalue) {
            case 3: {
                return PriorityCode.BEST;
            }
            case 2: {
                return PriorityCode.VERY_NICE;
            }
            case 1: {
                return PriorityCode.PREFER;
            }
            case -1: {
                return PriorityCode.SLIGHT_AVOID;
            }
            case -2: {
                return PriorityCode.AVOID;
            }
            case -3: {
                return PriorityCode.AVOID_MORE;
            }
        }
        return PriorityCode.UNCHANGED;
    }

    void collect(ReaderWay way, double wayTypeSpeed, TreeMap<Double, PriorityCode> weightToPrioMap) {
        PriorityCode lastEntryValue;
        String classBicycleValue;
        Set cyclewayValues;
        String highway = way.getTag("highway");
        if (this.isDesignated(way)) {
            boolean isGoodSurface;
            boolean bl = isGoodSurface = way.getTag("tracktype", "").equals("grade1") || this.goodSurface.contains(way.getTag("surface", ""));
            if ("path".equals(highway) || "track".equals(highway) && isGoodSurface) {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE);
            } else {
                weightToPrioMap.put(100.0, PriorityCode.PREFER);
            }
        }
        if ("cycleway".equals(highway)) {
            if (way.hasTag("foot", AbstractAccessParser.INTENDED) && !way.hasTag("segregated", (Object)"yes")) {
                weightToPrioMap.put(100.0, PriorityCode.PREFER);
            } else {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE);
            }
        }
        double maxSpeed = Math.max(AbstractAverageSpeedParser.getMaxSpeed(way, false), AbstractAverageSpeedParser.getMaxSpeed(way, true));
        if (this.preferHighwayTags.contains(highway) || AbstractAverageSpeedParser.isValidSpeed(maxSpeed) && maxSpeed <= 30.0) {
            if (!AbstractAverageSpeedParser.isValidSpeed(maxSpeed) || maxSpeed < (double)this.avoidSpeedLimit) {
                weightToPrioMap.put(40.0, PriorityCode.PREFER);
                if (way.hasTag("tunnel", AbstractAccessParser.INTENDED)) {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED);
                }
            }
        } else if (this.avoidHighwayTags.containsKey(highway) || AbstractAverageSpeedParser.isValidSpeed(maxSpeed) && maxSpeed >= (double)this.avoidSpeedLimit && !"track".equals(highway)) {
            PriorityCode priorityCode = this.avoidHighwayTags.get(highway);
            weightToPrioMap.put(50.0, priorityCode == null ? PriorityCode.AVOID : priorityCode);
            if (way.hasTag("tunnel", AbstractAccessParser.INTENDED)) {
                PriorityCode worse = priorityCode == null ? PriorityCode.BAD : priorityCode.worse().worse();
                weightToPrioMap.put(50.0, worse == PriorityCode.EXCLUDE ? PriorityCode.REACH_DESTINATION : worse);
            }
        }
        if (way.hasTag("bicycle", (Object)"use_sidepath")) {
            weightToPrioMap.put(100.0, PriorityCode.REACH_DESTINATION);
        }
        if ((cyclewayValues = Stream.of("cycleway", "cycleway:left", "cycleway:both", "cycleway:right").map(key -> way.getTag((String)key, "")).collect(Collectors.toSet())).contains("track")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER);
        } else if (Stream.of("lane", "opposite_track", "shared_lane", "share_busway", "shoulder").anyMatch(cyclewayValues::contains)) {
            weightToPrioMap.put(100.0, PriorityCode.SLIGHT_PREFER);
        } else if (this.pushingSectionsHighways.contains(highway) || "parking_aisle".equals(way.getTag("service"))) {
            PriorityCode pushingSectionPrio = PriorityCode.SLIGHT_AVOID;
            if (way.hasTag("highway", (Object)"steps")) {
                pushingSectionPrio = PriorityCode.BAD;
            } else if (way.hasTag("bicycle", (Object)"yes") || way.hasTag("bicycle", (Object)"permissive")) {
                pushingSectionPrio = PriorityCode.PREFER;
            } else if (this.isDesignated(way)) {
                pushingSectionPrio = PriorityCode.VERY_NICE;
            }
            if (way.hasTag("foot", (Object)"yes") && !way.hasTag("segregated", (Object)"yes")) {
                pushingSectionPrio = pushingSectionPrio.worse();
            }
            weightToPrioMap.put(100.0, pushingSectionPrio);
        }
        if (way.hasTag("railway", (Object)"tram")) {
            weightToPrioMap.put(50.0, PriorityCode.AVOID_MORE);
        }
        if (way.hasTag("lcn", (Object)"yes")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER);
        }
        if ((classBicycleValue = way.getTag(this.classBicycleKey)) != null) {
            weightToPrioMap.put(100.0, this.convertClassValueToPriority(classBicycleValue));
        } else {
            String classBicycle = way.getTag("class:bicycle");
            if (classBicycle != null) {
                weightToPrioMap.put(100.0, this.convertClassValueToPriority(classBicycle));
            }
        }
        if ((way.hasTag("scenic", (Object)"yes") || maxSpeed > 0.0 && maxSpeed <= wayTypeSpeed) && (lastEntryValue = weightToPrioMap.lastEntry().getValue()).getValue() < PriorityCode.BEST.getValue()) {
            weightToPrioMap.put(110.0, lastEntryValue.better());
        }
    }

    boolean isDesignated(ReaderWay way) {
        return way.hasTag("bicycle", (Object)"designated") || way.hasTag(CYCLEWAY_BICYCLE_KEYS, (Object)"designated") || way.hasTag("bicycle_road", (Object)"yes") || way.hasTag("cyclestreet", (Object)"yes") || way.hasTag("bicycle", (Object)"official");
    }

    void addPushingSection(String highway) {
        this.pushingSectionsHighways.add(highway);
    }

    void setSpecificClassBicycle(String subkey) {
        this.classBicycleKey = "class:bicycle:" + subkey;
    }

    public final DecimalEncodedValue getPriorityEnc() {
        return this.priorityEnc;
    }
}

