/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.OSMTemporalAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CarAccessParser
extends AbstractAccessParser
implements TagParser {
    protected final Set<String> trackTypeValues = new HashSet<String>();
    protected final Set<String> highwayValues = new HashSet<String>();
    protected final BooleanEncodedValue roundaboutEnc;

    public CarAccessParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key("car")), lookup.getBooleanEncodedValue("roundabout"), properties, TransportationMode.CAR);
    }

    public CarAccessParser(BooleanEncodedValue accessEnc, BooleanEncodedValue roundaboutEnc, PMap properties, TransportationMode transportationMode) {
        super(accessEnc, transportationMode);
        this.roundaboutEnc = roundaboutEnc;
        this.restrictedValues.add("agricultural");
        this.restrictedValues.add("forestry");
        this.restrictedValues.add("delivery");
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
        this.barriers.add("kissing_gate");
        this.barriers.add("fence");
        this.barriers.add("bollard");
        this.barriers.add("stile");
        this.barriers.add("turnstile");
        this.barriers.add("cycle_barrier");
        this.barriers.add("motorcycle_barrier");
        this.barriers.add("block");
        this.barriers.add("bus_trap");
        this.barriers.add("sump_buster");
        this.barriers.add("jersey_barrier");
        this.highwayValues.addAll(Arrays.asList("motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "residential", "living_street", "service", "road", "track"));
        this.trackTypeValues.addAll(Arrays.asList("grade1", "grade2", "grade3", null));
    }

    public WayAccess getAccess(ReaderWay way) {
        String firstValue;
        String highwayValue = way.getTag("highway");
        int firstIndex = way.getFirstIndex(this.restrictionKeys);
        String string = firstValue = firstIndex < 0 ? "" : way.getTag((String)this.restrictionKeys.get(firstIndex), "");
        if (highwayValue == null) {
            if (FerrySpeedCalculator.isFerry(way)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return WayAccess.CAN_SKIP;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0]) || way.hasTag("hgv", (Object)"yes")) {
                    return WayAccess.FERRY;
                }
            }
            return WayAccess.CAN_SKIP;
        }
        if ("service".equals(highwayValue) && "emergency_access".equals(way.getTag("service"))) {
            return WayAccess.CAN_SKIP;
        }
        if ("track".equals(highwayValue) && !this.trackTypeValues.contains(way.getTag("tracktype"))) {
            return WayAccess.CAN_SKIP;
        }
        if (!this.highwayValues.contains(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return WayAccess.CAN_SKIP;
        }
        if (firstIndex >= 0) {
            String[] restrict;
            for (String value : restrict = firstValue.split(";")) {
                if (this.restrictedValues.contains(value) && !OSMTemporalAccessParser.hasTemporalRestriction(way, firstIndex, this.restrictionKeys)) {
                    return WayAccess.CAN_SKIP;
                }
                if (!this.intendedValues.contains(value)) continue;
                return WayAccess.WAY;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return;
        }
        if (!access.isFerry()) {
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeId, edgeIntAccess);
            if (this.isOneway(way) || isRoundabout) {
                if (this.isForwardOneway(way)) {
                    this.accessEnc.setBool(false, edgeId, edgeIntAccess, true);
                }
                if (this.isBackwardOneway(way)) {
                    this.accessEnc.setBool(true, edgeId, edgeIntAccess, true);
                }
            } else {
                this.accessEnc.setBool(false, edgeId, edgeIntAccess, true);
                this.accessEnc.setBool(true, edgeId, edgeIntAccess, true);
            }
        } else {
            this.accessEnc.setBool(false, edgeId, edgeIntAccess, true);
            this.accessEnc.setBool(true, edgeId, edgeIntAccess, true);
        }
        if (way.hasTag("gh:barrier_edge", new String[0])) {
            List nodeTags = way.getTag("node_tags", Collections.emptyList());
            this.handleBarrierEdge(edgeId, edgeIntAccess, (Map)nodeTags.get(0));
        }
    }

    protected boolean isBackwardOneway(ReaderWay way) {
        return way.hasTag("oneway", (Object)"-1") || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("motor_vehicle:forward", (Collection<String>)this.restrictedValues);
    }

    protected boolean isForwardOneway(ReaderWay way) {
        return !way.hasTag("oneway", (Object)"-1") && !way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) && !way.hasTag("motor_vehicle:forward", (Collection<String>)this.restrictedValues);
    }

    protected boolean isOneway(ReaderWay way) {
        return way.hasTag("oneway", (Collection<String>)ONEWAYS) || way.hasTag("vehicle:backward", (Collection<String>)this.restrictedValues) || way.hasTag("vehicle:forward", (Collection<String>)this.restrictedValues) || way.hasTag("motor_vehicle:backward", (Collection<String>)this.restrictedValues) || way.hasTag("motor_vehicle:forward", (Collection<String>)this.restrictedValues);
    }
}

