/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FootPriorityParser
implements TagParser {
    final Set<String> safeHighwayTags = new HashSet<String>();
    final Map<String, PriorityCode> avoidHighwayTags = new HashMap<String, PriorityCode>();
    protected HashSet<String> sidewalkValues = new HashSet(5);
    protected HashSet<String> sidewalksNoValues = new HashSet(5);
    protected final DecimalEncodedValue priorityWayEncoder;
    protected EnumEncodedValue<RouteNetwork> footRouteEnc;
    protected Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();

    public FootPriorityParser(EncodedValueLookup lookup) {
        this(lookup.getDecimalEncodedValue(VehiclePriority.key("foot")), lookup.getEnumEncodedValue(FootNetwork.KEY, RouteNetwork.class));
    }

    protected FootPriorityParser(DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> footRouteEnc) {
        this.footRouteEnc = footRouteEnc;
        this.priorityWayEncoder = priorityEnc;
        this.sidewalksNoValues.add("no");
        this.sidewalksNoValues.add("none");
        this.sidewalksNoValues.add("separate");
        this.sidewalkValues.add("yes");
        this.sidewalkValues.add("both");
        this.sidewalkValues.add("left");
        this.sidewalkValues.add("right");
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("path");
        this.safeHighwayTags.add("steps");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("track");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.avoidHighwayTags.put("motorway", PriorityCode.REACH_DESTINATION);
        this.avoidHighwayTags.put("motorway_link", PriorityCode.REACH_DESTINATION);
        this.avoidHighwayTags.put("trunk", PriorityCode.REACH_DESTINATION);
        this.avoidHighwayTags.put("trunk_link", PriorityCode.REACH_DESTINATION);
        this.avoidHighwayTags.put("primary", PriorityCode.BAD);
        this.avoidHighwayTags.put("primary_link", PriorityCode.BAD);
        this.avoidHighwayTags.put("secondary", PriorityCode.BAD);
        this.avoidHighwayTags.put("secondary_link", PriorityCode.BAD);
        this.avoidHighwayTags.put("tertiary", PriorityCode.AVOID);
        this.avoidHighwayTags.put("tertiary_link", PriorityCode.AVOID);
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.UNCHANGED.getValue());
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        String highwayValue = way.getTag("highway");
        Integer priorityFromRelation = this.routeMap.get((Object)this.footRouteEnc.getEnum(false, edgeId, edgeIntAccess));
        if (highwayValue == null) {
            if (FerrySpeedCalculator.isFerry(way)) {
                this.priorityWayEncoder.setDecimal(false, edgeId, edgeIntAccess, PriorityCode.getValue(this.handlePriority(way, priorityFromRelation)));
            }
        } else {
            this.priorityWayEncoder.setDecimal(false, edgeId, edgeIntAccess, PriorityCode.getValue(this.handlePriority(way, priorityFromRelation)));
        }
    }

    public int handlePriority(ReaderWay way, Integer priorityFromRelation) {
        TreeMap<Double, PriorityCode> weightToPrioMap = new TreeMap<Double, PriorityCode>();
        if (priorityFromRelation == null) {
            weightToPrioMap.put(0.0, PriorityCode.UNCHANGED);
        } else {
            weightToPrioMap.put(110.0, PriorityCode.valueOf(priorityFromRelation));
        }
        this.collect(way, weightToPrioMap);
        return weightToPrioMap.lastEntry().getValue().getValue();
    }

    void collect(ReaderWay way, TreeMap<Double, PriorityCode> weightToPrioMap) {
        String highway = way.getTag("highway");
        if (way.hasTag("foot", (Object)"designated")) {
            weightToPrioMap.put(100.0, PriorityCode.PREFER);
        }
        if (way.hasTag("foot", (Object)"use_sidepath")) {
            weightToPrioMap.put(100.0, PriorityCode.VERY_BAD);
        }
        double maxSpeed = Math.max(AbstractAverageSpeedParser.getMaxSpeed(way, false), AbstractAverageSpeedParser.getMaxSpeed(way, true));
        if (this.safeHighwayTags.contains(highway) || AbstractAverageSpeedParser.isValidSpeed(maxSpeed) && maxSpeed <= 20.0) {
            weightToPrioMap.put(40.0, PriorityCode.PREFER);
            if (way.hasTag("tunnel", AbstractAccessParser.INTENDED)) {
                if (way.hasTag("sidewalk", this.sidewalksNoValues)) {
                    weightToPrioMap.put(40.0, PriorityCode.AVOID);
                } else {
                    weightToPrioMap.put(40.0, PriorityCode.UNCHANGED);
                }
            }
        } else if (AbstractAverageSpeedParser.isValidSpeed(maxSpeed) && maxSpeed > 50.0 || this.avoidHighwayTags.containsKey(highway)) {
            PriorityCode priorityCode = this.avoidHighwayTags.get(highway);
            if (way.hasTag("sidewalk", this.sidewalksNoValues)) {
                weightToPrioMap.put(40.0, priorityCode == null ? PriorityCode.BAD : priorityCode);
            } else {
                weightToPrioMap.put(40.0, priorityCode == null ? PriorityCode.AVOID : priorityCode.better().better());
            }
        } else if (way.hasTag("sidewalk", this.sidewalksNoValues)) {
            weightToPrioMap.put(40.0, PriorityCode.AVOID);
        }
        if (way.hasTag("bicycle", (Object)"official") || way.hasTag("bicycle", (Object)"designated")) {
            weightToPrioMap.put(44.0, PriorityCode.SLIGHT_AVOID);
        }
    }
}

