/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.OSMTemporalAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModeAccessParser
implements TagParser {
    private static final Set<String> CAR_BARRIERS = Set.of("kissing_gate", "fence", "bollard", "stile", "turnstile", "cycle_barrier", "motorcycle_barrier", "block", "bus_trap", "sump_buster", "jersey_barrier");
    private static final Set<String> INTENDED = Set.of("yes", "designated", "official", "permissive", "private", "permit");
    private static final Set<String> ONEWAYS_FW = Set.of("yes", "true", "1");
    private final Set<String> restrictedValues;
    private final List<String> restrictionKeys;
    private final List<String> vehicleForward;
    private final List<String> vehicleBackward;
    private final List<String> ignoreOnewayKeys;
    private final BooleanEncodedValue accessEnc;
    private final BooleanEncodedValue roundaboutEnc;
    private final boolean skipEmergency;
    private final Set<String> barriers;

    public ModeAccessParser(TransportationMode mode, BooleanEncodedValue accessEnc, boolean skipEmergency, BooleanEncodedValue roundaboutEnc, Set<String> restrictions, Set<String> barriers) {
        this.accessEnc = accessEnc;
        this.roundaboutEnc = roundaboutEnc;
        this.restrictionKeys = OSMRoadAccessParser.toOSMRestrictions(mode);
        this.vehicleForward = this.restrictionKeys.stream().map(r -> r + ":forward").toList();
        this.vehicleBackward = this.restrictionKeys.stream().map(r -> r + ":backward").toList();
        this.ignoreOnewayKeys = this.restrictionKeys.stream().map(r -> "oneway:" + r).toList();
        this.restrictedValues = restrictions.isEmpty() ? Set.of("no", "restricted", "military", "emergency") : restrictions;
        Set<String> set = this.barriers = barriers.isEmpty() ? CAR_BARRIERS : barriers;
        if (this.restrictedValues.contains("")) {
            throw new IllegalArgumentException("restriction values cannot contain empty string");
        }
        this.skipEmergency = skipEmergency;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        String firstValue;
        String highwayValue = way.getTag("highway");
        if (this.skipEmergency && "service".equals(highwayValue) && "emergency_access".equals(way.getTag("service"))) {
            return;
        }
        int firstIndex = way.getFirstIndex(this.restrictionKeys);
        String string = firstValue = firstIndex < 0 ? "" : way.getTag(this.restrictionKeys.get(firstIndex), "");
        if (this.restrictedValues.contains(firstValue) && !OSMTemporalAccessParser.hasTemporalRestriction(way, firstIndex, this.restrictionKeys)) {
            return;
        }
        if (way.hasTag("gh:barrier_edge", new String[0]) && way.hasTag("node_tags", new String[0])) {
            String barrierValue;
            List nodeTags = way.getTag("node_tags", null);
            Map firstNodeTags = (Map)nodeTags.get(0);
            firstValue = ModeAccessParser.getFirstPriorityNodeTag(firstNodeTags, this.restrictionKeys);
            String string2 = barrierValue = firstNodeTags.containsKey("barrier") ? (String)firstNodeTags.get("barrier") : "";
            if (this.restrictedValues.contains(firstValue) || this.barriers.contains(barrierValue) || "yes".equals(firstNodeTags.get("locked")) && !INTENDED.contains(firstValue)) {
                return;
            }
        }
        if (FerrySpeedCalculator.isFerry(way)) {
            boolean isCar = this.restrictionKeys.contains("motorcar");
            if (INTENDED.contains(firstValue) || isCar && firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0]) || isCar && way.hasTag("hgv", (Object)"yes")) {
                this.accessEnc.setBool(false, edgeId, edgeIntAccess, true);
                this.accessEnc.setBool(true, edgeId, edgeIntAccess, true);
            }
        } else {
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeId, edgeIntAccess);
            boolean ignoreOneway = "no".equals(way.getFirstValue(this.ignoreOnewayKeys));
            boolean isBwd = this.isBackwardOneway(way);
            if (!ignoreOneway && (isBwd || isRoundabout || this.isForwardOneway(way))) {
                this.accessEnc.setBool(isBwd, edgeId, edgeIntAccess, true);
            } else {
                this.accessEnc.setBool(false, edgeId, edgeIntAccess, true);
                this.accessEnc.setBool(true, edgeId, edgeIntAccess, true);
            }
        }
    }

    private static String getFirstPriorityNodeTag(Map<String, Object> nodeTags, List<String> restrictionKeys) {
        for (String key : restrictionKeys) {
            String val = (String)nodeTags.get(key);
            if (val == null) continue;
            return val;
        }
        return "";
    }

    protected boolean isBackwardOneway(ReaderWay way) {
        return way.hasTag("oneway", (Object)"-1") || "no".equals(way.getFirstValue(this.vehicleForward));
    }

    protected boolean isForwardOneway(ReaderWay way) {
        return way.hasTag("oneway", ONEWAYS_FW) || "no".equals(way.getFirstValue(this.vehicleBackward));
    }
}

