/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class OSMGetOffBikeParser
implements TagParser {
    private final List<String> INTENDED = Arrays.asList("designated", "yes", "official", "permissive");
    private final HashSet<String> GET_OFF_BIKE = new HashSet<String>(Arrays.asList("footway", "pedestrian", "platform"));
    private final BooleanEncodedValue getOffBikeEnc;
    private final BooleanEncodedValue bikeAccessEnc;

    public OSMGetOffBikeParser(BooleanEncodedValue getOffBikeEnc, BooleanEncodedValue bikeAccessEnc) {
        this.getOffBikeEnc = getOffBikeEnc;
        this.bikeAccessEnc = bikeAccessEnc;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        boolean bwd;
        boolean fwd;
        boolean notIntended;
        String highway = way.getTag("highway");
        String vehicle = way.getTag("vehicle", "");
        boolean bl = notIntended = !way.hasTag("bicycle", this.INTENDED) && (this.GET_OFF_BIKE.contains(highway) || way.hasTag("railway", (Object)"platform") || !"cycleway".equals(highway) && way.hasTag("vehicle", (Object)"no") || vehicle.contains("forestry") || vehicle.contains("agricultural") || "path".equals(highway) && way.hasTag("foot", (Object)"designated") && !way.hasTag("segregated", (Object)"yes"));
        if ("steps".equals(highway) || way.hasTag("bicycle", (Object)"dismount") || notIntended) {
            this.getOffBikeEnc.setBool(false, edgeId, edgeIntAccess, true);
            this.getOffBikeEnc.setBool(true, edgeId, edgeIntAccess, true);
        }
        if ((fwd = this.bikeAccessEnc.getBool(false, edgeId, edgeIntAccess)) != (bwd = this.bikeAccessEnc.getBool(true, edgeId, edgeIntAccess))) {
            if (!fwd) {
                this.getOffBikeEnc.setBool(false, edgeId, edgeIntAccess, true);
            }
            if (!bwd) {
                this.getOffBikeEnc.setBool(true, edgeId, edgeIntAccess, true);
            }
        }
    }
}

