/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OSMRoadAccessParser
implements TagParser {
    protected final EnumEncodedValue<RoadAccess> roadAccessEnc;
    private final List<String> restrictions;

    public OSMRoadAccessParser(EnumEncodedValue<RoadAccess> roadAccessEnc, List<String> restrictions) {
        this.roadAccessEnc = roadAccessEnc;
        this.restrictions = restrictions;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay readerWay, IntsRef relationFlags) {
        RoadAccess accessValue = RoadAccess.YES;
        List nodeTags = readerWay.getTag("node_tags", Collections.emptyList());
        if (readerWay.hasTag("gh:barrier_edge", new String[0])) {
            for (String restriction : this.restrictions) {
                Object value = ((Map)nodeTags.get(0)).get(restriction);
                if (value == null) continue;
                accessValue = this.getRoadAccess((String)value, accessValue);
            }
        }
        for (String restriction : this.restrictions) {
            accessValue = this.getRoadAccess(readerWay.getTag(restriction), accessValue);
        }
        CountryRule countryRule = readerWay.getTag("country_rule", null);
        if (countryRule != null) {
            accessValue = countryRule.getAccess(readerWay, TransportationMode.CAR, accessValue);
        }
        this.roadAccessEnc.setEnum(false, edgeId, edgeIntAccess, accessValue);
    }

    private RoadAccess getRoadAccess(String tagValue, RoadAccess accessValue) {
        if (tagValue != null) {
            String[] complex;
            for (String simple : complex = tagValue.split(";")) {
                RoadAccess tmpAccessValue;
                RoadAccess roadAccess = tmpAccessValue = simple.equals("permit") ? RoadAccess.PRIVATE : RoadAccess.find(simple);
                if (tmpAccessValue == null || tmpAccessValue.ordinal() <= accessValue.ordinal()) continue;
                accessValue = tmpAccessValue;
            }
        }
        return accessValue;
    }

    public static List<String> toOSMRestrictions(TransportationMode mode) {
        switch (mode) {
            case FOOT: {
                return Arrays.asList("foot", "access");
            }
            case VEHICLE: {
                return Arrays.asList("vehicle", "access");
            }
            case BIKE: {
                return Arrays.asList("bicycle", "access");
            }
            case CAR: {
                return Arrays.asList("motorcar", "motor_vehicle", "vehicle", "access");
            }
            case MOTORCYCLE: {
                return Arrays.asList("motorcycle", "motor_vehicle", "vehicle", "access");
            }
            case HGV: {
                return Arrays.asList("hgv", "motor_vehicle", "vehicle", "access");
            }
            case PSV: {
                return Arrays.asList("psv", "motor_vehicle", "vehicle", "access");
            }
            case BUS: {
                return Arrays.asList("bus", "psv", "motor_vehicle", "vehicle", "access");
            }
            case HOV: {
                return Arrays.asList("hov", "motor_vehicle", "vehicle", "access");
            }
        }
        throw new IllegalArgumentException("Cannot convert TransportationMode " + mode + " to list of restrictions");
    }
}

