/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.ConditionalValueParser;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OSMTemporalAccessParser
implements TagParser {
    private final Collection<String> conditionals;
    private final Setter restrictionSetter;
    private final DateRangeParser parser;
    private static final DateRangeParser GENERIC_PARSER = DateRangeParser.createInstance("1970-01-01");
    private static final Set<String> GENERIC_ACCEPTED_VALUES = Set.of("yes", "no");

    public OSMTemporalAccessParser(Collection<String> conditionals, Setter restrictionSetter, String dateRangeParserDate) {
        this.conditionals = conditionals;
        this.restrictionSetter = restrictionSetter;
        if (dateRangeParserDate.isEmpty()) {
            dateRangeParserDate = Helper.createFormatter((String)"yyyy-MM-dd").format(new Date().getTime());
        }
        this.parser = DateRangeParser.createInstance(dateRangeParserDate);
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        Boolean b = this.getConditional(way.getTags());
        if (b != null) {
            this.restrictionSetter.setBoolean(edgeId, edgeIntAccess, b);
        }
    }

    Boolean getConditional(Map<String, Object> tags) {
        for (Map.Entry<String, Object> entry : tags.entrySet()) {
            Boolean inRange;
            String value;
            String[] strs;
            if (!this.conditionals.contains(entry.getKey()) || (strs = (value = (String)entry.getValue()).split("@")).length != 2 || (inRange = OSMTemporalAccessParser.isInRange(this.parser, strs[1].trim())) == null) continue;
            if (strs[0].trim().equals("no")) {
                return inRange == false;
            }
            if (!strs[0].trim().equals("yes")) continue;
            return inRange;
        }
        return null;
    }

    private static Boolean isInRange(DateRangeParser parser, String value) {
        if (value.isEmpty()) {
            return null;
        }
        if (value.contains(";")) {
            return null;
        }
        String conditionalValue = value.replace('(', ' ').replace(')', ' ').trim();
        try {
            ConditionalValueParser.ConditionState res = parser.checkCondition(conditionalValue);
            if (res.isValid()) {
                return res.isCheckPassed();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasTemporalRestriction(ReaderWay way, int firstIndex, List<String> restrictions) {
        for (int i = firstIndex; i >= 0; --i) {
            String value = way.getTag(restrictions.get(i) + ":conditional");
            if (!OSMTemporalAccessParser.hasTemporalRestriction(value)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTemporalRestriction(String value) {
        Boolean inRange;
        if (value == null) {
            return false;
        }
        String[] strs = value.split("@");
        return strs.length == 2 && (inRange = OSMTemporalAccessParser.isInRange(GENERIC_PARSER, strs[1].trim())) != null && GENERIC_ACCEPTED_VALUES.contains(strs[0].trim());
    }

    @FunctionalInterface
    public static interface Setter {
        public void setBoolean(int var1, EdgeIntAccess var2, boolean var3);
    }
}

