/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.PointList;

public class OrientationCalculator
implements TagParser {
    private final DecimalEncodedValue orientationEnc;

    public OrientationCalculator(DecimalEncodedValue orientationEnc) {
        this.orientationEnc = orientationEnc;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        PointList pointList = way.getTag("point_list", null);
        if (pointList != null) {
            double azimuth = AngleCalc.ANGLE_CALC.calcAzimuth(pointList.getLat(pointList.size() - 2), pointList.getLon(pointList.size() - 2), pointList.getLat(pointList.size() - 1), pointList.getLon(pointList.size() - 1));
            this.orientationEnc.setDecimal(false, edgeId, edgeIntAccess, azimuth);
            double revAzimuth = AngleCalc.ANGLE_CALC.calcAzimuth(pointList.getLat(1), pointList.getLon(1), pointList.getLat(0), pointList.getLon(0));
            this.orientationEnc.setDecimal(true, edgeId, edgeIntAccess, revAzimuth);
        }
    }
}

