/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntObjectScatterMap;
import com.carrotsearch.hppc.IntScatterSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.LongIntScatterMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.reader.osm.Pair;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.ArrayUtil;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class RestrictionSetter {
    private static final IntSet EMPTY_SET = IntHashSet.from((int[])new int[0]);
    private final BaseGraph baseGraph;
    private final List<BooleanEncodedValue> turnRestrictionEncs;

    public RestrictionSetter(BaseGraph baseGraph, List<BooleanEncodedValue> turnRestrictionEncs) {
        this.baseGraph = baseGraph;
        this.turnRestrictionEncs = turnRestrictionEncs;
    }

    public static Restriction createViaNodeRestriction(int fromEdge, int viaNode, int toEdge) {
        return new Restriction(IntArrayList.from((int[])new int[]{fromEdge, toEdge}), viaNode);
    }

    public static Restriction createViaEdgeRestriction(IntArrayList edges) {
        if (edges.size() < 3) {
            throw new IllegalArgumentException("Via-edge restrictions must have at least three edges, but got: " + edges.size());
        }
        return new Restriction(edges, -1);
    }

    public void setRestrictions(List<Restriction> restrictions, List<BitSet> encBits) {
        InternalRestriction restriction;
        int i;
        if (restrictions.size() != encBits.size()) {
            throw new IllegalArgumentException("There must be as many encBits as restrictions. Got: " + encBits.size() + " and " + restrictions.size());
        }
        List<InternalRestriction> internalRestrictions = restrictions.stream().map(this::convertToInternal).toList();
        this.disableRedundantRestrictions(internalRestrictions, encBits);
        LongIntScatterMap artificialEdgeKeysByIncViaPairs = new LongIntScatterMap();
        IntObjectScatterMap artificialEdgesByEdge = new IntObjectScatterMap();
        for (i = 0; i < internalRestrictions.size(); ++i) {
            if (encBits.get(i).cardinality() < 1L || (restriction = internalRestrictions.get(i)).getEdgeKeys().size() < 3) continue;
            int incomingEdge = restriction.getFromEdge();
            for (int j = 1; j < restriction.getEdgeKeys().size() - 1; ++j) {
                int artificialEdgeKey;
                int viaEdgeKey = restriction.getEdgeKeys().get(j);
                long key = BitUtil.LITTLE.toLong(incomingEdge, viaEdgeKey);
                if (artificialEdgeKeysByIncViaPairs.containsKey(key)) {
                    artificialEdgeKey = artificialEdgeKeysByIncViaPairs.get(key);
                } else {
                    int viaEdge = GHUtility.getEdgeFromEdgeKey(viaEdgeKey);
                    EdgeIteratorState artificialEdgeState = this.baseGraph.copyEdge(viaEdge, true);
                    int artificialEdge = artificialEdgeState.getEdge();
                    if (artificialEdgesByEdge.containsKey(viaEdge)) {
                        artificialEdges = (IntSet)artificialEdgesByEdge.get(viaEdge);
                        artificialEdges.forEach(a -> {
                            for (BooleanEncodedValue turnRestrictionEnc : this.turnRestrictionEncs) {
                                this.restrictTurnsBetweenEdges(turnRestrictionEnc, artificialEdgeState, a);
                            }
                        });
                        artificialEdges.add(artificialEdge);
                    } else {
                        artificialEdges = new IntScatterSet();
                        artificialEdges.add(artificialEdge);
                        artificialEdgesByEdge.put(viaEdge, (Object)artificialEdges);
                    }
                    for (BooleanEncodedValue turnRestrictionEnc : this.turnRestrictionEncs) {
                        this.restrictTurnsBetweenEdges(turnRestrictionEnc, artificialEdgeState, viaEdge);
                    }
                    artificialEdgeKey = artificialEdgeState.getEdgeKey();
                    if (this.baseGraph.getEdgeIteratorStateForKey(viaEdgeKey).get(EdgeIteratorState.REVERSE_STATE)) {
                        artificialEdgeKey = GHUtility.reverseEdgeKey(artificialEdgeKey);
                    }
                    artificialEdgeKeysByIncViaPairs.put(key, artificialEdgeKey);
                }
                restriction.actualEdgeKeys.set(j, artificialEdgeKey);
                incomingEdge = GHUtility.getEdgeFromEdgeKey(artificialEdgeKey);
            }
        }
        artificialEdgeKeysByIncViaPairs.forEach((arg_0, arg_1) -> this.lambda$setRestrictions$2((IntObjectMap)artificialEdgesByEdge, arg_0, arg_1));
        for (i = 0; i < internalRestrictions.size(); ++i) {
            if (encBits.get(i).cardinality() < 1L) continue;
            restriction = internalRestrictions.get(i);
            if (restriction.getEdgeKeys().size() < 3) {
                IntSet fromEdges = (IntSet)artificialEdgesByEdge.getOrDefault(restriction.getFromEdge(), (Object)new IntScatterSet());
                fromEdges.add(restriction.getFromEdge());
                IntSet toEdges = (IntSet)artificialEdgesByEdge.getOrDefault(restriction.getToEdge(), (Object)new IntScatterSet());
                toEdges.add(restriction.getToEdge());
                for (int j = 0; j < this.turnRestrictionEncs.size(); ++j) {
                    BooleanEncodedValue turnRestrictionEnc = this.turnRestrictionEncs.get(j);
                    if (!encBits.get(i).get(j)) continue;
                    fromEdges.forEach(from -> toEdges.forEach(to -> this.restrictTurn(turnRestrictionEnc, from, restriction.getViaNodes().get(0), to)));
                }
                continue;
            }
            int viaEdgeKey = restriction.getActualEdgeKeys().get(restriction.getActualEdgeKeys().size() - 2);
            int viaEdge = GHUtility.getEdgeFromEdgeKey(viaEdgeKey);
            int node = this.baseGraph.getEdgeIteratorStateForKey(viaEdgeKey).getAdjNode();
            for (int j = 0; j < this.turnRestrictionEncs.size(); ++j) {
                BooleanEncodedValue turnRestrictionEnc = this.turnRestrictionEncs.get(j);
                if (!encBits.get(i).get(j)) continue;
                this.restrictTurn(turnRestrictionEnc, viaEdge, node, restriction.getToEdge());
                ((IntSet)artificialEdgesByEdge.getOrDefault(restriction.getToEdge(), (Object)EMPTY_SET)).forEach(toEdge -> this.restrictTurn(turnRestrictionEnc, viaEdge, node, toEdge));
            }
        }
    }

    private void disableRedundantRestrictions(List<InternalRestriction> restrictions, List<BitSet> encBits) {
        for (int encIdx = 0; encIdx < this.turnRestrictionEncs.size(); ++encIdx) {
            int i;
            HashSet<InternalRestriction> uniqueRestrictions = new HashSet<InternalRestriction>();
            for (int i2 = 0; i2 < restrictions.size(); ++i2) {
                if (!encBits.get(i2).get(encIdx) || uniqueRestrictions.add(restrictions.get(i2))) continue;
                encBits.get(i2).clear((long)encIdx);
            }
            IntObjectScatterMap restrictionsByEdgeKeys = new IntObjectScatterMap();
            for (i = 0; i < restrictions.size(); ++i) {
                if (!encBits.get(i).get(encIdx)) continue;
                InternalRestriction restriction = restrictions.get(i);
                for (IntCursor edgeKey : restriction.edgeKeys) {
                    int idx = restrictionsByEdgeKeys.indexOf(edgeKey.value);
                    if (idx < 0) {
                        ArrayList<InternalRestriction> list = new ArrayList<InternalRestriction>();
                        list.add(restriction);
                        restrictionsByEdgeKeys.indexInsert(idx, edgeKey.value, list);
                        continue;
                    }
                    ((List)restrictionsByEdgeKeys.indexGet(idx)).add(restriction);
                }
            }
            for (i = 0; i < restrictions.size(); ++i) {
                if (!encBits.get(i).get(encIdx) || !this.containsAnotherRestriction(restrictions.get(i), (IntObjectMap<List<InternalRestriction>>)restrictionsByEdgeKeys)) continue;
                encBits.get(i).clear((long)encIdx);
            }
        }
    }

    private boolean containsAnotherRestriction(InternalRestriction restriction, IntObjectMap<List<InternalRestriction>> restrictionsByEdgeKeys) {
        for (IntCursor edgeKey : restriction.edgeKeys) {
            List restrictionsWithThisEdgeKey = (List)restrictionsByEdgeKeys.get(edgeKey.value);
            for (InternalRestriction r : restrictionsWithThisEdgeKey) {
                if (r == restriction) continue;
                if (r.equals(restriction)) {
                    throw new IllegalStateException("Equal restrictions should have already been filtered out here!");
                }
                if (!RestrictionSetter.isSubsetOf(r.edgeKeys, restriction.edgeKeys)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSubsetOf(IntArrayList candidate, IntArrayList array) {
        if (candidate.size() > array.size()) {
            return false;
        }
        for (int i = 0; i <= array.size() - candidate.size(); ++i) {
            boolean isSubset = true;
            for (int j = 0; j < candidate.size(); ++j) {
                if (candidate.get(j) == array.get(i + j)) continue;
                isSubset = false;
                break;
            }
            if (!isSubset) continue;
            return true;
        }
        return false;
    }

    private void restrictTurnsBetweenEdges(BooleanEncodedValue turnRestrictionEnc, EdgeIteratorState edgeState, int otherEdge) {
        this.restrictTurn(turnRestrictionEnc, otherEdge, edgeState.getBaseNode(), edgeState.getEdge());
        this.restrictTurn(turnRestrictionEnc, edgeState.getEdge(), edgeState.getBaseNode(), otherEdge);
        this.restrictTurn(turnRestrictionEnc, otherEdge, edgeState.getAdjNode(), edgeState.getEdge());
        this.restrictTurn(turnRestrictionEnc, edgeState.getEdge(), edgeState.getAdjNode(), otherEdge);
    }

    private InternalRestriction convertToInternal(Restriction restriction) {
        IntArrayList edges = restriction.edges;
        if (edges.size() < 2) {
            throw new IllegalArgumentException("Invalid restriction, there must be at least two edges");
        }
        if (edges.size() == 2) {
            int fromKey = this.baseGraph.getEdgeIteratorState(edges.get(0), restriction.viaNode).getEdgeKey();
            int toKey = this.baseGraph.getEdgeIteratorState(edges.get(1), restriction.viaNode).getReverseEdgeKey();
            return new InternalRestriction(IntArrayList.from((int[])new int[]{restriction.viaNode}), IntArrayList.from((int[])new int[]{fromKey, toKey}));
        }
        Pair<IntArrayList, IntArrayList> p = this.findNodesAndEdgeKeys(this.baseGraph, edges);
        ((IntArrayList)p.first).remove(((IntArrayList)p.first).size() - 1);
        return new InternalRestriction((IntArrayList)p.first, (IntArrayList)p.second);
    }

    private Pair<IntArrayList, IntArrayList> findNodesAndEdgeKeys(BaseGraph baseGraph, IntArrayList edges) {
        ArrayList<Pair<IntArrayList, IntArrayList>> solutions = new ArrayList<Pair<IntArrayList, IntArrayList>>();
        this.findEdgeChain(baseGraph, edges, 0, IntArrayList.from((int[])new int[0]), IntArrayList.from((int[])new int[0]), solutions);
        if (solutions.isEmpty()) {
            throw new IllegalArgumentException("Disconnected edges: " + edges + " " + RestrictionSetter.edgesToLocationString(baseGraph, edges));
        }
        if (solutions.size() > 1) {
            throw new IllegalArgumentException("Ambiguous edge restriction: " + edges + " " + RestrictionSetter.edgesToLocationString(baseGraph, edges));
        }
        return (Pair)solutions.get(0);
    }

    private static String edgesToLocationString(BaseGraph baseGraph, IntArrayList edges) {
        return Arrays.stream(edges.buffer, 0, edges.size()).mapToObj(e -> baseGraph.getEdgeIteratorState(e, Integer.MIN_VALUE).fetchWayGeometry(FetchMode.ALL)).toList().toString();
    }

    private void findEdgeChain(BaseGraph baseGraph, IntArrayList edges, int index, IntArrayList nodes, IntArrayList edgeKeys, List<Pair<IntArrayList, IntArrayList>> solutions) {
        if (index == edges.size()) {
            solutions.add(new Pair<IntArrayList, IntArrayList>(new IntArrayList((IntContainer)nodes), new IntArrayList((IntContainer)edgeKeys)));
            return;
        }
        EdgeIteratorState edgeState = baseGraph.getEdgeIteratorState(edges.get(index), Integer.MIN_VALUE);
        if (index == 0 || edgeState.getBaseNode() == nodes.get(nodes.size() - 1)) {
            nodes.add(edgeState.getAdjNode());
            edgeKeys.add(edgeState.getEdgeKey());
            this.findEdgeChain(baseGraph, edges, index + 1, nodes, edgeKeys, solutions);
            --nodes.elementsCount;
            --edgeKeys.elementsCount;
        }
        if (index == 0 || edgeState.getAdjNode() == nodes.get(nodes.size() - 1)) {
            nodes.add(edgeState.getBaseNode());
            edgeKeys.add(edgeState.getReverseEdgeKey());
            this.findEdgeChain(baseGraph, edges, index + 1, nodes, edgeKeys, solutions);
            --nodes.elementsCount;
            --edgeKeys.elementsCount;
        }
    }

    private void restrictTurn(BooleanEncodedValue turnRestrictionEnc, int fromEdge, int viaNode, int toEdge) {
        if (fromEdge < 0 || toEdge < 0 || viaNode < 0) {
            throw new IllegalArgumentException("from/toEdge and viaNode must be >= 0");
        }
        this.baseGraph.getTurnCostStorage().set(turnRestrictionEnc, fromEdge, viaNode, toEdge, true);
    }

    public static BitSet copyEncBits(BitSet encBits) {
        return new BitSet(Arrays.copyOf(encBits.bits, encBits.bits.length), encBits.wlen);
    }

    private /* synthetic */ void lambda$setRestrictions$2(IntObjectMap artificialEdgesByEdge, long incViaPair, int artificialEdgeKey) {
        int incomingEdge = BitUtil.LITTLE.getIntLow(incViaPair);
        int viaEdgeKey = BitUtil.LITTLE.getIntHigh(incViaPair);
        int viaEdge = GHUtility.getEdgeFromEdgeKey(viaEdgeKey);
        int node = this.baseGraph.getEdgeIteratorStateForKey(viaEdgeKey).getBaseNode();
        for (BooleanEncodedValue turnRestrictionEnc : this.turnRestrictionEncs) {
            this.restrictTurn(turnRestrictionEnc, incomingEdge, node, viaEdge);
        }
        IntSet artificialEdges = (IntSet)artificialEdgesByEdge.get(viaEdge);
        artificialEdges.forEach(a -> {
            if (a != GHUtility.getEdgeFromEdgeKey(artificialEdgeKey)) {
                for (BooleanEncodedValue turnRestrictionEnc : this.turnRestrictionEncs) {
                    this.restrictTurn(turnRestrictionEnc, incomingEdge, node, a);
                }
            }
        });
    }

    public static class Restriction {
        public final IntArrayList edges;
        private final int viaNode;

        private Restriction(IntArrayList edges, int viaNode) {
            this.edges = edges;
            this.viaNode = viaNode;
        }

        public String toString() {
            return "edges: " + this.edges.toString() + ", viaNode: " + this.viaNode;
        }
    }

    private static class InternalRestriction {
        private final IntArrayList viaNodes;
        private final IntArrayList edgeKeys;
        private final IntArrayList actualEdgeKeys;

        public InternalRestriction(IntArrayList viaNodes, IntArrayList edgeKeys) {
            this.edgeKeys = edgeKeys;
            this.viaNodes = viaNodes;
            this.actualEdgeKeys = ArrayUtil.constant(edgeKeys.size(), -1);
            this.actualEdgeKeys.set(0, edgeKeys.get(0));
            this.actualEdgeKeys.set(edgeKeys.size() - 1, edgeKeys.get(edgeKeys.size() - 1));
        }

        public IntArrayList getViaNodes() {
            return this.viaNodes;
        }

        public int getFromEdge() {
            return GHUtility.getEdgeFromEdgeKey(this.edgeKeys.get(0));
        }

        public IntArrayList getEdgeKeys() {
            return this.edgeKeys;
        }

        public IntArrayList getActualEdgeKeys() {
            return this.actualEdgeKeys;
        }

        public int getToEdge() {
            return GHUtility.getEdgeFromEdgeKey(this.edgeKeys.get(this.edgeKeys.size() - 1));
        }

        public int hashCode() {
            return 31 * this.viaNodes.hashCode() + this.edgeKeys.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof InternalRestriction)) {
                return false;
            }
            return ((InternalRestriction)obj).viaNodes.equals((Object)this.viaNodes) && ((InternalRestriction)obj).edgeKeys.equals((Object)this.edgeKeys);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.viaNodes.size(); ++i) {
                result.append(GHUtility.getEdgeFromEdgeKey(this.edgeKeys.get(i))).append("-(").append(this.viaNodes.get(i)).append(")-");
            }
            return "" + result + GHUtility.getEdgeFromEdgeKey(this.edgeKeys.get(this.edgeKeys.size() - 1));
        }
    }
}

