/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.TurnCostsConfig;

public class DefaultTurnCostProvider
implements TurnCostProvider {
    private final BooleanEncodedValue turnRestrictionEnc;
    private final TurnCostStorage turnCostStorage;
    private final int uTurnCostsInt;
    private final double uTurnCosts;
    private final double minTurnAngle;
    private final double minSharpTurnAngle;
    private final double minUTurnAngle;
    private final double leftTurnCosts;
    private final double sharpLeftTurnCosts;
    private final double straightCosts;
    private final double rightTurnCosts;
    private final double sharpRightTurnCosts;
    private final BaseGraph graph;
    private final EdgeIntAccess edgeIntAccess;
    private final DecimalEncodedValue orientationEnc;

    public DefaultTurnCostProvider(BooleanEncodedValue turnRestrictionEnc, DecimalEncodedValue orientationEnc, Graph graph, TurnCostsConfig tcConfig) {
        this.uTurnCostsInt = tcConfig.getUTurnCosts();
        if (this.uTurnCostsInt < 0 && this.uTurnCostsInt != -1) {
            throw new IllegalArgumentException("u-turn costs must be positive, or equal to -1 (=infinite costs)");
        }
        double d = this.uTurnCosts = this.uTurnCostsInt < 0 ? Double.POSITIVE_INFINITY : (double)this.uTurnCostsInt;
        if (graph.getTurnCostStorage() == null) {
            throw new IllegalArgumentException("No storage set to calculate turn weight");
        }
        this.turnRestrictionEnc = turnRestrictionEnc;
        this.turnCostStorage = graph.getTurnCostStorage();
        this.orientationEnc = orientationEnc;
        if (tcConfig.getMinUTurnAngle() > 180.0) {
            throw new IllegalArgumentException("Illegal min_u_turn_angle = " + tcConfig.getMinUTurnAngle());
        }
        if (tcConfig.getMinSharpTurnAngle() > tcConfig.getMinUTurnAngle()) {
            throw new IllegalArgumentException("Illegal min_sharp_turn_angle = " + tcConfig.getMinSharpTurnAngle());
        }
        if (tcConfig.getMinTurnAngle() > tcConfig.getMinSharpTurnAngle() || tcConfig.getMinTurnAngle() < 0.0) {
            throw new IllegalArgumentException("Illegal min_turn_angle = " + tcConfig.getMinTurnAngle());
        }
        if (tcConfig.getLeftTurnCosts() > tcConfig.getSharpLeftTurnCosts()) {
            throw new IllegalArgumentException("The costs for 'left_turn_costs' (" + tcConfig.getLeftTurnCosts() + ") must be lower than for 'sharp_left_turn_costs' (" + tcConfig.getSharpLeftTurnCosts() + ")");
        }
        if (tcConfig.getRightTurnCosts() > tcConfig.getSharpRightTurnCosts()) {
            throw new IllegalArgumentException("The costs for 'right_turn_costs' (" + tcConfig.getRightTurnCosts() + ") must be lower than for 'sharp_right_turn_costs' (" + tcConfig.getSharpRightTurnCosts() + ")");
        }
        this.minTurnAngle = tcConfig.getMinTurnAngle();
        this.minSharpTurnAngle = tcConfig.getMinSharpTurnAngle();
        this.minUTurnAngle = tcConfig.getMinUTurnAngle();
        this.leftTurnCosts = tcConfig.getLeftTurnCosts();
        this.sharpLeftTurnCosts = tcConfig.getSharpLeftTurnCosts();
        this.straightCosts = tcConfig.getStraightCosts();
        this.rightTurnCosts = tcConfig.getRightTurnCosts();
        this.sharpRightTurnCosts = tcConfig.getSharpRightTurnCosts();
        this.graph = graph.getBaseGraph();
        this.edgeIntAccess = graph.getBaseGraph().getEdgeAccess();
    }

    @Override
    public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
            return 0.0;
        }
        if (inEdge == outEdge) {
            return this.uTurnCosts;
        }
        if (this.turnRestrictionEnc != null && this.turnCostStorage.get(this.turnRestrictionEnc, inEdge, viaNode, outEdge)) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.orientationEnc != null) {
            double changeAngle = this.calcChangeAngle(inEdge, viaNode, outEdge);
            if (changeAngle > -this.minTurnAngle && changeAngle < this.minTurnAngle) {
                return this.straightCosts;
            }
            if (changeAngle >= this.minTurnAngle && changeAngle < this.minSharpTurnAngle) {
                return this.rightTurnCosts;
            }
            if (changeAngle >= this.minSharpTurnAngle && changeAngle <= this.minUTurnAngle) {
                return this.sharpRightTurnCosts;
            }
            if (changeAngle <= -this.minTurnAngle && changeAngle > -this.minSharpTurnAngle) {
                return this.leftTurnCosts;
            }
            if (changeAngle <= -this.minSharpTurnAngle && changeAngle >= -this.minUTurnAngle) {
                return this.sharpLeftTurnCosts;
            }
            return this.uTurnCosts;
        }
        return 0.0;
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        return 0L;
    }

    public String toString() {
        return "default_tcp_" + this.uTurnCostsInt;
    }

    double calcChangeAngle(int inEdge, int viaNode, int outEdge) {
        boolean inEdgeReverse = !this.graph.isAdjNode(inEdge, viaNode);
        double prevAzimuth = this.orientationEnc.getDecimal(inEdgeReverse, inEdge, this.edgeIntAccess);
        boolean outEdgeReverse = !this.graph.isAdjNode(outEdge, viaNode);
        double azimuth = this.orientationEnc.getDecimal(outEdgeReverse, outEdge, this.edgeIntAccess);
        azimuth = azimuth >= 180.0 ? (azimuth -= 180.0) : (azimuth += 180.0);
        double changeAngle = azimuth - prevAzimuth;
        if (changeAngle > 180.0) {
            changeAngle -= 360.0;
        } else if (changeAngle < -180.0) {
            changeAngle += 360.0;
        }
        return changeAngle;
    }
}

