/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;

public class QueryGraphWeighting
implements Weighting {
    private final BaseGraph graph;
    private final Weighting weighting;
    private final int firstVirtualNodeId;
    private final int firstVirtualEdgeId;
    private final IntArrayList closestEdges;

    public QueryGraphWeighting(BaseGraph graph, Weighting weighting, IntArrayList closestEdges) {
        this.graph = graph;
        this.weighting = weighting;
        this.firstVirtualNodeId = graph.getNodes();
        this.firstVirtualEdgeId = graph.getEdges();
        this.closestEdges = closestEdges;
    }

    @Override
    public double calcMinWeightPerDistance() {
        return this.weighting.calcMinWeightPerDistance();
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        return this.weighting.calcEdgeWeight(edgeState, reverse);
    }

    @Override
    public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
            return 0.0;
        }
        if (this.isVirtualNode(viaNode)) {
            if (this.isUTurn(inEdge, outEdge)) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        return this.getMinWeightAndOriginalEdges((int)inEdge, (int)viaNode, (int)outEdge).minTurnWeight;
    }

    private Result getMinWeightAndOriginalEdges(int inEdge, int viaNode, int outEdge) {
        Result result = new Result();
        if (this.isVirtualEdge(inEdge) && this.isVirtualEdge(outEdge)) {
            EdgeExplorer innerExplorer = this.graph.createEdgeExplorer();
            this.graph.forEdgeAndCopiesOfEdge(this.graph.createEdgeExplorer(), viaNode, this.getOriginalEdge(inEdge), p -> this.graph.forEdgeAndCopiesOfEdge(innerExplorer, viaNode, this.getOriginalEdge(outEdge), q -> {
                double w = this.weighting.calcTurnWeight(p, viaNode, q);
                if (w < result.minTurnWeight) {
                    result.origInEdge = p;
                    result.origOutEdge = q;
                    result.minTurnWeight = w;
                }
            }));
        } else if (this.isVirtualEdge(inEdge)) {
            this.graph.forEdgeAndCopiesOfEdge(this.graph.createEdgeExplorer(), viaNode, this.getOriginalEdge(inEdge), e -> {
                double w = this.weighting.calcTurnWeight(e, viaNode, outEdge);
                if (w < result.minTurnWeight) {
                    result.origInEdge = e;
                    result.origOutEdge = outEdge;
                    result.minTurnWeight = w;
                }
            });
        } else if (this.isVirtualEdge(outEdge)) {
            this.graph.forEdgeAndCopiesOfEdge(this.graph.createEdgeExplorer(), viaNode, this.getOriginalEdge(outEdge), e -> {
                double w = this.weighting.calcTurnWeight(inEdge, viaNode, e);
                if (w < result.minTurnWeight) {
                    result.origInEdge = inEdge;
                    result.origOutEdge = e;
                    result.minTurnWeight = w;
                }
            });
        } else {
            result.origInEdge = inEdge;
            result.origOutEdge = outEdge;
            result.minTurnWeight = this.weighting.calcTurnWeight(inEdge, viaNode, outEdge);
        }
        return result;
    }

    private boolean isUTurn(int inEdge, int outEdge) {
        return inEdge == outEdge;
    }

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        return this.weighting.calcEdgeMillis(edgeState, reverse);
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        if (this.isVirtualNode(viaNode)) {
            return 0L;
        }
        Result result = this.getMinWeightAndOriginalEdges(inEdge, viaNode, outEdge);
        return this.weighting.calcTurnMillis(result.origInEdge, viaNode, result.origOutEdge);
    }

    @Override
    public boolean hasTurnCosts() {
        return this.weighting.hasTurnCosts();
    }

    @Override
    public String getName() {
        return this.weighting.getName();
    }

    public String toString() {
        return this.getName();
    }

    private int getOriginalEdge(int edge) {
        return this.closestEdges.get((edge - this.firstVirtualEdgeId) / 2);
    }

    private boolean isVirtualNode(int node) {
        return node >= this.firstVirtualNodeId;
    }

    private boolean isVirtualEdge(int edge) {
        return edge >= this.firstVirtualEdgeId;
    }

    private static class Result {
        int origInEdge = -1;
        int origOutEdge = -1;
        double minTurnWeight = Double.POSITIVE_INFINITY;

        private Result() {
        }
    }
}

