/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;

public class SpeedWeighting
implements Weighting {
    private final DecimalEncodedValue speedEnc;
    private final TurnCostProvider turnCostProvider;

    public SpeedWeighting(DecimalEncodedValue speedEnc) {
        this(speedEnc, TurnCostProvider.NO_TURN_COST_PROVIDER);
    }

    public SpeedWeighting(DecimalEncodedValue speedEnc, final DecimalEncodedValue turnCostEnc, final TurnCostStorage turnCostStorage, final double uTurnCosts) {
        if (turnCostStorage == null || turnCostEnc == null) {
            throw new IllegalArgumentException("This SpeedWeighting constructor expects turnCostEnc and turnCostStorage to be != null");
        }
        if (uTurnCosts < 0.0) {
            throw new IllegalArgumentException("u-turn costs must be positive");
        }
        this.speedEnc = speedEnc;
        this.turnCostProvider = new TurnCostProvider(){

            @Override
            public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
                if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
                    return 0.0;
                }
                if (inEdge == outEdge) {
                    return Math.max(turnCostStorage.get(turnCostEnc, inEdge, viaNode, outEdge), uTurnCosts);
                }
                return turnCostStorage.get(turnCostEnc, inEdge, viaNode, outEdge);
            }

            @Override
            public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
                return (long)(1000.0 * this.calcTurnWeight(inEdge, viaNode, outEdge));
            }
        };
    }

    public SpeedWeighting(DecimalEncodedValue speedEnc, TurnCostProvider turnCostProvider) {
        this.speedEnc = speedEnc;
        this.turnCostProvider = turnCostProvider;
    }

    @Override
    public double calcMinWeightPerDistance() {
        return 1.0 / this.speedEnc.getMaxStorableDecimal();
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        double speed;
        double d = speed = reverse ? edgeState.getReverse(this.speedEnc) : edgeState.get(this.speedEnc);
        if (speed == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return edgeState.getDistance() / speed;
    }

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        return (long)(1000.0 * this.calcEdgeWeight(edgeState, reverse));
    }

    @Override
    public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        return this.turnCostProvider.calcTurnWeight(inEdge, viaNode, outEdge);
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        return this.turnCostProvider.calcTurnMillis(inEdge, viaNode, outEdge);
    }

    @Override
    public boolean hasTurnCosts() {
        return this.turnCostProvider != TurnCostProvider.NO_TURN_COST_PROVIDER;
    }

    @Override
    public String getName() {
        return "speed";
    }
}

