/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.util.EdgeIteratorState;

public final class CustomWeighting
implements Weighting {
    public static final String NAME = "custom";
    private static final double SPEED_CONV = 3.6;
    private final double distanceInfluence;
    private final double headingPenaltySeconds;
    private final EdgeToDoubleMapping edgeToSpeedMapping;
    private final EdgeToDoubleMapping edgeToPriorityMapping;
    private final TurnCostProvider turnCostProvider;
    private final MaxCalc maxPrioCalc;
    private final MaxCalc maxSpeedCalc;

    public CustomWeighting(TurnCostProvider turnCostProvider, Parameters parameters) {
        if (!Weighting.isValidName(this.getName())) {
            throw new IllegalStateException("Not a valid name for a Weighting: " + this.getName());
        }
        this.turnCostProvider = turnCostProvider;
        this.edgeToSpeedMapping = parameters.getEdgeToSpeedMapping();
        this.maxSpeedCalc = parameters.getMaxSpeedCalc();
        this.edgeToPriorityMapping = parameters.getEdgeToPriorityMapping();
        this.maxPrioCalc = parameters.getMaxPrioCalc();
        this.headingPenaltySeconds = parameters.getHeadingPenaltySeconds();
        this.distanceInfluence = parameters.getDistanceInfluence() / 1000.0;
        if (this.distanceInfluence < 0.0) {
            throw new IllegalArgumentException("distance_influence cannot be negative " + this.distanceInfluence);
        }
    }

    @Override
    public double calcMinWeightPerDistance() {
        return 1.0 / (this.maxSpeedCalc.calcMax() / 3.6) / this.maxPrioCalc.calcMax() + this.distanceInfluence;
    }

    @Override
    public double calcEdgeWeight(EdgeIteratorState edgeState, boolean reverse) {
        double distanceCosts;
        double priority = this.edgeToPriorityMapping.get(edgeState, reverse);
        if (priority == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double distance = edgeState.getDistance();
        double seconds = this.calcSeconds(distance, edgeState, reverse);
        if (Double.isInfinite(seconds)) {
            return Double.POSITIVE_INFINITY;
        }
        if (edgeState.get(EdgeIteratorState.UNFAVORED_EDGE)) {
            seconds += this.headingPenaltySeconds;
        }
        if (Double.isInfinite(distanceCosts = distance * this.distanceInfluence)) {
            return Double.POSITIVE_INFINITY;
        }
        return seconds / priority + distanceCosts;
    }

    double calcSeconds(double distance, EdgeIteratorState edgeState, boolean reverse) {
        double speed = this.edgeToSpeedMapping.get(edgeState, reverse);
        if (speed == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (speed < 0.0) {
            throw new IllegalArgumentException("Speed cannot be negative");
        }
        return distance / speed * 3.6;
    }

    @Override
    public long calcEdgeMillis(EdgeIteratorState edgeState, boolean reverse) {
        return Math.round(this.calcSeconds(edgeState.getDistance(), edgeState, reverse) * 1000.0);
    }

    @Override
    public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        return this.turnCostProvider.calcTurnWeight(inEdge, viaNode, outEdge);
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        return this.turnCostProvider.calcTurnMillis(inEdge, viaNode, outEdge);
    }

    @Override
    public boolean hasTurnCosts() {
        return this.turnCostProvider != TurnCostProvider.NO_TURN_COST_PROVIDER;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static class Parameters {
        private final EdgeToDoubleMapping edgeToSpeedMapping;
        private final EdgeToDoubleMapping edgeToPriorityMapping;
        private final MaxCalc maxSpeedCalc;
        private final MaxCalc maxPrioCalc;
        private final double distanceInfluence;
        private final double headingPenaltySeconds;

        public Parameters(EdgeToDoubleMapping edgeToSpeedMapping, MaxCalc maxSpeedCalc, EdgeToDoubleMapping edgeToPriorityMapping, MaxCalc maxPrioCalc, double distanceInfluence, double headingPenaltySeconds) {
            this.edgeToSpeedMapping = edgeToSpeedMapping;
            this.maxSpeedCalc = maxSpeedCalc;
            this.edgeToPriorityMapping = edgeToPriorityMapping;
            this.maxPrioCalc = maxPrioCalc;
            this.distanceInfluence = distanceInfluence;
            this.headingPenaltySeconds = headingPenaltySeconds;
        }

        public EdgeToDoubleMapping getEdgeToSpeedMapping() {
            return this.edgeToSpeedMapping;
        }

        public EdgeToDoubleMapping getEdgeToPriorityMapping() {
            return this.edgeToPriorityMapping;
        }

        public MaxCalc getMaxSpeedCalc() {
            return this.maxSpeedCalc;
        }

        public MaxCalc getMaxPrioCalc() {
            return this.maxPrioCalc;
        }

        public double getDistanceInfluence() {
            return this.distanceInfluence;
        }

        public double getHeadingPenaltySeconds() {
            return this.headingPenaltySeconds;
        }
    }

    @FunctionalInterface
    public static interface EdgeToDoubleMapping {
        public double get(EdgeIteratorState var1, boolean var2);
    }

    @FunctionalInterface
    public static interface MaxCalc {
        public double calcMax();
    }
}

