/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.MinMax;
import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.weighting.custom.FindMinMax;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Polygon;
import java.util.List;
import java.util.Map;

public class CustomWeightingHelper {
    static double GLOBAL_MAX_SPEED = 999.0;
    static double GLOBAL_PRIORITY = 1.0;
    protected EncodedValueLookup lookup;
    protected CustomModel customModel;

    protected CustomWeightingHelper() {
    }

    public void init(CustomModel customModel, EncodedValueLookup lookup, Map<String, JsonFeature> areas) {
        this.lookup = lookup;
        this.customModel = customModel;
    }

    public double getPriority(EdgeIteratorState edge, boolean reverse) {
        return this.getRawPriority(edge, reverse);
    }

    public double getSpeed(EdgeIteratorState edge, boolean reverse) {
        return this.getRawSpeed(edge, reverse);
    }

    protected final double getRawSpeed(EdgeIteratorState edge, boolean reverse) {
        return 1.0;
    }

    protected final double getRawPriority(EdgeIteratorState edge, boolean reverse) {
        return 1.0;
    }

    public final double calcMaxSpeed() {
        MinMax minMaxSpeed = new MinMax(0.0, GLOBAL_MAX_SPEED);
        FindMinMax.findMinMax(minMaxSpeed, this.customModel.getSpeed(), this.lookup);
        if (minMaxSpeed.min < 0.0) {
            throw new IllegalArgumentException("speed has to be >=0 but can be negative (" + minMaxSpeed.min + ")");
        }
        if (minMaxSpeed.max <= 0.0) {
            throw new IllegalArgumentException("maximum speed has to be >0 but was " + minMaxSpeed.max);
        }
        if (minMaxSpeed.max == GLOBAL_MAX_SPEED) {
            throw new IllegalArgumentException("The first statement for 'speed' must be unconditionally to set the speed. But it was " + this.customModel.getSpeed().get(0));
        }
        return minMaxSpeed.max;
    }

    public final double calcMaxPriority() {
        String value;
        MinMax minMaxPriority = new MinMax(0.0, GLOBAL_PRIORITY);
        List statements = this.customModel.getPriority();
        if (!statements.isEmpty() && "true".equals(((Statement)statements.get(0)).condition()) && this.lookup.hasEncodedValue(value = ((Statement)statements.get(0)).value())) {
            minMaxPriority.max = this.lookup.getDecimalEncodedValue(value).getMaxOrMaxStorableDecimal();
        }
        FindMinMax.findMinMax(minMaxPriority, statements, this.lookup);
        if (minMaxPriority.min < 0.0) {
            throw new IllegalArgumentException("priority has to be >=0 but can be negative (" + minMaxPriority.min + ")");
        }
        if (minMaxPriority.max < 0.0) {
            throw new IllegalArgumentException("maximum priority has to be >=0 but was " + minMaxPriority.max);
        }
        return minMaxPriority.max;
    }

    public static boolean in(Polygon p, EdgeIteratorState edge) {
        BBox edgeBBox = GHUtility.createBBox(edge);
        BBox polyBBOX = p.getBounds();
        if (!polyBBOX.intersects(edgeBBox)) {
            return false;
        }
        if (p.isRectangle() && polyBBOX.contains(edgeBBox)) {
            return true;
        }
        return p.intersects(edge.fetchWayGeometry(FetchMode.ALL).makeImmutable());
    }
}

