/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.AbstractDataAccess;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.MMapDataAccess;
import com.graphhopper.storage.RAMDataAccess;
import com.graphhopper.storage.RAMIntDataAccess;
import com.graphhopper.util.Helper;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class GHDirectory
implements Directory {
    protected final String location;
    private final DAType typeFallback;
    private final Map<String, DAType> defaultTypes = new LinkedHashMap<String, DAType>();
    private final Map<String, Integer> mmapPreloads = new LinkedHashMap<String, Integer>();
    private final Map<String, DataAccess> map = Collections.synchronizedMap(new HashMap());

    public GHDirectory(String _location, DAType defaultType) {
        this.typeFallback = defaultType;
        if (Helper.isEmpty((String)_location)) {
            _location = new File("").getAbsolutePath();
        }
        if (!((String)_location).endsWith("/")) {
            _location = (String)_location + "/";
        }
        this.location = _location;
        File dir = new File(this.location);
        if (dir.exists() && !dir.isDirectory()) {
            throw new RuntimeException("file '" + dir + "' exists but is not a directory");
        }
    }

    public Directory configure(LinkedHashMap<String, String> config) {
        for (Map.Entry<String, String> kv : config.entrySet()) {
            String pattern;
            String value = kv.getValue().trim();
            if (kv.getKey().startsWith("preload.")) {
                try {
                    pattern = kv.getKey().substring("preload.".length());
                    this.mmapPreloads.put(pattern, Integer.parseInt(value));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("DataAccess " + kv.getKey() + " has an incorrect preload value: " + value);
                }
            }
            pattern = kv.getKey();
            this.defaultTypes.put(pattern, DAType.fromString(value));
        }
        return this;
    }

    int getPreload(String name) {
        for (Map.Entry<String, Integer> entry : this.mmapPreloads.entrySet()) {
            if (!name.matches(entry.getKey())) continue;
            return entry.getValue();
        }
        return 0;
    }

    public void loadMMap() {
        for (DataAccess da : this.map.values()) {
            int preload;
            if (!(da instanceof MMapDataAccess) || (preload = this.getPreload(da.getName())) <= 0) continue;
            ((MMapDataAccess)da).load(preload);
        }
    }

    @Override
    public DataAccess create(String name) {
        return this.create(name, this.getDefault(name, this.typeFallback));
    }

    @Override
    public DataAccess create(String name, int segmentSize) {
        return this.create(name, this.getDefault(name, this.typeFallback), segmentSize);
    }

    private DAType getDefault(String name, DAType typeFallback) {
        for (Map.Entry<String, DAType> entry : this.defaultTypes.entrySet()) {
            if (!name.matches(entry.getKey())) continue;
            return entry.getValue();
        }
        return typeFallback;
    }

    @Override
    public DataAccess create(String name, DAType type) {
        return this.create(name, type, -1);
    }

    @Override
    public DataAccess create(String name, DAType type, int segmentSize) {
        AbstractDataAccess da;
        if (!name.equals(Helper.toLowerCase((String)name))) {
            throw new IllegalArgumentException("Since 0.7 DataAccess objects does no longer accept upper case names");
        }
        if (this.map.containsKey(name)) {
            throw new IllegalStateException("DataAccess " + name + " has already been created");
        }
        if (type.isInMemory()) {
            da = type.isInteg() ? (type.isStoring() ? new RAMIntDataAccess(name, this.location, true, segmentSize) : new RAMIntDataAccess(name, this.location, false, segmentSize)) : (type.isStoring() ? new RAMDataAccess(name, this.location, true, segmentSize) : new RAMDataAccess(name, this.location, false, segmentSize));
        } else if (type.isMMap()) {
            da = new MMapDataAccess(name, this.location, type.isAllowWrites(), segmentSize);
        } else {
            throw new IllegalArgumentException("DAType not supported " + type);
        }
        this.map.put(name, da);
        return da;
    }

    @Override
    public void close() {
        for (DataAccess da : this.map.values()) {
            da.close();
        }
        this.map.clear();
    }

    @Override
    public void clear() {
        for (DataAccess da : this.map.values()) {
            da.close();
            this.removeBackingFile(da, da.getName());
        }
        this.map.clear();
    }

    @Override
    public void remove(String name) {
        DataAccess old = this.map.remove(name);
        if (old == null) {
            throw new IllegalStateException("Couldn't remove DataAccess: " + name);
        }
        old.close();
        this.removeBackingFile(old, name);
    }

    private void removeBackingFile(DataAccess da, String name) {
        if (da.getType().isStoring()) {
            Helper.removeDir((File)new File(this.location + name));
        }
    }

    @Override
    public DAType getDefaultType() {
        return this.typeFallback;
    }

    @Override
    public DAType getDefaultType(String dataAccess, boolean preferInts) {
        DAType type = this.getDefault(dataAccess, this.typeFallback);
        if (preferInts && type.isInMemory()) {
            return type.isStoring() ? DAType.RAM_INT_STORE : DAType.RAM_INT;
        }
        return type;
    }

    public boolean isStoring() {
        return this.typeFallback.isStoring();
    }

    @Override
    public Directory create() {
        if (this.isStoring()) {
            new File(this.location).mkdirs();
        }
        return this;
    }

    public String toString() {
        return this.getLocation();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public Map<String, DataAccess> getDAs() {
        return this.map;
    }
}

