/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.IntsRefEdgeIntAccess;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;

public class TurnCostStorage {
    static final int NO_TURN_ENTRY = -1;
    private static final int TC_FROM = 0;
    private static final int TC_TO = 4;
    private static final int TC_FLAGS = 8;
    private static final int TC_NEXT = 12;
    private static final int BYTES_PER_ENTRY = 16;
    private final BaseGraph baseGraph;
    private final DataAccess turnCosts;
    private final EdgeIntAccess edgeIntAccess = this.createEdgeIntAccess();
    private int turnCostsCount;

    public TurnCostStorage(BaseGraph baseGraph, DataAccess turnCosts) {
        this.baseGraph = baseGraph;
        this.turnCosts = turnCosts;
    }

    public TurnCostStorage create(long initBytes) {
        this.turnCosts.create(initBytes);
        return this;
    }

    public void flush() {
        this.turnCosts.setHeader(0, 0);
        this.turnCosts.setHeader(4, 16);
        this.turnCosts.setHeader(8, this.turnCostsCount);
        this.turnCosts.flush();
    }

    public void close() {
        this.turnCosts.close();
    }

    public long getCapacity() {
        return this.turnCosts.getCapacity();
    }

    public boolean loadExisting() {
        if (!this.turnCosts.loadExisting()) {
            return false;
        }
        GHUtility.checkDAVersion(this.turnCosts.getName(), 0, this.turnCosts.getHeader(0));
        if (this.turnCosts.getHeader(4) != 16) {
            throw new IllegalStateException("Number of bytes per turn cost entry does not match the current configuration: " + this.turnCosts.getHeader(0) + " vs. 16");
        }
        this.turnCostsCount = this.turnCosts.getHeader(8);
        return true;
    }

    public void set(BooleanEncodedValue bev, int fromEdge, int viaNode, int toEdge, boolean value) {
        int index = this.findOrCreateTurnCostEntry(fromEdge, viaNode, toEdge);
        if (index < 0) {
            throw new IllegalStateException("Invalid index: " + index + " at (" + fromEdge + ", " + viaNode + ", " + toEdge + ")");
        }
        bev.setBool(false, index, this.edgeIntAccess, value);
    }

    public void set(DecimalEncodedValue turnCostEnc, int fromEdge, int viaNode, int toEdge, double cost) {
        int index = this.findOrCreateTurnCostEntry(fromEdge, viaNode, toEdge);
        if (index < 0) {
            throw new IllegalStateException("Invalid index: " + index + " at (" + fromEdge + ", " + viaNode + ", " + toEdge + ")");
        }
        turnCostEnc.setDecimal(false, index, this.edgeIntAccess, cost);
    }

    private int findOrCreateTurnCostEntry(int fromEdge, int viaNode, int toEdge) {
        int index = this.findIndex(fromEdge, viaNode, toEdge);
        if (index < 0) {
            index = this.turnCostsCount++;
            this.ensureTurnCostIndex(index);
            int prevIndex = this.baseGraph.getNodeAccess().getTurnCostIndex(viaNode);
            this.baseGraph.getNodeAccess().setTurnCostIndex(viaNode, index);
            long pointer = (long)index * 16L;
            this.turnCosts.setInt(pointer + 0L, fromEdge);
            this.turnCosts.setInt(pointer + 4L, toEdge);
            this.turnCosts.setInt(pointer + 12L, prevIndex);
        }
        return index;
    }

    public double get(DecimalEncodedValue dev, int fromEdge, int viaNode, int toEdge) {
        int index = this.findIndex(fromEdge, viaNode, toEdge);
        if (index < 0) {
            return 0.0;
        }
        return dev.getDecimal(false, index, this.edgeIntAccess);
    }

    public boolean get(BooleanEncodedValue bev, int fromEdge, int viaNode, int toEdge) {
        int index = this.findIndex(fromEdge, viaNode, toEdge);
        if (index < 0) {
            return false;
        }
        return bev.getBool(false, index, this.edgeIntAccess);
    }

    private EdgeIntAccess createEdgeIntAccess() {
        return new EdgeIntAccess(){

            @Override
            public int getInt(int entryIndex, int index) {
                return TurnCostStorage.this.turnCosts.getInt((long)entryIndex * 16L + 8L);
            }

            @Override
            public void setInt(int entryIndex, int index, int value) {
                TurnCostStorage.this.turnCosts.setInt((long)entryIndex * 16L + 8L, value);
            }
        };
    }

    private void ensureTurnCostIndex(int nodeIndex) {
        this.turnCosts.ensureCapacity(((long)nodeIndex + 1L) * 16L);
    }

    private int findIndex(int fromEdge, int viaNode, int toEdge) {
        if (!EdgeIterator.Edge.isValid(fromEdge) || !EdgeIterator.Edge.isValid(toEdge)) {
            throw new IllegalArgumentException("from and to edge cannot be NO_EDGE");
        }
        if (viaNode < 0) {
            throw new IllegalArgumentException("via node cannot be negative");
        }
        int maxEntries = 1000;
        int index = this.baseGraph.getNodeAccess().getTurnCostIndex(viaNode);
        for (int i = 0; i < 1000; ++i) {
            if (index == -1) {
                return -1;
            }
            long pointer = (long)index * 16L;
            if (fromEdge == this.turnCosts.getInt(pointer + 0L) && toEdge == this.turnCosts.getInt(pointer + 4L)) {
                return index;
            }
            index = this.turnCosts.getInt(pointer + 12L);
        }
        throw new IllegalStateException("Turn cost list for node: " + viaNode + " is longer than expected, max: 1000");
    }

    public int getTurnCostsCount() {
        return this.turnCostsCount;
    }

    public int getTurnCostsCount(int node) {
        int index = this.baseGraph.getNodeAccess().getTurnCostIndex(node);
        int count = 0;
        while (index != -1) {
            long pointer = (long)index * 16L;
            index = this.turnCosts.getInt(pointer + 12L);
            ++count;
        }
        return count;
    }

    public boolean isClosed() {
        return this.turnCosts.isClosed();
    }

    public String toString() {
        return "turn_cost";
    }

    public Iterator getAllTurnCosts() {
        return new Itr();
    }

    private class Itr
    implements Iterator {
        private int viaNode = -1;
        private int turnCostIndex = -1;
        private final IntsRef intsRef = new IntsRef(1);
        private final EdgeIntAccess edgeIntAccess = new IntsRefEdgeIntAccess(this.intsRef);

        private Itr() {
        }

        private long turnCostPtr() {
            return (long)this.turnCostIndex * 16L;
        }

        @Override
        public int getFromEdge() {
            return TurnCostStorage.this.turnCosts.getInt(this.turnCostPtr() + 0L);
        }

        @Override
        public int getViaNode() {
            return this.viaNode;
        }

        @Override
        public int getToEdge() {
            return TurnCostStorage.this.turnCosts.getInt(this.turnCostPtr() + 4L);
        }

        @Override
        public boolean get(BooleanEncodedValue booleanEncodedValue) {
            this.intsRef.ints[0] = TurnCostStorage.this.turnCosts.getInt(this.turnCostPtr() + 8L);
            return booleanEncodedValue.getBool(false, -1, this.edgeIntAccess);
        }

        @Override
        public double getCost(DecimalEncodedValue encodedValue) {
            this.intsRef.ints[0] = TurnCostStorage.this.turnCosts.getInt(this.turnCostPtr() + 8L);
            return encodedValue.getDecimal(false, -1, this.edgeIntAccess);
        }

        @Override
        public boolean next() {
            boolean gotNextTci = this.nextTci();
            if (!gotNextTci) {
                this.turnCostIndex = -1;
                boolean gotNextNode = true;
                while (this.turnCostIndex == -1 && (gotNextNode = this.nextNode())) {
                }
                if (!gotNextNode) {
                    return false;
                }
            }
            return true;
        }

        private boolean nextNode() {
            ++this.viaNode;
            if (this.viaNode >= TurnCostStorage.this.baseGraph.getNodes()) {
                return false;
            }
            this.turnCostIndex = TurnCostStorage.this.baseGraph.getNodeAccess().getTurnCostIndex(this.viaNode);
            return true;
        }

        private boolean nextTci() {
            if (this.turnCostIndex == -1) {
                return false;
            }
            this.turnCostIndex = TurnCostStorage.this.turnCosts.getInt(this.turnCostPtr() + 12L);
            return this.turnCostIndex != -1;
        }
    }

    public static interface Iterator {
        public int getFromEdge();

        public int getViaNode();

        public int getToEdge();

        public boolean get(BooleanEncodedValue var1);

        public double getCost(DecimalEncodedValue var1);

        public boolean next();
    }
}

