/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

public class BitUtil {
    public static final BitUtil LITTLE = new BitUtil();

    public final double toDouble(byte[] bytes) {
        return this.toDouble(bytes, 0);
    }

    public final double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(this.toLong(bytes, offset));
    }

    public final byte[] fromDouble(double value) {
        byte[] bytes = new byte[8];
        this.fromDouble(bytes, value, 0);
        return bytes;
    }

    public final void fromDouble(byte[] bytes, double value) {
        this.fromDouble(bytes, value, 0);
    }

    public final void fromDouble(byte[] bytes, double value, int offset) {
        this.fromLong(bytes, Double.doubleToRawLongBits(value), offset);
    }

    public final float toFloat(byte[] bytes) {
        return this.toFloat(bytes, 0);
    }

    public final float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(this.toInt(bytes, offset));
    }

    public final byte[] fromFloat(float value) {
        byte[] bytes = new byte[4];
        this.fromFloat(bytes, value, 0);
        return bytes;
    }

    public final void fromFloat(byte[] bytes, float value) {
        this.fromFloat(bytes, value, 0);
    }

    public final void fromFloat(byte[] bytes, float value, int offset) {
        this.fromInt(bytes, Float.floatToRawIntBits(value), offset);
    }

    public final short toShort(byte[] b) {
        return this.toShort(b, 0);
    }

    public final short toShort(byte[] b, int offset) {
        return (short)((b[offset + 1] & 0xFF) << 8 | b[offset] & 0xFF);
    }

    public final int toInt(byte[] b) {
        return this.toInt(b, 0);
    }

    public final int toInt(byte[] b, int offset) {
        return (b[offset + 3] & 0xFF) << 24 | (b[offset + 2] & 0xFF) << 16 | (b[offset + 1] & 0xFF) << 8 | b[offset] & 0xFF;
    }

    public final int toUInt3(byte[] b, int offset) {
        return (b[offset + 2] & 0xFF) << 16 | (b[offset + 1] & 0xFF) << 8 | b[offset] & 0xFF;
    }

    public final byte[] fromInt(int value) {
        byte[] bytes = new byte[4];
        this.fromInt(bytes, value, 0);
        return bytes;
    }

    public final void fromInt(byte[] bytes, int value) {
        this.fromInt(bytes, value, 0);
    }

    public final byte[] fromShort(short value) {
        byte[] bytes = new byte[4];
        this.fromShort(bytes, value, 0);
        return bytes;
    }

    public final void fromShort(byte[] bytes, short value) {
        this.fromShort(bytes, value, 0);
    }

    public void fromShort(byte[] bytes, short value, int offset) {
        bytes[offset + 1] = (byte)(value >>> 8);
        bytes[offset] = (byte)value;
    }

    public final void fromInt(byte[] bytes, int value, int offset) {
        bytes[offset + 3] = (byte)(value >>> 24);
        bytes[offset + 2] = (byte)(value >>> 16);
        bytes[offset + 1] = (byte)(value >>> 8);
        bytes[offset] = (byte)value;
    }

    public final void fromUInt3(byte[] bytes, int value, int offset) {
        bytes[offset + 2] = (byte)(value >>> 16);
        bytes[offset + 1] = (byte)(value >>> 8);
        bytes[offset] = (byte)value;
    }

    public final long toLong(byte[] b) {
        return this.toLong(b, 0);
    }

    public final long toLong(int intLow, int intHigh) {
        return (long)intHigh << 32 | (long)intLow & 0xFFFFFFFFL;
    }

    public final long toLong(byte[] b, int offset) {
        return (long)this.toInt(b, offset + 4) << 32 | (long)this.toInt(b, offset) & 0xFFFFFFFFL;
    }

    public final byte[] fromLong(long value) {
        byte[] bytes = new byte[8];
        this.fromLong(bytes, value, 0);
        return bytes;
    }

    public final void fromLong(byte[] bytes, long value) {
        this.fromLong(bytes, value, 0);
    }

    public final void fromLong(byte[] bytes, long value, int offset) {
        bytes[offset + 7] = (byte)(value >> 56);
        bytes[offset + 6] = (byte)(value >> 48);
        bytes[offset + 5] = (byte)(value >> 40);
        bytes[offset + 4] = (byte)(value >> 32);
        bytes[offset + 3] = (byte)(value >> 24);
        bytes[offset + 2] = (byte)(value >> 16);
        bytes[offset + 1] = (byte)(value >> 8);
        bytes[offset] = (byte)value;
    }

    public byte[] fromBitString(String str) {
        int strLen = str.length();
        int bLen = str.length() / 8;
        if (strLen % 8 != 0) {
            ++bLen;
        }
        byte[] bytes = new byte[bLen];
        int charI = 0;
        for (int b = bLen - 1; b >= 0; --b) {
            int res = 0;
            for (int i = 0; i < 8; ++i) {
                res = (byte)(res << 1);
                if (charI < strLen && str.charAt(charI) != '0') {
                    res = (byte)(res | 1);
                }
                ++charI;
            }
            bytes[b] = res;
        }
        return bytes;
    }

    public final String toBitString(long value) {
        return this.toBitString(value, 64);
    }

    public String toLastBitString(long value, int bits) {
        StringBuilder sb = new StringBuilder(bits);
        long lastBit = 1L << bits - 1;
        for (int i = 0; i < bits; ++i) {
            if ((value & lastBit) == 0L) {
                sb.append('0');
            } else {
                sb.append('1');
            }
            value <<= 1;
        }
        return sb.toString();
    }

    public String toBitString(long value, int bits) {
        StringBuilder sb = new StringBuilder(bits);
        long lastBit = Long.MIN_VALUE;
        for (int i = 0; i < bits; ++i) {
            if ((value & lastBit) == 0L) {
                sb.append('0');
            } else {
                sb.append('1');
            }
            value <<= 1;
        }
        return sb.toString();
    }

    public String toBitString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 8);
        int lastBit = -128;
        for (int bIndex = bytes.length - 1; bIndex >= 0; --bIndex) {
            byte b = bytes[bIndex];
            for (int i = 0; i < 8; ++i) {
                if ((b & lastBit) == 0) {
                    sb.append('0');
                } else {
                    sb.append('1');
                }
                b = (byte)(b << 1);
            }
        }
        return sb.toString();
    }

    public final int getIntLow(long longValue) {
        return (int)(longValue & 0xFFFFFFFFL);
    }

    public final int getIntHigh(long longValue) {
        return (int)(longValue >> 32);
    }

    public static int countBitValue(int maxTurnCosts) {
        if (maxTurnCosts < 0) {
            throw new IllegalArgumentException("maxTurnCosts cannot be negative " + maxTurnCosts);
        }
        int counter = 0;
        while (maxTurnCosts > 0) {
            maxTurnCosts >>= 1;
            ++counter;
        }
        return counter;
    }

    public static int toSignedInt(long x) {
        return (int)x;
    }
}

