/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IntersectionValues {
    public int bearing;
    public boolean entry;
    public boolean in;
    public boolean out;

    public static List<IntersectionValues> createList(Map<String, Object> intersectionMap) {
        ArrayList<IntersectionValues> list = new ArrayList<IntersectionValues>();
        List bearings = (List)intersectionMap.get("bearings");
        Integer in = (Integer)intersectionMap.get("in");
        Integer out = (Integer)intersectionMap.get("out");
        List entry = (List)intersectionMap.get("entries");
        if (bearings.size() != entry.size()) {
            throw new IllegalStateException("Bearings and entry array sizes different");
        }
        int numEntries = bearings.size();
        for (int i = 0; i < numEntries; ++i) {
            IntersectionValues iv = new IntersectionValues();
            iv.bearing = (Integer)bearings.get(i);
            iv.entry = (Boolean)entry.get(i);
            iv.in = in == i;
            iv.out = out == i;
            list.add(iv);
        }
        return list;
    }

    public static Map<String, Object> createIntersection(List<IntersectionValues> list) {
        HashMap<String, Object> intersection = new HashMap<String, Object>();
        intersection.put("bearings", list.stream().map(x -> x.bearing).collect(Collectors.toList()));
        intersection.put("entries", list.stream().map(x -> x.entry).collect(Collectors.toList()));
        for (int m = 0; m < list.size(); ++m) {
            IntersectionValues intersectionValues = list.get(m);
            if (intersectionValues.in) {
                intersection.put("in", m);
            }
            if (!intersectionValues.out) continue;
            intersection.put("out", m);
        }
        return intersection;
    }
}

