/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.DoubleArrayList;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.sorting.IndirectComparator;
import com.carrotsearch.hppc.sorting.IndirectSort;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeIterator;
import com.graphhopper.routing.ch.SplitArray2D;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.TurnCost;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;

public class CHPreparationGraph {
    private final int nodes;
    private final int edges;
    private final boolean edgeBased;
    private final TurnCostFunction turnCostFunction;
    private SplitArray2D<PrepareEdge> prepareEdges;
    private IntSet neighborSet;
    private OrigGraph origGraph;
    private OrigGraph.Builder origGraphBuilder;
    private int nextShortcutId;
    private boolean ready;

    public static CHPreparationGraph nodeBased(int nodes, int edges) {
        return new CHPreparationGraph(nodes, edges, false, (in, via, out) -> 0.0);
    }

    public static CHPreparationGraph edgeBased(int nodes, int edges, TurnCostFunction turnCostFunction) {
        return new CHPreparationGraph(nodes, edges, true, turnCostFunction);
    }

    private CHPreparationGraph(int nodes, int edges, boolean edgeBased, TurnCostFunction turnCostFunction) {
        this.turnCostFunction = turnCostFunction;
        this.nodes = nodes;
        this.edges = edges;
        this.edgeBased = edgeBased;
        this.prepareEdges = new SplitArray2D(nodes, 2);
        this.origGraphBuilder = edgeBased ? new OrigGraph.Builder() : null;
        this.neighborSet = new IntHashSet();
        this.nextShortcutId = edges;
    }

    public static void buildFromGraph(CHPreparationGraph prepareGraph, Graph graph, Weighting weighting) {
        if (graph.getNodes() != prepareGraph.getNodes()) {
            throw new IllegalArgumentException("Cannot initialize from given graph. The number of nodes does not match: " + graph.getNodes() + " vs. " + prepareGraph.getNodes());
        }
        if (graph.getEdges() != prepareGraph.getOriginalEdges()) {
            throw new IllegalArgumentException("Cannot initialize from given graph. The number of edges does not match: " + graph.getEdges() + " vs. " + prepareGraph.getOriginalEdges());
        }
        BooleanEncodedValue accessEnc = weighting.getFlagEncoder().getAccessEnc();
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            double weightFwd = iter.get(accessEnc) ? weighting.calcEdgeWeight(iter, false) : Double.POSITIVE_INFINITY;
            double weightBwd = iter.getReverse(accessEnc) ? weighting.calcEdgeWeight(iter, true) : Double.POSITIVE_INFINITY;
            prepareGraph.addEdge(iter.getBaseNode(), iter.getAdjNode(), iter.getEdge(), weightFwd, weightBwd);
        }
        prepareGraph.prepareForContraction();
    }

    public static TurnCostFunction buildTurnCostFunctionFromTurnCostStorage(Graph graph, Weighting weighting) {
        String key;
        FlagEncoder encoder = weighting.getFlagEncoder();
        if (!encoder.hasEncodedValue(key = TurnCost.key(encoder.toString()))) {
            return (inEdge, viaNode, outEdge) -> 0.0;
        }
        DecimalEncodedValue turnCostEnc = encoder.getDecimalEncodedValue(key);
        TurnCostStorage turnCostStorage = graph.getTurnCostStorage();
        LongArrayList turnCostEdgePairs = new LongArrayList();
        DoubleArrayList turnCosts = new DoubleArrayList();
        int[] turnCostNodes = new int[graph.getNodes() + 1];
        TurnCostStorage.TurnRelationIterator tcIter = turnCostStorage.getAllTurnRelations();
        int lastNode = -1;
        while (tcIter.next()) {
            int viaNode2 = tcIter.getViaNode();
            if (viaNode2 < lastNode) {
                throw new IllegalStateException();
            }
            long edgePair = BitUtil.LITTLE.combineIntsToLong(tcIter.getFromEdge(), tcIter.getToEdge());
            double turnCost = tcIter.getCost(turnCostEnc);
            int index = turnCostEdgePairs.size();
            turnCostEdgePairs.add(edgePair);
            turnCosts.add(turnCost);
            if (viaNode2 != lastNode) {
                for (int i = lastNode + 1; i <= viaNode2; ++i) {
                    turnCostNodes[i] = index;
                }
            }
            lastNode = viaNode2;
        }
        for (int i = lastNode + 1; i <= turnCostNodes.length - 1; ++i) {
            turnCostNodes[i] = turnCostEdgePairs.size();
        }
        turnCostNodes[turnCostNodes.length - 1] = turnCostEdgePairs.size();
        double uTurnCosts = weighting.calcTurnWeight(1, 0, 1);
        return (inEdge, viaNode, outEdge) -> {
            if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
                return 0.0;
            }
            if (inEdge == outEdge) {
                return uTurnCosts;
            }
            for (int i = turnCostNodes[viaNode]; i < turnCostNodes[viaNode + 1]; ++i) {
                long l = turnCostEdgePairs.get(i);
                if (inEdge != BitUtil.LITTLE.getIntLow(l) || outEdge != BitUtil.LITTLE.getIntHigh(l)) continue;
                return turnCosts.get(i);
            }
            return 0.0;
        };
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getOriginalEdges() {
        return this.edges;
    }

    public int getDegree(int node) {
        return this.prepareEdges.size(node);
    }

    public void addEdge(int from, int to, int edge, double weightFwd, double weightBwd) {
        this.checkNotReady();
        boolean fwd = Double.isFinite(weightFwd);
        boolean bwd = Double.isFinite(weightBwd);
        if (!fwd && !bwd) {
            return;
        }
        PrepareBaseEdge prepareEdge = new PrepareBaseEdge(edge, from, to, (float)weightFwd, (float)weightBwd);
        if (fwd) {
            this.addOutEdge(from, prepareEdge);
            this.addInEdge(to, prepareEdge);
        }
        if (bwd && from != to) {
            this.addOutEdge(to, prepareEdge);
            this.addInEdge(from, prepareEdge);
        }
        if (this.edgeBased) {
            this.origGraphBuilder.addEdge(from, to, edge, fwd, bwd);
        }
    }

    public int addShortcut(int from, int to, int origEdgeKeyFirst, int origEdgeKeyLast, int skipped1, int skipped2, double weight, int origEdgeCount) {
        this.checkReady();
        PrepareShortcut prepareEdge = this.edgeBased ? new EdgeBasedPrepareShortcut(this.nextShortcutId, from, to, origEdgeKeyFirst, origEdgeKeyLast, weight, skipped1, skipped2, origEdgeCount) : new PrepareShortcut(this.nextShortcutId, from, to, weight, skipped1, skipped2, origEdgeCount);
        this.addOutEdge(from, prepareEdge);
        if (from != to) {
            this.addInEdge(to, prepareEdge);
        }
        return this.nextShortcutId++;
    }

    public void prepareForContraction() {
        this.checkNotReady();
        this.prepareEdges.trimToSize();
        this.origGraph = this.edgeBased ? this.origGraphBuilder.build() : null;
        this.origGraphBuilder = null;
        this.ready = true;
    }

    public PrepareGraphEdgeExplorer createOutEdgeExplorer() {
        this.checkReady();
        return new PrepareGraphEdgeExplorerImpl(this.prepareEdges, false);
    }

    public PrepareGraphEdgeExplorer createInEdgeExplorer() {
        this.checkReady();
        return new PrepareGraphEdgeExplorerImpl(this.prepareEdges, true);
    }

    public PrepareGraphOrigEdgeExplorer createOutOrigEdgeExplorer() {
        this.checkReady();
        if (!this.edgeBased) {
            throw new IllegalStateException("orig out explorer is not available for node-based graph");
        }
        return this.origGraph.createOutOrigEdgeExplorer();
    }

    public PrepareGraphOrigEdgeExplorer createInOrigEdgeExplorer() {
        this.checkReady();
        if (!this.edgeBased) {
            throw new IllegalStateException("orig in explorer is not available for node-based graph");
        }
        return this.origGraph.createInOrigEdgeExplorer();
    }

    public double getTurnWeight(int inEdge, int viaNode, int outEdge) {
        return this.turnCostFunction.getTurnWeight(inEdge, viaNode, outEdge);
    }

    public IntContainer disconnect(int node) {
        this.checkReady();
        this.neighborSet.clear();
        IntArrayList neighbors = new IntArrayList(this.getDegree(node));
        for (int i = 0; i < this.prepareEdges.size(node); ++i) {
            PrepareEdge prepareEdge = this.prepareEdges.get(node, i);
            int adjNode = prepareEdge.getNodeB();
            if (adjNode == node) {
                adjNode = prepareEdge.getNodeA();
            }
            if (adjNode == node) continue;
            this.prepareEdges.remove(adjNode, prepareEdge);
            if (!this.neighborSet.add(adjNode)) continue;
            neighbors.add(adjNode);
        }
        this.prepareEdges.clear(node);
        return neighbors;
    }

    public void close() {
        this.checkReady();
        this.prepareEdges = null;
        this.neighborSet = null;
        if (this.edgeBased) {
            this.origGraph = null;
        }
    }

    private void addOutEdge(int node, PrepareEdge prepareEdge) {
        this.prepareEdges.addPartTwo(node, prepareEdge);
    }

    private void addInEdge(int node, PrepareEdge prepareEdge) {
        this.prepareEdges.addPartOne(node, prepareEdge);
    }

    private void checkReady() {
        if (!this.ready) {
            throw new IllegalStateException("You need to call prepareForContraction() before calling this method");
        }
    }

    private void checkNotReady() {
        if (this.ready) {
            throw new IllegalStateException("You cannot call this method after calling prepareForContraction()");
        }
    }

    private static void sortAndTrim(IntArrayList arr, int[] sortOrder) {
        arr.buffer = CHPreparationGraph.applySortOrder(sortOrder, arr.buffer);
        arr.elementsCount = arr.buffer.length;
    }

    private static int[] applySortOrder(int[] sortOrder, int[] arr) {
        if (sortOrder.length > arr.length) {
            throw new IllegalArgumentException("sort order must not be shorter than array");
        }
        int[] result = new int[sortOrder.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = arr[sortOrder[i]];
        }
        return result;
    }

    private static class OrigEdgeIteratorImpl
    implements PrepareGraphOrigEdgeExplorer,
    PrepareGraphOrigEdgeIterator {
        private final OrigGraph graph;
        private final boolean reverse;
        private int node;
        private int endEdge;
        private int index;

        public OrigEdgeIteratorImpl(OrigGraph graph, boolean reverse) {
            this.graph = graph;
            this.reverse = reverse;
        }

        @Override
        public PrepareGraphOrigEdgeIterator setBaseNode(int node) {
            this.node = node;
            this.index = this.graph.firstEdgesByNode.get(node) - 1;
            this.endEdge = this.graph.firstEdgesByNode.get(node + 1);
            return this;
        }

        @Override
        public boolean next() {
            do {
                ++this.index;
                if (this.index < this.endEdge) continue;
                return false;
            } while (!this.hasAccess());
            return true;
        }

        @Override
        public int getBaseNode() {
            return this.node;
        }

        @Override
        public int getAdjNode() {
            return this.graph.adjNodes.get(this.index);
        }

        @Override
        public int getOrigEdgeKeyFirst() {
            int e = this.graph.edgesAndFlags.get(this.index);
            return GHUtility.createEdgeKey(this.node, this.getAdjNode(), e >> 2, false);
        }

        @Override
        public int getOrigEdgeKeyLast() {
            return this.getOrigEdgeKeyFirst();
        }

        private boolean hasAccess() {
            int e = this.graph.edgesAndFlags.get(this.index);
            if (this.reverse) {
                return (e & 1) == 1;
            }
            return (e & 2) == 2;
        }
    }

    private static class OrigGraph {
        private final IntArrayList adjNodes;
        private final IntArrayList edgesAndFlags;
        private final IntArrayList firstEdgesByNode;

        private OrigGraph(IntArrayList firstEdgesByNode, IntArrayList adjNodes, IntArrayList edgesAndFlags) {
            this.firstEdgesByNode = firstEdgesByNode;
            this.adjNodes = adjNodes;
            this.edgesAndFlags = edgesAndFlags;
        }

        PrepareGraphOrigEdgeExplorer createOutOrigEdgeExplorer() {
            return new OrigEdgeIteratorImpl(this, false);
        }

        PrepareGraphOrigEdgeExplorer createInOrigEdgeExplorer() {
            return new OrigEdgeIteratorImpl(this, true);
        }

        static class Builder {
            private final IntArrayList fromNodes = new IntArrayList();
            private final IntArrayList toNodes = new IntArrayList();
            private final IntArrayList edgesAndFlags = new IntArrayList();
            private int maxFrom = -1;
            private int maxTo = -1;

            Builder() {
            }

            void addEdge(int from, int to, int edge, boolean fwd, boolean bwd) {
                this.fromNodes.add(from);
                this.toNodes.add(to);
                this.edgesAndFlags.add(this.getEdgeWithFlags(edge, fwd, bwd));
                this.maxFrom = Math.max(this.maxFrom, from);
                this.maxTo = Math.max(this.maxTo, to);
                this.fromNodes.add(to);
                this.toNodes.add(from);
                this.edgesAndFlags.add(this.getEdgeWithFlags(edge, bwd, fwd));
                this.maxFrom = Math.max(this.maxFrom, to);
                this.maxTo = Math.max(this.maxTo, from);
            }

            OrigGraph build() {
                int[] sortOrder = IndirectSort.mergesort((int)0, (int)this.fromNodes.elementsCount, (IndirectComparator)new IndirectComparator.AscendingIntComparator(this.fromNodes.buffer));
                CHPreparationGraph.sortAndTrim(this.fromNodes, sortOrder);
                CHPreparationGraph.sortAndTrim(this.toNodes, sortOrder);
                CHPreparationGraph.sortAndTrim(this.edgesAndFlags, sortOrder);
                return new OrigGraph(this.buildFirstEdgesByNode(), this.toNodes, this.edgesAndFlags);
            }

            private int getEdgeWithFlags(int edge, boolean fwd, boolean bwd) {
                if (edge >= 0x1FFFFFFF) {
                    throw new IllegalArgumentException("Maximum edge ID exceeded: 2147483647");
                }
                edge <<= 1;
                if (fwd) {
                    ++edge;
                }
                edge <<= 1;
                if (bwd) {
                    ++edge;
                }
                return edge;
            }

            private IntArrayList buildFirstEdgesByNode() {
                int numFroms = this.maxFrom + 1;
                IntArrayList firstEdgesByNode = new IntArrayList(numFroms + 1);
                firstEdgesByNode.elementsCount = numFroms + 1;
                int numEdges = this.fromNodes.size();
                if (numFroms == 0) {
                    firstEdgesByNode.set(0, numEdges);
                    return firstEdgesByNode;
                }
                int edgeIndex = 0;
                for (int from = 0; from < numFroms; ++from) {
                    while (edgeIndex < numEdges && this.fromNodes.get(edgeIndex) < from) {
                        ++edgeIndex;
                    }
                    firstEdgesByNode.set(from, edgeIndex);
                }
                firstEdgesByNode.set(numFroms, numEdges);
                return firstEdgesByNode;
            }
        }
    }

    private static class EdgeBasedPrepareShortcut
    extends PrepareShortcut {
        private final int origEdgeKeyFirst;
        private final int origEdgeKeyLast;

        public EdgeBasedPrepareShortcut(int prepareEdge, int from, int to, int origEdgeKeyFirst, int origEdgeKeyLast, double weight, int skipped1, int skipped2, int origEdgeCount) {
            super(prepareEdge, from, to, weight, skipped1, skipped2, origEdgeCount);
            this.origEdgeKeyFirst = origEdgeKeyFirst;
            this.origEdgeKeyLast = origEdgeKeyLast;
        }

        @Override
        public int getOrigEdgeKeyFirstAB() {
            return this.origEdgeKeyFirst;
        }

        @Override
        public int getOrigEdgeKeyFirstBA() {
            return this.origEdgeKeyFirst;
        }

        @Override
        public int getOrigEdgeKeyLastAB() {
            return this.origEdgeKeyLast;
        }

        @Override
        public int getOrigEdgeKeyLastBA() {
            return this.origEdgeKeyLast;
        }

        @Override
        public String toString() {
            return this.getNodeA() + "-" + this.getNodeB() + " (" + this.origEdgeKeyFirst + ", " + this.origEdgeKeyLast + ") " + this.getWeightAB();
        }
    }

    private static class PrepareShortcut
    implements PrepareEdge {
        private final int prepareEdge;
        private final int from;
        private final int to;
        private double weight;
        private int skipped1;
        private int skipped2;
        private int origEdgeCount;

        private PrepareShortcut(int prepareEdge, int from, int to, double weight, int skipped1, int skipped2, int origEdgeCount) {
            this.prepareEdge = prepareEdge;
            this.from = from;
            this.to = to;
            assert (Double.isFinite(weight));
            this.weight = weight;
            this.skipped1 = skipped1;
            this.skipped2 = skipped2;
            this.origEdgeCount = origEdgeCount;
        }

        @Override
        public boolean isShortcut() {
            return true;
        }

        @Override
        public int getPrepareEdge() {
            return this.prepareEdge;
        }

        @Override
        public int getNodeA() {
            return this.from;
        }

        @Override
        public int getNodeB() {
            return this.to;
        }

        @Override
        public double getWeightAB() {
            return this.weight;
        }

        @Override
        public double getWeightBA() {
            return this.weight;
        }

        @Override
        public int getOrigEdgeKeyFirstAB() {
            throw new IllegalStateException("Not supported for node-based shortcuts");
        }

        @Override
        public int getOrigEdgeKeyFirstBA() {
            throw new IllegalStateException("Not supported for node-based shortcuts");
        }

        @Override
        public int getOrigEdgeKeyLastAB() {
            throw new IllegalStateException("Not supported for node-based shortcuts");
        }

        @Override
        public int getOrigEdgeKeyLastBA() {
            throw new IllegalStateException("Not supported for node-based shortcuts");
        }

        @Override
        public int getSkipped1() {
            return this.skipped1;
        }

        @Override
        public int getSkipped2() {
            return this.skipped2;
        }

        @Override
        public int getOrigEdgeCount() {
            return this.origEdgeCount;
        }

        @Override
        public void setSkipped1(int skipped1) {
            this.skipped1 = skipped1;
        }

        @Override
        public void setSkipped2(int skipped2) {
            this.skipped2 = skipped2;
        }

        @Override
        public void setWeight(double weight) {
            this.weight = weight;
        }

        @Override
        public void setOrigEdgeCount(int origEdgeCount) {
            this.origEdgeCount = origEdgeCount;
        }

        public String toString() {
            return this.from + "-" + this.to + " " + this.weight;
        }
    }

    public static class PrepareBaseEdge
    implements PrepareEdge {
        private final int prepareEdge;
        private final int nodeA;
        private final int nodeB;
        private final float weightAB;
        private final float weightBA;

        public PrepareBaseEdge(int prepareEdge, int nodeA, int nodeB, float weightAB, float weightBA) {
            this.prepareEdge = prepareEdge;
            this.nodeA = nodeA;
            this.nodeB = nodeB;
            this.weightAB = weightAB;
            this.weightBA = weightBA;
        }

        @Override
        public boolean isShortcut() {
            return false;
        }

        @Override
        public int getPrepareEdge() {
            return this.prepareEdge;
        }

        @Override
        public int getNodeA() {
            return this.nodeA;
        }

        @Override
        public int getNodeB() {
            return this.nodeB;
        }

        @Override
        public double getWeightAB() {
            return this.weightAB;
        }

        @Override
        public double getWeightBA() {
            return this.weightBA;
        }

        @Override
        public int getOrigEdgeKeyFirstAB() {
            int key = this.prepareEdge << 1;
            return this.nodeA > this.nodeB ? key + 1 : key;
        }

        @Override
        public int getOrigEdgeKeyFirstBA() {
            int key = this.prepareEdge << 1;
            return this.nodeB > this.nodeA ? key + 1 : key;
        }

        @Override
        public int getOrigEdgeKeyLastAB() {
            return this.getOrigEdgeKeyFirstAB();
        }

        @Override
        public int getOrigEdgeKeyLastBA() {
            return this.getOrigEdgeKeyFirstBA();
        }

        @Override
        public int getSkipped1() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSkipped2() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getOrigEdgeCount() {
            return 1;
        }

        @Override
        public void setSkipped1(int skipped1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSkipped2(int skipped2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWeight(double weight) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOrigEdgeCount(int origEdgeCount) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.nodeA + "-" + this.nodeB + " (" + this.prepareEdge + ") " + this.weightAB + " " + this.weightBA;
        }
    }

    static interface PrepareEdge {
        public boolean isShortcut();

        public int getPrepareEdge();

        public int getNodeA();

        public int getNodeB();

        public double getWeightAB();

        public double getWeightBA();

        public int getOrigEdgeKeyFirstAB();

        public int getOrigEdgeKeyFirstBA();

        public int getOrigEdgeKeyLastAB();

        public int getOrigEdgeKeyLastBA();

        public int getSkipped1();

        public int getSkipped2();

        public int getOrigEdgeCount();

        public void setSkipped1(int var1);

        public void setSkipped2(int var1);

        public void setWeight(double var1);

        public void setOrigEdgeCount(int var1);
    }

    private static class PrepareGraphEdgeExplorerImpl
    implements PrepareGraphEdgeExplorer,
    PrepareGraphEdgeIterator {
        private final SplitArray2D<PrepareEdge> prepareEdges;
        private final boolean reverse;
        private int node = -1;
        private int end;
        private PrepareEdge currEdge;
        private int index;

        PrepareGraphEdgeExplorerImpl(SplitArray2D<PrepareEdge> prepareEdges, boolean reverse) {
            this.prepareEdges = prepareEdges;
            this.reverse = reverse;
        }

        @Override
        public PrepareGraphEdgeIterator setBaseNode(int node) {
            this.node = node;
            this.index = this.reverse ? -1 : this.prepareEdges.mid(node) - 1;
            this.end = this.reverse ? this.prepareEdges.mid(node) : this.prepareEdges.size(node);
            return this;
        }

        @Override
        public boolean next() {
            ++this.index;
            if (this.index == this.end) {
                this.currEdge = null;
                return false;
            }
            this.currEdge = this.prepareEdges.get(this.node, this.index);
            return true;
        }

        @Override
        public int getBaseNode() {
            return this.node;
        }

        @Override
        public int getAdjNode() {
            return this.nodeAisBase() ? this.currEdge.getNodeB() : this.currEdge.getNodeA();
        }

        @Override
        public int getPrepareEdge() {
            return this.currEdge.getPrepareEdge();
        }

        @Override
        public boolean isShortcut() {
            return this.currEdge.isShortcut();
        }

        @Override
        public int getOrigEdgeKeyFirst() {
            return this.nodeAisBase() ? this.currEdge.getOrigEdgeKeyFirstAB() : this.currEdge.getOrigEdgeKeyFirstBA();
        }

        @Override
        public int getOrigEdgeKeyLast() {
            return this.nodeAisBase() ? this.currEdge.getOrigEdgeKeyLastAB() : this.currEdge.getOrigEdgeKeyLastBA();
        }

        @Override
        public int getSkipped1() {
            return this.currEdge.getSkipped1();
        }

        @Override
        public int getSkipped2() {
            return this.currEdge.getSkipped2();
        }

        @Override
        public double getWeight() {
            if (this.nodeAisBase()) {
                return this.reverse ? this.currEdge.getWeightBA() : this.currEdge.getWeightAB();
            }
            return this.reverse ? this.currEdge.getWeightAB() : this.currEdge.getWeightBA();
        }

        @Override
        public int getOrigEdgeCount() {
            return this.currEdge.getOrigEdgeCount();
        }

        @Override
        public void setSkippedEdges(int skipped1, int skipped2) {
            this.currEdge.setSkipped1(skipped1);
            this.currEdge.setSkipped2(skipped2);
        }

        @Override
        public void setWeight(double weight) {
            assert (Double.isFinite(weight));
            this.currEdge.setWeight(weight);
        }

        @Override
        public void setOrigEdgeCount(int origEdgeCount) {
            this.currEdge.setOrigEdgeCount(origEdgeCount);
        }

        public String toString() {
            return this.currEdge == null ? "not_started" : this.getBaseNode() + "-" + this.getAdjNode();
        }

        private boolean nodeAisBase() {
            return this.currEdge.getNodeA() == this.node;
        }
    }

    @FunctionalInterface
    public static interface TurnCostFunction {
        public double getTurnWeight(int var1, int var2, int var3);
    }
}

