/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.apache.commons.collections.IntFloatBinaryHeap;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.OnFlyStatisticsCalculator;
import com.graphhopper.routing.ch.PrepareCHEntry;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeIterator;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.Locale;

public class EdgeBasedWitnessPathSearcher {
    private static final int NO_NODE = -1;
    private static final double MAX_ZERO_WEIGHT_LOOP = 0.001;
    private final CHPreparationGraph prepareGraph;
    private PrepareGraphEdgeExplorer outEdgeExplorer;
    private PrepareGraphOrigEdgeExplorer origInEdgeExplorer;
    private final Params params = new Params();
    private int sourceEdge;
    private int sourceNode;
    private int centerNode;
    private double bestPathWeight;
    private int bestPathIncKey;
    private boolean bestPathIsBridgePath;
    private int numPathsToCenter;
    private int numSettledEdges;
    private int numPolledEdges;
    private double[] weights;
    private int[] prepareEdges;
    private int[] parents;
    private int[] adjNodesAndIsPathToCenters;
    private IntObjectMap<PrepareCHEntry> initialEntryParents;
    private IntArrayList changedEdges;
    private IntFloatBinaryHeap dijkstraHeap;
    private int maxSettledEdges;
    private final OnFlyStatisticsCalculator settledEdgesStats = new OnFlyStatisticsCalculator();
    private final Stats currentBatchStats = new Stats();
    private final Stats totalStats = new Stats();

    public EdgeBasedWitnessPathSearcher(CHPreparationGraph prepareGraph, PMap pMap) {
        this.prepareGraph = prepareGraph;
        this.extractParams(pMap);
        this.outEdgeExplorer = prepareGraph.createOutEdgeExplorer();
        this.origInEdgeExplorer = prepareGraph.createInOrigEdgeExplorer();
        this.maxSettledEdges = this.params.minimumMaxSettledEdges;
        this.initStorage(2 * prepareGraph.getOriginalEdges());
        this.initCollections();
    }

    private void extractParams(PMap pMap) {
        this.params.sigmaFactor = pMap.getDouble("prepare.ch.edge.witness_search.sigma_factor", this.params.sigmaFactor);
        this.params.minimumMaxSettledEdges = pMap.getInt("prepare.ch.edge.witness_search.min_max_settled_edges", this.params.minimumMaxSettledEdges);
        this.params.settledEdgeStatsResetInterval = pMap.getInt("prepare.ch.edge.witness_search.reset_interval", this.params.settledEdgeStatsResetInterval);
    }

    public int initSearch(int centerNode, int sourceNode, int sourceEdge) {
        this.reset();
        this.sourceEdge = sourceEdge;
        this.sourceNode = sourceNode;
        this.centerNode = centerNode;
        this.setInitialEntries(sourceNode, sourceEdge, centerNode);
        if (this.numPathsToCenter < 1) {
            this.reset();
            return 0;
        }
        this.currentBatchStats.numSearches++;
        Stats stats = this.currentBatchStats;
        stats.maxNumSettledEdges = stats.maxNumSettledEdges + (long)this.maxSettledEdges;
        this.totalStats.numSearches++;
        stats = this.totalStats;
        stats.maxNumSettledEdges = stats.maxNumSettledEdges + (long)this.maxSettledEdges;
        return this.dijkstraHeap.getSize();
    }

    public PrepareCHEntry runSearch(int targetNode, int targetEdge) {
        int currKey;
        int edgeKey;
        this.bestPathWeight = this.sourceNode == targetNode ? this.calcTurnWeight(this.sourceEdge, this.sourceNode, targetEdge) : Double.POSITIVE_INFINITY;
        this.bestPathIncKey = -1;
        this.bestPathIsBridgePath = false;
        PrepareGraphOrigEdgeIterator inIter = this.origInEdgeExplorer.setBaseNode(targetNode);
        while (inIter.next()) {
            boolean isZeroWeightLoop;
            edgeKey = GHUtility.reverseEdgeKey(inIter.getOrigEdgeKeyLast());
            if (!EdgeIterator.Edge.isValid(this.prepareEdges[edgeKey]) || (isZeroWeightLoop = this.parents[edgeKey] >= 0 && targetNode == this.getAdjNode(this.parents[edgeKey]) && this.weights[edgeKey] - this.weights[this.parents[edgeKey]] <= 0.001)) continue;
            this.updateBestPath(targetNode, targetEdge, edgeKey);
        }
        while (!this.dijkstraHeap.isEmpty() && (this.numPathsToCenter >= 1 || this.bestPathIsBridgePath && !Double.isInfinite(this.bestPathWeight)) && !(this.weights[currKey = this.dijkstraHeap.peekElement()] > this.bestPathWeight)) {
            this.dijkstraHeap.poll();
            ++this.numPolledEdges;
            this.currentBatchStats.numPolledEdges++;
            this.totalStats.numPolledEdges++;
            if (this.isPathToCenter(currKey)) {
                --this.numPathsToCenter;
            }
            if (this.numSettledEdges > this.maxSettledEdges && !this.isPathToCenter(currKey)) continue;
            int fromNode = this.getAdjNode(currKey);
            PrepareGraphEdgeIterator iter = this.outEdgeExplorer.setBaseNode(fromNode);
            while (iter.next()) {
                double edgeWeight = iter.getWeight() + this.calcTurnWeight(GHUtility.getEdgeFromEdgeKey(currKey), iter.getBaseNode(), GHUtility.getEdgeFromEdgeKey(iter.getOrigEdgeKeyFirst()));
                double weight = edgeWeight + this.weights[currKey];
                if (Double.isInfinite(weight)) continue;
                boolean isPathToCenter = this.isPathToCenter(currKey) && iter.getAdjNode() == this.centerNode;
                boolean isZeroWeightLoop = fromNode == targetNode && edgeWeight <= 0.001;
                int key = iter.getOrigEdgeKeyLast();
                if (!EdgeIterator.Edge.isValid(this.prepareEdges[key])) {
                    this.setEntry(key, iter, weight, currKey, isPathToCenter);
                    this.changedEdges.add(key);
                    this.dijkstraHeap.insert(weight, key);
                    if (isZeroWeightLoop) continue;
                    this.updateBestPath(targetNode, targetEdge, key);
                    continue;
                }
                if (!(weight < this.weights[key]) && (weight != this.weights[key] || iter.getAdjNode() != targetNode || this.isPathToCenter(currKey))) continue;
                this.updateEntry(key, iter, weight, currKey, isPathToCenter);
                this.dijkstraHeap.update(weight, key);
                if (isZeroWeightLoop) continue;
                this.updateBestPath(targetNode, targetEdge, key);
            }
            ++this.numSettledEdges;
            this.currentBatchStats.numSettledEdges++;
            this.totalStats.numSettledEdges++;
        }
        if (this.bestPathIsBridgePath) {
            PrepareCHEntry result;
            edgeKey = this.bestPathIncKey;
            PrepareCHEntry entry = result = this.getEntryForKey(edgeKey);
            while (this.parents[edgeKey] >= 0) {
                PrepareCHEntry parent;
                edgeKey = this.parents[edgeKey];
                entry.parent = parent = this.getEntryForKey(edgeKey);
                entry = parent;
            }
            entry.parent = (PrepareCHEntry)this.initialEntryParents.get(this.parents[edgeKey]);
            return result;
        }
        return null;
    }

    private void setAdjNodeAndPathToCenter(int key, int adjNode, boolean isPathToCenter) {
        this.adjNodesAndIsPathToCenters[key] = (adjNode << 1) + (isPathToCenter ? 1 : 0);
    }

    private int getAdjNode(int key) {
        return this.adjNodesAndIsPathToCenters[key] >> 1;
    }

    private void setPathToCenter(int key, boolean isPathToCenter) {
        if (isPathToCenter) {
            int n = key;
            this.adjNodesAndIsPathToCenters[n] = this.adjNodesAndIsPathToCenters[n] | 1;
        } else {
            int n = key;
            this.adjNodesAndIsPathToCenters[n] = this.adjNodesAndIsPathToCenters[n] & 0xFFFFFFFE;
        }
    }

    private boolean isPathToCenter(int key) {
        return (this.adjNodesAndIsPathToCenters[key] & 1) == 1;
    }

    public String getStatisticsString() {
        return "last batch: " + this.currentBatchStats.toString() + " total: " + this.totalStats.toString();
    }

    public long getNumPolledEdges() {
        return this.numPolledEdges;
    }

    public long getTotalNumSearches() {
        return this.totalStats.numSearches;
    }

    public void resetStats() {
        this.currentBatchStats.reset();
    }

    public void close() {
        this.prepareGraph.close();
        this.outEdgeExplorer = null;
        this.origInEdgeExplorer = null;
        this.weights = null;
        this.prepareEdges = null;
        this.parents = null;
        this.adjNodesAndIsPathToCenters = null;
        this.initialEntryParents = null;
        this.changedEdges.release();
        this.dijkstraHeap = null;
    }

    private void initStorage(int numEntries) {
        this.weights = new double[numEntries];
        Arrays.fill(this.weights, Double.POSITIVE_INFINITY);
        this.prepareEdges = new int[numEntries];
        Arrays.fill(this.prepareEdges, -1);
        this.parents = new int[numEntries];
        Arrays.fill(this.parents, -1);
        this.adjNodesAndIsPathToCenters = new int[numEntries];
        Arrays.fill(this.adjNodesAndIsPathToCenters, -2);
    }

    private void initCollections() {
        this.initialEntryParents = new IntObjectHashMap(10);
        this.changedEdges = new IntArrayList(1000);
        this.dijkstraHeap = new IntFloatBinaryHeap(1000);
    }

    private void setInitialEntries(int sourceNode, int sourceEdge, int centerNode) {
        PrepareGraphEdgeIterator outIter = this.outEdgeExplorer.setBaseNode(sourceNode);
        while (outIter.next()) {
            double turnWeight = this.calcTurnWeight(sourceEdge, sourceNode, GHUtility.getEdgeFromEdgeKey(outIter.getOrigEdgeKeyFirst()));
            if (Double.isInfinite(turnWeight)) continue;
            double edgeWeight = outIter.getWeight();
            double weight = turnWeight + edgeWeight;
            boolean isPathToCenter = outIter.getAdjNode() == centerNode;
            int key = outIter.getOrigEdgeKeyLast();
            int adjNode = outIter.getAdjNode();
            int parentKey = -key - 1;
            PrepareCHEntry parent = new PrepareCHEntry(-1, outIter.getOrigEdgeKeyFirst(), sourceNode, turnWeight);
            if (!EdgeIterator.Edge.isValid(this.prepareEdges[key])) {
                this.prepareEdges[key] = outIter.getPrepareEdge();
                this.weights[key] = weight;
                this.parents[key] = parentKey;
                this.setAdjNodeAndPathToCenter(key, adjNode, isPathToCenter);
                this.initialEntryParents.put(parentKey, (Object)parent);
                this.changedEdges.add(key);
                continue;
            }
            if (!(weight < this.weights[key])) continue;
            this.prepareEdges[key] = outIter.getPrepareEdge();
            this.weights[key] = weight;
            this.parents[key] = parentKey;
            this.setPathToCenter(key, isPathToCenter);
            this.initialEntryParents.put(parentKey, (Object)parent);
        }
        for (int i = 0; i < this.changedEdges.size(); ++i) {
            int key = this.changedEdges.get(i);
            if (this.isPathToCenter(key)) {
                ++this.numPathsToCenter;
            }
            this.dijkstraHeap.insert(this.weights[key], key);
        }
    }

    private void reset() {
        this.updateMaxSettledEdges();
        this.numSettledEdges = 0;
        this.numPolledEdges = 0;
        this.numPathsToCenter = 0;
        this.resetShortestPathTree();
    }

    private void updateMaxSettledEdges() {
        this.settledEdgesStats.addObservation(this.numSettledEdges);
        if (this.settledEdgesStats.getCount() == (long)this.params.settledEdgeStatsResetInterval) {
            this.maxSettledEdges = Math.max(this.params.minimumMaxSettledEdges, (int)(this.settledEdgesStats.getMean() + this.params.sigmaFactor * Math.sqrt(this.settledEdgesStats.getVariance())));
            this.settledEdgesStats.reset();
        }
    }

    private void resetShortestPathTree() {
        for (int i = 0; i < this.changedEdges.size(); ++i) {
            this.resetEntry(this.changedEdges.get(i));
        }
        this.changedEdges.elementsCount = 0;
        this.initialEntryParents.clear();
        this.dijkstraHeap.clear();
    }

    private void updateBestPath(int targetNode, int targetEdge, int edgeKey) {
        if (this.getAdjNode(edgeKey) == targetNode) {
            double tolerance;
            double totalWeight = this.weights[edgeKey] + this.calcTurnWeight(GHUtility.getEdgeFromEdgeKey(edgeKey), targetNode, targetEdge);
            boolean isBridgePath = this.parents[edgeKey] >= 0 && this.isPathToCenter(this.parents[edgeKey]);
            double d = tolerance = isBridgePath ? 0.0 : 1.0E-6;
            if (totalWeight - tolerance < this.bestPathWeight) {
                this.bestPathWeight = totalWeight;
                this.bestPathIncKey = edgeKey;
                this.bestPathIsBridgePath = isBridgePath;
            }
        }
    }

    private void setEntry(int key, PrepareGraphEdgeIterator edge, double weight, int parent, boolean isPathToCenter) {
        this.prepareEdges[key] = edge.getPrepareEdge();
        this.weights[key] = weight;
        this.parents[key] = parent;
        this.setAdjNodeAndPathToCenter(key, edge.getAdjNode(), isPathToCenter);
        if (isPathToCenter) {
            ++this.numPathsToCenter;
        }
    }

    private void updateEntry(int key, PrepareGraphEdgeIterator edge, double weight, int parent, boolean isPathToCenter) {
        this.prepareEdges[key] = edge.getPrepareEdge();
        this.weights[key] = weight;
        this.parents[key] = parent;
        if (isPathToCenter) {
            if (!this.isPathToCenter(key)) {
                ++this.numPathsToCenter;
            }
        } else if (this.isPathToCenter(key)) {
            --this.numPathsToCenter;
        }
        this.setPathToCenter(key, isPathToCenter);
    }

    private void resetEntry(int key) {
        this.weights[key] = Double.POSITIVE_INFINITY;
        this.prepareEdges[key] = -1;
        this.parents[key] = -1;
        this.setAdjNodeAndPathToCenter(key, -1, false);
    }

    private PrepareCHEntry getEntryForKey(int edgeKey) {
        return new PrepareCHEntry(this.prepareEdges[edgeKey], edgeKey, this.getAdjNode(edgeKey), this.weights[edgeKey]);
    }

    private double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        return this.prepareGraph.getTurnWeight(inEdge, viaNode, outEdge);
    }

    static class Stats {
        private long numSearches;
        private long numPolledEdges;
        private long numSettledEdges;
        private long maxNumSettledEdges;

        Stats() {
        }

        public String toString() {
            return String.format(Locale.ROOT, "limit-exhaustion: %s %%, avg-settled: %s, avg-max-settled: %s, avg-polled-edges: %s", this.quotient(this.numSettledEdges * 100L, this.maxNumSettledEdges), this.quotient(this.numSettledEdges, this.numSearches), this.quotient(this.maxNumSettledEdges, this.numSearches), this.quotient(this.numPolledEdges, this.numSearches));
        }

        private String quotient(long a, long b) {
            return b == 0L ? "NaN" : String.format(Locale.ROOT, "%5.1f", (double)a / (double)b);
        }

        void reset() {
            this.numSearches = 0L;
            this.numPolledEdges = 0L;
            this.numSettledEdges = 0L;
            this.maxNumSettledEdges = 0L;
        }
    }

    static class Params {
        private double sigmaFactor = 3.0;
        private int minimumMaxSettledEdges = 100;
        private int settledEdgeStatsResetInterval = 10000;

        Params() {
        }
    }
}

