/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.LMProfile;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.util.Helper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LMPreparationHandler {
    private final Logger LOGGER = LoggerFactory.getLogger(LMPreparationHandler.class);
    private int landmarkCount = 16;
    private final List<PrepareLandmarks> preparations = new ArrayList<PrepareLandmarks>();
    private final List<LMProfile> lmProfiles = new ArrayList<LMProfile>();
    private final List<LMConfig> lmConfigs = new ArrayList<LMConfig>();
    private final Map<String, Double> maximumWeights = new HashMap<String, Double>();
    private int minNodes = -1;
    private final List<String> lmSuggestionsLocations = new ArrayList<String>(5);
    private int preparationThreads;
    private ExecutorService threadPool;
    private boolean logDetails = false;

    public LMPreparationHandler() {
        this.setPreparationThreads(1);
    }

    public void init(GraphHopperConfig ghConfig) {
        if (ghConfig.has("prepare.lm.weightings")) {
            throw new IllegalStateException("Use profiles_lm instead of prepare.lm.weightings, see #1922 and docs/core/profiles.md");
        }
        this.setPreparationThreads(ghConfig.getInt("prepare.lm.threads", this.getPreparationThreads()));
        this.setLMProfiles(ghConfig.getLMProfiles());
        this.landmarkCount = ghConfig.getInt("prepare.lm.landmarks", this.landmarkCount);
        this.logDetails = ghConfig.getBool("prepare.lm.log_details", false);
        this.minNodes = ghConfig.getInt("prepare.lm.min_network_size", -1);
        for (String loc : ghConfig.getString("prepare.lm.suggestions_location", "").split(",")) {
            if (loc.trim().isEmpty()) continue;
            this.lmSuggestionsLocations.add(loc.trim());
        }
    }

    public int getLandmarks() {
        return this.landmarkCount;
    }

    public final boolean isEnabled() {
        return !this.lmProfiles.isEmpty() || !this.lmConfigs.isEmpty() || !this.preparations.isEmpty();
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public void setPreparationThreads(int preparationThreads) {
        this.preparationThreads = preparationThreads;
        this.threadPool = Executors.newFixedThreadPool(preparationThreads);
    }

    public LMPreparationHandler setLMProfiles(LMProfile ... lmProfiles) {
        return this.setLMProfiles(Arrays.asList(lmProfiles));
    }

    public LMPreparationHandler setLMProfiles(Collection<LMProfile> lmProfiles) {
        this.lmProfiles.clear();
        this.maximumWeights.clear();
        for (LMProfile profile : lmProfiles) {
            if (profile.usesOtherPreparation()) continue;
            this.maximumWeights.put(profile.getProfile(), profile.getMaximumLMWeight());
        }
        this.lmProfiles.addAll(lmProfiles);
        return this;
    }

    public List<LMProfile> getLMProfiles() {
        return this.lmProfiles;
    }

    public LMPreparationHandler addLMConfig(LMConfig lmConfig) {
        this.lmConfigs.add(lmConfig);
        return this;
    }

    public LMPreparationHandler addPreparation(PrepareLandmarks plm) {
        this.preparations.add(plm);
        int lastIndex = this.preparations.size() - 1;
        if (lastIndex >= this.lmConfigs.size()) {
            throw new IllegalStateException("Cannot access profile for PrepareLandmarks with " + plm.getLMConfig() + ". Call add(LMConfig) before");
        }
        if (this.preparations.get(lastIndex).getLMConfig() != this.lmConfigs.get(lastIndex)) {
            throw new IllegalArgumentException("LMConfig of PrepareLandmarks " + this.preparations.get(lastIndex).getLMConfig() + " needs to be identical to previously added " + this.lmConfigs.get(lastIndex));
        }
        return this;
    }

    public boolean hasLMProfiles() {
        return !this.lmConfigs.isEmpty();
    }

    public int size() {
        return this.preparations.size();
    }

    public List<LMConfig> getLMConfigs() {
        return this.lmConfigs;
    }

    public List<PrepareLandmarks> getPreparations() {
        return this.preparations;
    }

    public PrepareLandmarks getPreparation(String profile) {
        if (this.preparations.isEmpty()) {
            throw new IllegalStateException("No LM preparations added yet");
        }
        ArrayList<String> profileNames = new ArrayList<String>(this.preparations.size());
        for (PrepareLandmarks preparation : this.preparations) {
            profileNames.add(preparation.getLMConfig().getName());
            if (!preparation.getLMConfig().getName().equals(profile)) continue;
            return preparation;
        }
        throw new IllegalArgumentException("Cannot find LM preparation for the requested profile: '" + profile + "'\nYou can try disabling LM using " + "lm.disable" + "=true\navailable LM profiles: " + profileNames);
    }

    public boolean loadOrDoWork(StorableProperties properties, boolean closeEarly) {
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(this.threadPool);
        int counter = 0;
        AtomicBoolean prepared = new AtomicBoolean(false);
        for (PrepareLandmarks plm : this.preparations) {
            int tmpCounter = ++counter;
            String name = plm.getLMConfig().getName();
            completionService.submit(() -> {
                if (plm.loadExisting()) {
                    return;
                }
                this.LOGGER.info(tmpCounter + "/" + this.getPreparations().size() + " calling LM prepare.doWork for " + plm.getLMConfig().getWeighting() + " ... (" + Helper.getMemInfo() + ")");
                prepared.set(true);
                Thread.currentThread().setName(name);
                plm.doWork();
                if (closeEarly) {
                    plm.close();
                }
                this.LOGGER.info("LM {} finished {}", (Object)name, (Object)Helper.getMemInfo());
                properties.put("prepare.lm.date." + name, Helper.createFormatter().format(new Date()));
            }, name);
        }
        this.threadPool.shutdown();
        try {
            for (int i = 0; i < this.preparations.size(); ++i) {
                completionService.take().get();
            }
        }
        catch (Exception e) {
            this.threadPool.shutdownNow();
            throw new RuntimeException(e);
        }
        this.LOGGER.info("Finished LM preparation, {}", (Object)Helper.getMemInfo());
        return prepared.get();
    }

    public void createPreparations(GraphHopperStorage ghStorage, LocationIndex locationIndex) {
        if (!this.isEnabled() || !this.preparations.isEmpty()) {
            return;
        }
        if (this.lmConfigs.isEmpty()) {
            throw new IllegalStateException("No landmark weightings found");
        }
        this.LOGGER.info("Creating LM preparations, {}", (Object)Helper.getMemInfo());
        ArrayList<LandmarkSuggestion> lmSuggestions = new ArrayList<LandmarkSuggestion>(this.lmSuggestionsLocations.size());
        if (!this.lmSuggestionsLocations.isEmpty()) {
            try {
                for (String loc : this.lmSuggestionsLocations) {
                    lmSuggestions.add(LandmarkSuggestion.readLandmarks(loc, locationIndex));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        for (LMConfig lmConfig : this.lmConfigs) {
            Double maximumWeight = this.maximumWeights.get(lmConfig.getName());
            if (maximumWeight == null) {
                throw new IllegalStateException("maximumWeight cannot be null. Default should be just negative. Couldn't find " + lmConfig.getName() + " in " + this.maximumWeights);
            }
            PrepareLandmarks tmpPrepareLM = new PrepareLandmarks(ghStorage.getDirectory(), ghStorage, lmConfig, this.landmarkCount).setLandmarkSuggestions(lmSuggestions).setMaximumWeight(maximumWeight).setLogDetails(this.logDetails);
            if (this.minNodes > 1) {
                tmpPrepareLM.setMinimumNodes(this.minNodes);
            }
            this.addPreparation(tmpPrepareLM);
        }
    }
}

