/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.util.EdgeIteratorState;

public class DefaultEdgeFilter
implements EdgeFilter {
    private final boolean bwd;
    private final boolean fwd;
    private final BooleanEncodedValue accessEnc;

    private DefaultEdgeFilter(BooleanEncodedValue accessEnc, boolean fwd, boolean bwd) {
        this.accessEnc = accessEnc;
        this.fwd = fwd;
        this.bwd = bwd;
    }

    public static DefaultEdgeFilter outEdges(BooleanEncodedValue accessEnc) {
        return new DefaultEdgeFilter(accessEnc, true, false);
    }

    public static DefaultEdgeFilter inEdges(BooleanEncodedValue accessEnc) {
        return new DefaultEdgeFilter(accessEnc, false, true);
    }

    public static DefaultEdgeFilter allEdges(BooleanEncodedValue accessEnc) {
        return new DefaultEdgeFilter(accessEnc, true, true);
    }

    public static DefaultEdgeFilter outEdges(FlagEncoder flagEncoder) {
        return DefaultEdgeFilter.outEdges(flagEncoder.getAccessEnc());
    }

    public static DefaultEdgeFilter inEdges(FlagEncoder flagEncoder) {
        return DefaultEdgeFilter.inEdges(flagEncoder.getAccessEnc());
    }

    public static DefaultEdgeFilter allEdges(FlagEncoder flagEncoder) {
        return DefaultEdgeFilter.allEdges(flagEncoder.getAccessEnc());
    }

    public BooleanEncodedValue getAccessEnc() {
        return this.accessEnc;
    }

    @Override
    public final boolean accept(EdgeIteratorState iter) {
        if (iter.getBaseNode() == iter.getAdjNode()) {
            return iter.get(this.accessEnc) || iter.getReverse(this.accessEnc);
        }
        return this.fwd && iter.get(this.accessEnc) || this.bwd && iter.getReverse(this.accessEnc);
    }

    public String toString() {
        return this.accessEnc.toString() + ", bwd:" + this.bwd + ", fwd:" + this.fwd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultEdgeFilter that = (DefaultEdgeFilter)o;
        if (this.bwd != that.bwd) {
            return false;
        }
        if (this.fwd != that.fwd) {
            return false;
        }
        return this.accessEnc.equals(that.accessEnc);
    }

    public int hashCode() {
        int result = this.bwd ? 1 : 0;
        result = 31 * result + (this.fwd ? 1 : 0);
        result = 31 * result + this.accessEnc.hashCode();
        return result;
    }
}

