/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.ResponsePath;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TestAlgoCollector {
    public final List<String> errors = new ArrayList<String>();
    private final String name;
    private final DistanceCalc distCalc = DistanceCalcEarth.DIST_EARTH;
    private final TranslationMap trMap = new TranslationMap().doImport();

    public TestAlgoCollector(String name) {
        this.name = name;
    }

    public TestAlgoCollector assertDistance(EncodingManager encodingManager, AlgoHelperEntry algoEntry, List<Snap> queryList, OneRun oneRun) {
        ArrayList<Path> altPaths = new ArrayList<Path>();
        QueryGraph queryGraph = QueryGraph.create(algoEntry.graph, queryList);
        for (int i = 0; i < queryList.size() - 1; ++i) {
            RoutingAlgorithm algo = algoEntry.createAlgo(queryGraph);
            Path path = algo.calcPath(queryList.get(i).getClosestNode(), queryList.get(i + 1).getClosestNode());
            altPaths.add(path);
        }
        PathMerger pathMerger = new PathMerger(queryGraph.getBaseGraph(), algoEntry.getAlgorithmOptions().getWeighting()).setCalcPoints(true).setSimplifyResponse(false).setEnableInstructions(true);
        ResponsePath responsePath = pathMerger.doWork(new PointList(), altPaths, encodingManager, this.trMap.getWithFallBack(Locale.US));
        if (responsePath.hasErrors()) {
            this.errors.add("response for " + algoEntry + " contains errors. Expected distance: " + oneRun.getDistance() + ", expected points: " + oneRun + ". " + queryList + ", errors:" + responsePath.getErrors());
            return this;
        }
        PointList pointList = responsePath.getPoints();
        double tmpDist = this.distCalc.calcDistance(pointList);
        if (Math.abs(responsePath.getDistance() - tmpDist) > 2.0) {
            this.errors.add(algoEntry + " path.getDistance was  " + responsePath.getDistance() + "\t pointList.calcDistance was " + tmpDist + "\t (expected points " + oneRun.getLocs() + ", expected distance " + oneRun.getDistance() + ") " + queryList);
        }
        if (Math.abs(responsePath.getDistance() - oneRun.getDistance()) > 2.0) {
            this.errors.add(algoEntry + " returns path not matching the expected distance of " + oneRun.getDistance() + "\t Returned was " + responsePath.getDistance() + "\t (expected points " + oneRun.getLocs() + ", was " + pointList.getSize() + ") \t (weight " + responsePath.getRouteWeight() + ") " + queryList);
        }
        if (Math.abs(pointList.getSize() - oneRun.getLocs()) > 1) {
            this.errors.add(algoEntry + " returns path not matching the expected points of " + oneRun.getLocs() + "\t Returned was " + pointList.getSize() + "\t (expected distance " + oneRun.getDistance() + ", was " + responsePath.getDistance() + ") " + queryList);
        }
        return this;
    }

    void queryIndex(Graph g, LocationIndex idx, double lat, double lon, double expectedDist) {
        Snap res = idx.findClosest(lat, lon, EdgeFilter.ALL_EDGES);
        if (!res.isValid()) {
            this.errors.add("node not found for " + lat + "," + lon);
            return;
        }
        GHPoint3D found = res.getSnappedPoint();
        double dist = this.distCalc.calcDist(lat, lon, found.lat, found.lon);
        if (Math.abs(dist - expectedDist) > 0.1) {
            this.errors.add("queried lat,lon=" + (float)lat + "," + (float)lon + " (found: " + (float)found.lat + "," + (float)found.lon + ")\n   expected distance:" + expectedDist + ", but was:" + dist);
        }
    }

    public String toString() {
        String str = "";
        str = str + "FOUND " + this.errors.size() + " ERRORS.\n";
        for (String s : this.errors) {
            str = str + s + ".\n";
        }
        return str;
    }

    void printSummary() {
        if (this.errors.size() > 0) {
            System.out.println("\n-------------------------------\n");
            System.out.println(this.toString());
        } else {
            System.out.println("SUCCESS for " + this.name + "!");
        }
    }

    static class AssumptionPerPath {
        double lat;
        double lon;
        int locs;
        double distance;

        public AssumptionPerPath(double lat, double lon, double distance, int locs) {
            this.lat = lat;
            this.lon = lon;
            this.locs = locs;
            this.distance = distance;
        }

        public String toString() {
            return this.lat + ", " + this.lon + ", locs:" + this.locs + ", dist:" + this.distance;
        }
    }

    public static class OneRun {
        private final List<AssumptionPerPath> assumptions = new ArrayList<AssumptionPerPath>();

        public OneRun() {
        }

        public OneRun(double fromLat, double fromLon, double toLat, double toLon, double dist, int locs) {
            this.add(fromLat, fromLon, 0.0, 0);
            this.add(toLat, toLon, dist, locs);
        }

        public OneRun add(double lat, double lon, double dist, int locs) {
            this.assumptions.add(new AssumptionPerPath(lat, lon, dist, locs));
            return this;
        }

        public int getLocs() {
            int sum = 0;
            for (AssumptionPerPath as : this.assumptions) {
                sum += as.locs;
            }
            return sum;
        }

        public void setLocs(int index, int locs) {
            this.assumptions.get((int)index).locs = locs;
        }

        public double getDistance() {
            double sum = 0.0;
            for (AssumptionPerPath as : this.assumptions) {
                sum += as.distance;
            }
            return sum;
        }

        public void setDistance(int index, double dist) {
            this.assumptions.get((int)index).distance = dist;
        }

        public List<Snap> getList(LocationIndex idx, EdgeFilter edgeFilter) {
            ArrayList<Snap> snap = new ArrayList<Snap>();
            for (AssumptionPerPath p : this.assumptions) {
                snap.add(idx.findClosest(p.lat, p.lon, edgeFilter));
            }
            return snap;
        }

        public String toString() {
            return this.assumptions.toString();
        }
    }

    public static class AlgoHelperEntry {
        private final LocationIndex idx;
        private Graph graph;
        private boolean ch;
        private String expectedAlgo;
        private AlgorithmOptions opts;

        public AlgoHelperEntry(Graph g, boolean ch, AlgorithmOptions opts, LocationIndex idx, String expectedAlgo) {
            this.graph = g;
            this.ch = ch;
            this.opts = opts;
            this.idx = idx;
            this.expectedAlgo = expectedAlgo;
        }

        public void setAlgorithmOptions(AlgorithmOptions opts) {
            this.opts = opts;
        }

        public RoutingAlgorithm createAlgo(Graph graph) {
            return new RoutingAlgorithmFactorySimple().createAlgo(graph, this.opts);
        }

        public AlgorithmOptions getAlgorithmOptions() {
            return this.opts;
        }

        public LocationIndex getIdx() {
            return this.idx;
        }

        public String getExpectedAlgo() {
            return this.expectedAlgo;
        }

        public String toString() {
            String algo = this.opts.getAlgorithm();
            if (this.getExpectedAlgo().contains("landmarks")) {
                algo = algo + "|landmarks";
            }
            if (this.ch) {
                algo = algo + "|ch";
            }
            return "algoEntry(" + algo + ")";
        }
    }
}

